/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;
import flanagan.math.Conv;
import flanagan.math.Fmath;

public class AtoD
extends BlackBox {
    private int nBits = 0;
    private long maximumDecimal = 0L;
    private double vRef = 0.0;
    private int[] vBinary = null;
    private boolean trueAtoD = true;
    private boolean range = true;
    private double voltageOutput = 0.0;
    private String binaryOutput = "";
    private long decimalOutput = 0L;
    private double sqnr = 0.0;
    private double input = 0.0;
    private double inputC = 0.0;
    private double shift = 0.0;
    private long decimalShift = 0L;
    private boolean decCalcDone = false;
    private boolean binCalcDone = false;
    private boolean inputSet = false;
    private boolean firstCopy = true;

    public AtoD(int nBits, double vRef) {
        super("AtoD");
        if (nBits > 63) {
            throw new IllegalArgumentException("This program cannot accomadate an ADC simulation with a number of bits greater than 63");
        }
        this.nBits = nBits;
        this.maximumDecimal = (long)Math.pow(2.0, this.nBits) - 1L;
        this.vRef = vRef;
        this.vBinary = new int[nBits + 1];
        this.trueAtoD = true;
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0));
        super.setZtransformMethod(1);
    }

    public AtoD() {
        super("AtoD");
        this.fixedName = "AtoD";
        this.sNumerDeg = 0;
        this.sDenomDeg = 0;
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0));
        this.ztransMethod = 1;
        super.setZtransformMethod(1);
    }

    public void setRangeOption(int opt) {
        if (opt < 0 || opt > 2) {
            throw new IllegalArgumentException("argument must be either 0 or 1");
        }
        if (opt == 0) {
            this.range = true;
        }
        if (opt == 1) {
            this.range = false;
            this.shift = this.vRef / 2.0;
            this.decimalShift = this.maximumDecimal / 2L;
        }
        if (this.inputSet) {
            this.checkInput();
        }
        this.decCalcDone = false;
    }

    public String getRange() {
        String ran = null;
        if (this.trueAtoD) {
            ran = this.range ? "0 to " + this.vRef : "-" + this.vRef / 2.0 + " to " + this.vRef / 2.0;
        } else {
            System.out.println("Class AtoD; method getRange()");
            System.out.println("No range option set - this instance of AtoD is an 'ADC marker' only");
            System.out.println("getRangeOption has returned 'ADC marker only'");
            ran = "ADC marker only";
        }
        return ran;
    }

    public boolean getTrueAtoDoption() {
        if (this.trueAtoD) {
            System.out.println("This instance of AtoD is a true simulation of an ADC");
            System.out.println("getTrueAtoDoption has returned 'true'");
        } else {
            System.out.println("This instance of AtoD is not a true simulation of an ADC");
            System.out.println("It is simple an 'A to D marker'");
            System.out.println("getTrueAtoDoption has returned 'false'");
        }
        return this.trueAtoD;
    }

    public double getVref() {
        if (!this.trueAtoD) {
            System.out.println("No reference voltage set - this instance of AtoD is an 'ADC marker' only");
            System.out.println("getVref has returned 0.0 V");
        }
        return this.vRef;
    }

    public void setInput(double input) {
        this.input = input;
        this.checkInput();
        this.inputSet = true;
    }

    public void checkInput() {
        this.inputC = this.input;
        if (this.trueAtoD) {
            if (this.range) {
                if (this.input < 0.0) {
                    System.out.println("lower limit of the ADC range exceeded");
                    System.out.println("input voltage set to zero");
                    this.inputC = 0.0;
                }
                if (this.input > this.vRef) {
                    System.out.println("upper limit of the ADC range exceeded");
                    System.out.println("input voltage set to " + this.vRef);
                    this.inputC = this.vRef;
                }
            } else {
                if (this.input < -this.vRef) {
                    System.out.println("lower limit of the ADC range exceeded");
                    System.out.println("input voltage set to " + -this.vRef / 2.0);
                    this.inputC = -this.vRef / 2.0;
                }
                if (this.input > this.vRef) {
                    System.out.println("upper limit of the ADC range exceeded");
                    System.out.println("input voltage set to " + this.vRef / 2.0);
                    this.inputC = this.vRef / 2.0;
                }
            }
        }
        this.inputC += this.shift;
        this.decCalcDone = false;
        this.binCalcDone = false;
    }

    public long getMaximumDecimal() {
        if (!this.trueAtoD) {
            System.out.println("This instance of AtoD is not a true simulation of an ADC");
            System.out.println("It is simple an 'A to D marker'");
            System.out.println("getTrueAtoDoption has returned 0");
        }
        return this.maximumDecimal;
    }

    public double maximumQuantizationError() {
        double error = 0.0;
        if (this.trueAtoD) {
            error = this.vRef / (double)this.maximumDecimal;
        } else {
            System.out.println("This instance of AtoD is not a true simulation of an ADC");
            System.out.println("It is simple an 'A to D marker'");
            System.out.println("getMaxQuantizationError returns zero");
        }
        return error;
    }

    public void calcOutput() {
        if (this.trueAtoD) {
            this.decimalOutput = (long)Math.floor(this.inputC / this.vRef * (double)this.maximumDecimal) - this.decimalShift;
            this.voltageOutput = this.vRef * (double)this.decimalOutput / (double)this.maximumDecimal;
            this.sqnr = 20.0 * Fmath.log10(Math.abs((this.inputC - this.shift) / (this.inputC - this.shift - this.voltageOutput)));
        } else {
            this.voltageOutput = this.input;
            this.sqnr = Double.POSITIVE_INFINITY;
        }
        this.sNumer.resetCoeff(0, new Complex(this.voltageOutput / this.input, 0.0));
        this.decCalcDone = true;
    }

    public double getSQNR() {
        if (!this.decCalcDone) {
            this.calcOutput();
        }
        if (!this.trueAtoD) {
            System.out.println("This instance of AtoD is not a true simulation of an ADC");
            System.out.println("It is simple an 'A to D marker'");
            System.out.println("getSQNR returned INFINITY");
        }
        return this.sqnr;
    }

    public double voltageOutput() {
        if (!this.decCalcDone) {
            this.calcOutput();
        }
        return this.voltageOutput;
    }

    public long decimalOutput() {
        if (!this.decCalcDone) {
            this.calcOutput();
        }
        if (!this.trueAtoD) {
            System.out.println("No formal A to D conversion performed - this instance of AtoD is an 'ADC marker' only");
            System.out.println("decimalOutput has returned 0");
        }
        return this.decimalOutput;
    }

    public static int[] decimalToBinary(long decimal, int nBits) {
        long len;
        long decSign = 1L;
        if (decimal < 0L) {
            decSign = -1L;
            decimal *= decSign;
        }
        if ((long)nBits < (len = (long)Math.ceil(Math.log(decimal) / Math.log(2.0)))) {
            boolean test = true;
            int ii = 2;
            while (test) {
                if (!(Math.pow(2.0, ii) > (double)len)) continue;
                nBits = ii;
                test = false;
            }
        }
        int[] binary = new int[nBits];
        for (int i = 0; i < nBits; ++i) {
            binary[i] = 0;
        }
        boolean test = true;
        int ii = 0;
        while (test) {
            binary[ii] = (int)(decimal % 2L);
            ++ii;
            if ((decimal /= 2L) != 0L) continue;
            test = false;
        }
        if (decSign == -1L) {
            binary = AtoD.negateBinary(binary);
        }
        return binary;
    }

    public static int[] negateBinary(int[] binary) {
        int i;
        int nBinary;
        int nBin = nBinary = binary.length;
        if (binary[nBinary - 1] == 1) {
            nBin += nBin;
        }
        int[] negate = new int[nBin];
        int[] one = new int[nBin];
        for (i = 0; i < nBin; ++i) {
            one[i] = 0;
            negate[i] = 1;
        }
        one[0] = 1;
        for (i = 0; i < nBinary; ++i) {
            if (binary[i] != 1) continue;
            negate[i] = 0;
        }
        negate = AtoD.addBinary(negate, one);
        return negate;
    }

    public static int[] addBinary(int[] aa, int[] bb) {
        int n = aa.length;
        int m = bb.length;
        int lenMax = n;
        int lenMin = m;
        if (m > n) {
            lenMax = m;
            lenMin = n;
        }
        int[] addition = new int[lenMax];
        int carry = 0;
        int sum = 0;
        block6: for (int i = 0; i < lenMin; ++i) {
            sum = aa[i] + bb[i] + carry;
            switch (sum) {
                case 0: {
                    addition[i] = 0;
                    carry = 0;
                    continue block6;
                }
                case 1: {
                    addition[i] = 1;
                    carry = 0;
                    continue block6;
                }
                case 2: {
                    addition[i] = 0;
                    carry = 1;
                    continue block6;
                }
                case 3: {
                    addition[i] = 1;
                    carry = 1;
                }
            }
        }
        return addition;
    }

    public String binaryOutput() {
        if (!this.decCalcDone) {
            this.calcOutput();
        }
        if (this.trueAtoD) {
            int nBit = this.nBits + 1;
            long absDecOut = this.decimalOutput + this.decimalShift;
            this.vBinary = AtoD.decimalToBinary(absDecOut, nBit);
            if (this.shift > 0.0) {
                int[] binaryShift = AtoD.decimalToBinary(this.decimalShift, nBit);
                binaryShift = AtoD.negateBinary(binaryShift);
                this.vBinary = AtoD.addBinary(this.vBinary, binaryShift);
            }
            this.binaryOutput = "";
            for (int i = nBit - 1; i >= 0; --i) {
                this.binaryOutput = this.binaryOutput + this.vBinary[i];
            }
        } else {
            System.out.println("No formal A to D conversion performed - this instance of AtoD is an 'ADC marker' only");
            System.out.println("binaryOutput has returned 'null'");
        }
        this.binCalcDone = true;
        return this.binaryOutput;
    }

    public int[] binaryArray() {
        if (this.trueAtoD) {
            if (!this.binCalcDone) {
                this.binaryOutput();
            }
        } else {
            System.out.println("No formal A to D conversion performed - this instance of AtoD is an 'ADC marker' only");
            System.out.println("binaryOutput has returned 'null'");
        }
        return this.vBinary;
    }

    public double quantizationError() {
        if (!this.decCalcDone) {
            this.calcOutput();
        }
        double error = 0.0;
        if (this.trueAtoD) {
            error = this.inputC - this.voltageOutput;
        } else {
            System.out.println("This instance of AtoD is not a true simulation of an ADC");
            System.out.println("It is simple an 'A to D marker'");
            System.out.println("getQuantizationError returns zero");
        }
        return error;
    }

    public double clippingError() {
        return this.inputC - this.input;
    }

    @Override
    public AtoD copy() {
        if (this == null) {
            return null;
        }
        AtoD bb = new AtoD();
        this.copyBBvariables(bb);
        bb.nBits = this.nBits;
        bb.maximumDecimal = this.maximumDecimal;
        bb.vRef = this.vRef;
        bb.vBinary = Conv.copy(this.vBinary);
        bb.trueAtoD = this.trueAtoD;
        bb.range = this.range;
        bb.voltageOutput = this.voltageOutput;
        bb.binaryOutput = this.binaryOutput;
        bb.decimalOutput = this.decimalOutput;
        bb.sqnr = this.sqnr;
        bb.input = this.input;
        bb.inputC = this.inputC;
        bb.shift = this.shift;
        bb.decimalShift = this.decimalShift;
        bb.decCalcDone = this.decCalcDone;
        bb.binCalcDone = this.binCalcDone;
        bb.inputSet = this.inputSet;
        return bb;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

