/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.vcf;

import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VcfInfo {
    String line;
    String id;
    VcfInfoType vcfInfoType;
    int number;
    boolean onePerAllele;
    boolean onePerGenotype;
    String description;

    public VcfInfo(String line) {
        Matcher matcher;
        if (line.startsWith("##INFO=") || line.startsWith("##FORMAT=")) {
            while (line.endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
            this.line = line;
            int start = line.indexOf(60);
            int end = line.lastIndexOf(62);
            String params = line.substring(start + 1, end);
            Pattern pattern = Pattern.compile("ID=([^,]+),");
            matcher = pattern.matcher(params);
            if (!matcher.find()) {
                throw new RuntimeException("Cannot find 'ID' in info line: '" + line + "'");
            }
            this.id = matcher.group(1);
            pattern = Pattern.compile("Number=([^,]+),");
            matcher = pattern.matcher(params);
            if (!matcher.find()) {
                throw new RuntimeException("Cannot find 'Number' in info line: '" + line + "'");
            }
            this.parseNumber(matcher.group(1));
            pattern = Pattern.compile("Type=([^,]+),");
            matcher = pattern.matcher(params);
            if (!matcher.find()) {
                throw new RuntimeException("Cannot find 'Type' in info line: '" + line + "'");
            }
            this.vcfInfoType = VcfInfoType.parse(matcher.group(1).toUpperCase());
            pattern = Pattern.compile("Description=\\\"(.+)\\\"");
            matcher = pattern.matcher(params);
            if (!matcher.find()) {
                throw new RuntimeException("Cannot find 'Description' in info line: '" + line + "'");
            }
        } else {
            throw new RuntimeException("Line provided is not an INFO definition: '" + line + "'");
        }
        this.description = matcher.group(1);
    }

    public VcfInfo(String id, VcfInfoType vcfInfoType, String number, String description) {
        this.id = id;
        this.vcfInfoType = vcfInfoType;
        this.description = description;
        this.parseNumber(number);
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public int getNumber() {
        return this.number;
    }

    public VcfInfoType getVcfInfoType() {
        return this.vcfInfoType;
    }

    public boolean isOnePerAllele() {
        return this.onePerAllele;
    }

    public boolean isOnePerGenotype() {
        return this.onePerGenotype;
    }

    void parseNumber(String number) {
        if (number.equals("A")) {
            this.onePerAllele = true;
        } else if (number.equals("G")) {
            this.onePerGenotype = true;
        } else {
            this.number = Gpr.parseIntSafe(number);
        }
    }

    public String toString() {
        if (this.line != null) {
            return this.line;
        }
        return "##INFO=<ID=" + this.id + ",Number=" + (this.onePerAllele ? "A" : (this.onePerGenotype ? "G" : Integer.valueOf(this.number))) + ",Type=" + (Object)((Object)this.vcfInfoType) + ",Description=\"" + this.description + "\"" + ">";
    }
}

