/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.format;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.format.FileFormatter;
import org.apache.maven.plugin.assembly.model.FileSet;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;

public class FileSetFormatter {
    private final AssemblerConfigurationSource configSource;
    private final Logger logger;

    public FileSetFormatter(AssemblerConfigurationSource configSource, Logger logger) {
        this.configSource = configSource;
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File formatFileSetForAssembly(File fileSetDir, FileSet set) throws AssemblyFormattingException, IOException {
        String lineEndingHint = set.getLineEnding();
        String lineEnding = AssemblyFileUtils.getLineEndingCharacters(lineEndingHint);
        if (lineEnding == null && !set.isFiltered()) {
            this.logger.debug("NOT reformatting any files in " + fileSetDir);
            return fileSetDir;
        }
        org.apache.maven.shared.model.fileset.FileSet fileSet = new org.apache.maven.shared.model.fileset.FileSet();
        fileSet.setLineEnding(lineEnding);
        fileSet.setDirectory(fileSetDir.getAbsolutePath());
        fileSet.setIncludes(set.getIncludes());
        fileSet.setExcludes(set.getExcludes());
        fileSet.setUseDefaultExcludes(true);
        FileSetManager fsm = new FileSetManager(this.logger);
        String[] files = fsm.getIncludedFiles(fileSet);
        if (files == null || files.length == 0) {
            this.logger.info("No files selected for line-ending conversion or filtering. Skipping: " + fileSet.getDirectory());
            return fileSetDir;
        }
        File formattedDir = FileUtils.createTempFile((String)"fileSetFormatter.", (String)".tmp", (File)this.configSource.getTemporaryRootDirectory());
        this.logger.debug("Filtering files from: " + fileSetDir + " into temp dir: " + formattedDir);
        formattedDir.delete();
        formattedDir.mkdirs();
        FileFormatter fileFormatter = new FileFormatter(this.configSource, this.logger);
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            this.logger.debug("Filtering: " + file);
            File targetFile = new File(formattedDir, file);
            targetFile.getParentFile().mkdirs();
            File sourceFile = new File(fileSetDir, file);
            try {
                sourceFile = fileFormatter.format(sourceFile, set.isFiltered(), lineEndingHint, formattedDir, this.configSource.getEncoding());
                AssemblyFileUtils.copyFile(sourceFile, targetFile);
            }
            catch (AssemblyFormattingException e) {
                FileSetFormatter.deleteDirectory(formattedDir);
                throw e;
            }
            catch (IOException e) {
                FileSetFormatter.deleteDirectory(formattedDir);
                throw e;
            }
            ++i;
        }
        return formattedDir;
    }

    private static void deleteDirectory(File formattedDir) {
        try {
            FileUtils.deleteDirectory((File)formattedDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

