/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.lookup.lookupUtils;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.BlockCompressedOutputStream;
import org.apache.log4j.Logger;

public class IndexUtils {
    private File mBgzipFile;
    private Logger mLogger = Logger.getLogger(IndexUtils.class);

    public IndexUtils() {
    }

    public IndexUtils(File bgzipfile) {
        this.mBgzipFile = bgzipfile;
    }

    public static void main(String[] args) {
        try {
            System.out.println("IndexUtils loading...");
            double start = System.currentTimeMillis();
            String bgzip = args[0];
            String delim = args[1];
            if ("TAB".equalsIgnoreCase(delim)) {
                delim = "\t";
            }
            String keyCol = args[2];
            String jsonPath = args[3];
            String indexOutFile = args[4];
            IndexUtils utils = new IndexUtils(new File(""));
            utils.loadIndexTxt(new File("/Users/m054457/Downloads/UcscDbSnp135/chr1.index.rsId.sorted.txt"));
            double end = System.currentTimeMillis();
            System.out.println("Done.  Elapsed time: " + (end - start) / 1000.0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void zipIndexesToTextFile(File bgzipFile, String delimiter, int keyColumn, File txtIndexOut) throws SQLException, IOException {
        this.zipIndexesToTextFile(bgzipFile, delimiter, keyColumn, null, txtIndexOut);
    }

    public Properties zipIndexesToTextFile(File bgzipFile, String delimiter, int keyColumn, String jsonPathToKey, File txtIndexOut) throws SQLException, IOException {
        BlockCompressedInputStream instr = new BlockCompressedInputStream(bgzipFile);
        JsonPath jsonPath = null;
        if (jsonPathToKey != null && jsonPathToKey.length() > 0) {
            jsonPath = JsonPath.compile((String)jsonPathToKey, (Filter[])new Filter[0]);
        }
        String line = null;
        FileOutputStream fout = new FileOutputStream(txtIndexOut);
        long pos = 0L;
        boolean isFirstLine = true;
        int MB = 0x100000;
        int numObjects = 0;
        System.out.println("numObjs\tMem_MBs\tkey");
        int maxKeyLen = 0;
        boolean areAllKeysInts = true;
        do {
            if (!isFirstLine) {
                pos = instr.getFilePointer();
            }
            line = instr.readLine();
            isFirstLine = false;
            if (line == null || line.startsWith("#")) continue;
            ++numObjects;
            String[] cols = line.split(delimiter);
            if (keyColumn == -1) {
                keyColumn = cols.length;
            }
            String key = cols[keyColumn - 1];
            if (jsonPathToKey != null && jsonPathToKey.length() > 0) {
                try {
                    key = "" + jsonPath.read(key);
                }
                catch (InvalidPathException e) {
                    continue;
                }
            }
            if (key.length() > maxKeyLen) {
                maxKeyLen = key.length();
            }
            if (!IndexUtils.isInteger(key)) {
                areAllKeysInts = false;
            }
            fout.write((key + "\t" + pos + "\n").getBytes());
            if (numObjects % 10000 != 0) continue;
            System.out.println(numObjects + "\t" + this.getMemoryUse() / 0x100000L + "\t" + key);
        } while (line != null);
        fout.close();
        System.out.println("Num objects read: " + numObjects);
        System.out.println("Max key length: " + maxKeyLen);
        Properties props = new Properties();
        props.put((Object)IndexBuilderPropKeys.MaxKeyLen, (Object)maxKeyLen);
        props.put((Object)IndexBuilderPropKeys.IsKeyColAnInt, (Object)areAllKeysInts);
        props.put((Object)IndexBuilderPropKeys.NumLines, (Object)numObjects);
        return props;
    }

    public static String pad(String s, int len) {
        char[] sp = new char[len - s.length()];
        Arrays.fill(sp, ' ');
        return s + new String(sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, List<String>> getBgzipLinesByIndex(File bgzipFile, HashMap<String, List<Long>> indexes) throws IOException {
        BlockCompressedInputStream instr = new BlockCompressedInputStream(bgzipFile);
        HashMap<String, List<String>> linesOut = new HashMap<String, List<String>>();
        String line = null;
        TreeSet<String> sortedKeys = new TreeSet<String>(indexes.keySet());
        List<Long> positions = null;
        try {
            for (String id : sortedKeys) {
                positions = indexes.get(id);
                List<String> linesForId = linesOut.get(id);
                if (linesForId == null) {
                    linesForId = new ArrayList<String>();
                    linesOut.put(id, linesForId);
                }
                for (Long pos : positions) {
                    instr.seek(pos.longValue());
                    line = instr.readLine();
                    if (line == null) continue;
                    linesForId.add(line);
                }
            }
        }
        catch (Exception e) {
            this.mLogger.error((Object)("Error seeking into bgz file, or reading the line at positions " + positions.toString() + ".  File: " + this.mBgzipFile));
        }
        finally {
            instr.close();
        }
        return linesOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, List<String>> getBgzipLinesByIndex(File bgzipFile, String idToFind, List<Long> indexes) throws IOException {
        BlockCompressedInputStream instr = new BlockCompressedInputStream(bgzipFile);
        HashMap<String, List<String>> linesOut = new HashMap<String, List<String>>();
        String line = null;
        ArrayList<String> linesForId = new ArrayList<String>();
        try {
            for (Long pos : indexes) {
                instr.seek(pos.longValue());
                line = instr.readLine();
                if (line == null) continue;
                linesForId.add(line);
            }
            linesOut.put(idToFind, linesForId);
        }
        catch (Exception e) {
            this.mLogger.error((Object)("Error seeking into bgz file, or reading the line at positions " + indexes.toString() + ".  File: " + this.mBgzipFile));
        }
        finally {
            instr.close();
        }
        return linesOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBgzipLineByPosition(Long position) throws IOException {
        BlockCompressedInputStream instr = new BlockCompressedInputStream(this.mBgzipFile);
        String linesOut = null;
        try {
            instr.seek(position.longValue());
            linesOut = instr.readLine();
            if (linesOut == null) {
                linesOut = "";
            }
        }
        catch (Exception e) {
            this.mLogger.error((Object)("Error seeking into bgz file, or reading the line at position " + position + ".  File: " + this.mBgzipFile));
        }
        finally {
            instr.close();
        }
        return linesOut;
    }

    public void writeLines(HashMap<String, List<String>> keyToLinesMap, File txtOutFile) throws IOException {
        FileOutputStream fout = new FileOutputStream(txtOutFile);
        TreeSet<String> sortedKeys = new TreeSet<String>(keyToLinesMap.keySet());
        for (String key : sortedKeys) {
            List<String> lines = keyToLinesMap.get(key);
            for (String line : lines) {
                fout.write((key + "\t" + line + "\n").getBytes());
            }
        }
        fout.close();
    }

    public void writeLines(List<String> lines, File txtOutFile) throws IOException {
        FileOutputStream fout = new FileOutputStream(txtOutFile);
        for (String line : lines) {
            if (line == null) continue;
            fout.write((line + "\n").getBytes());
        }
        fout.close();
    }

    public long getMemoryUseMB() {
        return this.getMemoryUse() / 0x100000L;
    }

    public long getMemoryUse() {
        long memoryUse = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return memoryUse;
    }

    public List<String> loadLines(File file) throws IOException {
        double start = System.currentTimeMillis();
        BufferedReader fin = new BufferedReader(new FileReader(file));
        String line = null;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = fin.readLine()) != null) {
            lines.add(line);
        }
        System.out.println("mem used: " + this.getMemoryUse());
        fin.close();
        double end = System.currentTimeMillis();
        System.out.println("runtime: " + (end - start) / 1000.0);
        return lines;
    }

    public HashMap<String, List<Long>> loadIndexBgzip(File bgzipIdx) throws IOException {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        BlockCompressedInputStream instream = new BlockCompressedInputStream(bgzipIdx);
        String line = null;
        while ((line = instream.readLine()) != null) {
            String[] split = line.split("\t");
            String key = split[0];
            String pos = split[1];
            ArrayList<Long> positions = (ArrayList<Long>)map.get(key);
            if (positions == null) {
                positions = new ArrayList<Long>();
            }
            positions.add(Long.valueOf(pos));
            map.put(key, positions);
        }
        System.out.println("Bgzip index load.  Mem used: " + this.getMemoryUseMB() + "MB");
        instream.close();
        return map;
    }

    public HashMap<String, List<Long>> loadIndexGzip(File gzipFile) throws IOException {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        GZIPInputStream gzip = new GZIPInputStream(new FileInputStream(gzipFile));
        BufferedReader instream = new BufferedReader(new InputStreamReader(gzip));
        String line = null;
        while ((line = instream.readLine()) != null) {
            String[] split = line.split("\t");
            String key = split[0];
            String pos = split[1];
            ArrayList<Long> positions = (ArrayList<Long>)map.get(key);
            if (positions == null) {
                positions = new ArrayList<Long>();
            }
            positions.add(Long.valueOf(pos));
            map.put(key, positions);
        }
        System.out.println("Gzip index load. Mem used: " + this.getMemoryUseMB() + "MB");
        instream.close();
        gzip.close();
        return map;
    }

    private HashMap<String, List<Long>> loadIndexTxt(File indexFile) throws IOException {
        BufferedReader fin = new BufferedReader(new FileReader(indexFile));
        String line = null;
        HashMap<String, List<Long>> indexes = new HashMap<String, List<Long>>();
        while ((line = fin.readLine()) != null) {
            String[] splits = line.split("\t");
            String key = splits[0];
            ArrayList<Long> positions = new ArrayList<Long>();
            for (int i = 1; i < splits.length; ++i) {
                positions.add(Long.valueOf(splits[i]));
            }
            indexes.put(key, positions);
        }
        System.out.println("Text index load. Mem used: " + this.getMemoryUseMB() + "MB");
        fin.close();
        return indexes;
    }

    public String getCol(String fullLine, String delimiter, int col) {
        int currCol = 1;
        int start = 0;
        int end = fullLine.indexOf(delimiter);
        if (end == -1) {
            end = fullLine.length();
        }
        while (start != -1) {
            if (col == currCol) {
                return fullLine.substring(start, end);
            }
            start = end + 1;
            if ((end = fullLine.indexOf(delimiter, start)) == -1) {
                end = fullLine.length();
            }
            ++currCol;
        }
        return null;
    }

    public String getNextLine(String str, int start) {
        int end;
        while (str.charAt(start) != '\n' && start < str.length() - 1) {
            ++start;
        }
        for (end = start + 1; str.charAt(end) != '\n' && end < str.length(); ++end) {
        }
        return str.substring(start, end).trim();
    }

    public List<String> getLines(String str) {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        int startIdx = 0;
        boolean isEnd = false;
        while (!isEnd && (line = this.getNextLine(str, startIdx)).length() != 0) {
            lines.add(line);
            startIdx += line.length();
        }
        return lines;
    }

    public void bgzip(File txtFile, File bgzipOutFile) throws IOException {
        BlockCompressedOutputStream outstream = new BlockCompressedOutputStream(bgzipOutFile, 9);
        byte[] buf = new byte[65536];
        FileInputStream fin = new FileInputStream(txtFile);
        int len = -1;
        while ((len = fin.read(buf)) != -1) {
            outstream.write(buf, 0, len);
        }
        fin.close();
        outstream.close();
    }

    private void saveIndexZip(HashMap<String, List<Long>> indexes, File indexFile) throws IOException {
        BlockCompressedOutputStream fout = new BlockCompressedOutputStream(indexFile);
        for (String key : indexes.keySet()) {
            fout.write((key + "\t" + indexes.get(key) + "\n").getBytes());
        }
        fout.close();
    }

    public static boolean isInteger(String str) {
        try {
            Integer.valueOf(str);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isKeyAnInteger(Connection dbConn) {
        Statement stmt = null;
        ResultSet rs = null;
        boolean isInt = false;
        try {
            stmt = dbConn.createStatement();
            rs = stmt.executeQuery("SELECT Key FROM Indexer LIMIT 1");
            int type = rs.getMetaData().getColumnType(1);
            isInt = type == -5;
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
        return isInt;
    }

    public static String getH2DbIndexPath(String bgzipPath, String jsonPath) throws IOException {
        return IndexUtils.getDir(bgzipPath) + "/index/" + IndexUtils.getFilePrefix(bgzipPath) + "." + jsonPath + ".idx.h2.db";
    }

    private static String getTextIndexPath(String bgzipPath, String jsonPath) throws IOException {
        return IndexUtils.getDir(bgzipPath) + "/index/" + IndexUtils.getFilePrefix(bgzipPath) + "." + jsonPath + ".idx.txt.gz";
    }

    private static String getFilePrefix(String path) {
        File file = new File(path);
        String filePrefix = file.getName();
        int idxFirstDot = filePrefix.indexOf(".");
        if (idxFirstDot != -1) {
            filePrefix = filePrefix.substring(0, idxFirstDot);
        }
        return filePrefix;
    }

    private static String getDir(String path) throws IOException {
        return new File(path).getCanonicalFile().getParentFile().getCanonicalPath();
    }

    public static void createParentDirectories(String path) {
        File indexOutFile = new File(path);
        if (!indexOutFile.getParentFile().exists()) {
            indexOutFile.getParentFile().mkdirs();
        }
    }

    public static void writeToFile(String txt, String filePath) throws IOException {
        FileOutputStream fout = new FileOutputStream(filePath);
        fout.write(txt.getBytes());
        fout.close();
    }

    public static String getDelimFromCmdLine(String cmdLineDelim) {
        String delimiter = cmdLineDelim;
        if ("TAB".equalsIgnoreCase(delimiter)) {
            delimiter = "\t";
        }
        return delimiter;
    }

    public List<String> getSampleGeneIds() {
        return Arrays.asList("uc003bmz.4", "uc003bng.3", "uc010gsn.3", "uc010gvh.1", "uc010gyg.3", "uc010hat.1", "uc010hau.1", "uc011ahw.2", "uc011akb.1", "uc011amk.2", "uc011aou.2", "uc011aqb.1", "uc011arw.2", "uc021wku.1", "uc021wlx.1", "uc021wmk.1", "uc021wod.1", "uc021wox.1", "uc021wpn.1", "uc021wqd.1", "uc021wqx.1", "uc021wqy.1", "uc021wsf.1");
    }

    public List<String> getSampleVariantIds() {
        return Arrays.asList("rsX", "rs149201999", "rs62224621", "rs12162831", "rs143158770", "rs146675715", "rs187630378", "rs149862772", "rs187249052", "rs190654308", "rs117120972", "rs186426805");
    }

    public static enum IndexBuilderPropKeys {
        MaxKeyLen,
        IsKeyColAnInt,
        NumLines;

    }
}

