/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.inject;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import edu.mayo.pipes.JSON.inject.Injector;
import edu.mayo.pipes.JSON.inject.JsonType;

public abstract class BaseInjector
implements Injector {
    protected void injectAsPrimitive(JsonObject object, String key, String value, JsonType type) {
        switch (type) {
            case BOOLEAN: {
                object.addProperty(key, new Boolean(value));
                return;
            }
            case NUMBER: {
                object.addProperty(key, this.getAsNumber(value));
                break;
            }
            case STRING: {
                object.addProperty(key, value);
                return;
            }
        }
    }

    protected void injectAsArray(JsonObject object, String key, String[] values, JsonType type) {
        JsonArray array = new JsonArray();
        block5: for (String value : values) {
            switch (type) {
                case BOOLEAN: {
                    array.add((JsonElement)new JsonPrimitive(new Boolean(value)));
                    continue block5;
                }
                case NUMBER: {
                    array.add((JsonElement)new JsonPrimitive(this.getAsNumber(value)));
                    continue block5;
                }
                case STRING: {
                    array.add((JsonElement)new JsonPrimitive(value));
                }
            }
        }
        object.add(key, (JsonElement)array);
    }

    private Number getAsNumber(String s) {
        try {
            return new Integer(s);
        }
        catch (NumberFormatException numberFormatException) {
            return new Double(s);
        }
    }

    protected boolean isNull(String value) {
        if (value == null) {
            return true;
        }
        return (value = value.trim()).length() == 0 || value.equals(".") || value.equalsIgnoreCase("null") || value.equalsIgnoreCase("\\N");
    }
}

