/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics;

import com.tinkerpop.pipes.AbstractPipe;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.NoSuchElementException;
import org.biojava.bio.BioException;
import org.biojavax.Namespace;
import org.biojavax.SimpleNamespace;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.RichSequenceIterator;

public class GenbankPipe
extends AbstractPipe<String, RichSequence> {
    private BufferedReader br = null;
    private SimpleNamespace ns = null;
    private RichSequenceIterator rsi = null;

    private BufferedReader openFile(String filename) throws Exception {
        this.br = this.br = new BufferedReader(new FileReader(filename));
        this.ns = new SimpleNamespace("biojava");
        this.rsi = RichSequence.IOTools.readGenbankDNA((BufferedReader)this.br, (Namespace)this.ns);
        return this.br;
    }

    protected RichSequence processNextStart() throws NoSuchElementException {
        if (this.rsi == null) {
            try {
                this.openFile((String)this.starts.next());
            }
            catch (Exception e) {
                throw new NoSuchElementException(e.getMessage());
            }
        }
        if (this.rsi.hasNext()) {
            try {
                return this.rsi.nextRichSequence();
            }
            catch (BioException ex) {
                throw new NoSuchElementException(ex.getMessage());
            }
        }
        try {
            this.openFile((String)this.starts.next());
            if (this.rsi.hasNext()) {
                return this.rsi.nextRichSequence();
            }
        }
        catch (Exception e) {
            throw new NoSuchElementException(e.getMessage());
        }
        throw new NoSuchElementException();
    }
}

