/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleSequenceFactory;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AbstractReversibleTranslationTable;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ManyToOneTranslationTable;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleGeneticCodeTable;
import org.biojava.bio.symbol.SimpleReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.utils.ClassTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class RNATools {
    private static final ReversibleTranslationTable complementTable;
    private static final SimpleReversibleTranslationTable transcriptionTable;
    private static final FiniteAlphabet rna;
    private static final Map geneticCodes;
    private static final AtomicSymbol a;
    private static final AtomicSymbol g;
    private static final AtomicSymbol c;
    private static final AtomicSymbol u;
    private static final Symbol n;
    private static Map symbolToComplement;

    public static AtomicSymbol a() {
        return a;
    }

    public static AtomicSymbol g() {
        return g;
    }

    public static AtomicSymbol c() {
        return c;
    }

    public static AtomicSymbol u() {
        return u;
    }

    public static Symbol n() {
        return n;
    }

    private RNATools() {
    }

    public static FiniteAlphabet getRNA() {
        return rna;
    }

    public static FiniteAlphabet getCodonAlphabet() {
        return (FiniteAlphabet)AlphabetManager.generateCrossProductAlphaFromName("(RNA x RNA x RNA)");
    }

    public static SymbolList createRNA(String rna) throws IllegalSymbolException {
        SymbolTokenization p = null;
        try {
            p = RNATools.getRNA().getTokenization("token");
        }
        catch (BioException e) {
            throw new BioError("Something has gone badly wrong with RNA", e);
        }
        return new SimpleSymbolList(p, rna);
    }

    public static Sequence createRNASequence(String rna, String name) throws IllegalSymbolException {
        try {
            return new SimpleSequenceFactory().createSequence(RNATools.createRNA(rna), "", name, new SimpleAnnotation());
        }
        catch (BioException se) {
            throw new BioError("Something has gone badly wrong with RNA", se);
        }
    }

    public static int index(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return 0;
        }
        if (sym == g) {
            return 1;
        }
        if (sym == c) {
            return 2;
        }
        if (sym == u) {
            return 3;
        }
        RNATools.getRNA().validate(sym);
        throw new IllegalSymbolException("Really confused. Can't find index for " + sym.getName());
    }

    public static Symbol forIndex(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return a;
        }
        if (index == 1) {
            return g;
        }
        if (index == 2) {
            return c;
        }
        if (index == 3) {
            return u;
        }
        throw new IndexOutOfBoundsException("No symbol for index " + index);
    }

    public static Symbol complement(Symbol sym) throws IllegalSymbolException {
        if (sym == a) {
            return u;
        }
        if (sym == g) {
            return c;
        }
        if (sym == c) {
            return g;
        }
        if (sym == u) {
            return a;
        }
        Symbol s = (Symbol)symbolToComplement.get(sym);
        if (s != null) {
            return s;
        }
        RNATools.getRNA().validate(sym);
        throw new BioError("Really confused. Can't find symbol " + sym.getName());
    }

    public static Symbol forSymbol(char token) throws IllegalSymbolException {
        SymbolTokenization toke;
        String t = String.valueOf(token);
        try {
            toke = RNATools.getRNA().getTokenization("token");
        }
        catch (BioException e) {
            throw new BioError("Cannot find the 'token' Tokenization for RNA!?", e);
        }
        return toke.parseToken(t);
    }

    public static SymbolList complement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(list, RNATools.complementTable());
    }

    public static SymbolList reverseComplement(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(SymbolListViews.reverse(list), RNATools.complementTable());
    }

    public static SymbolList transcribe(SymbolList list) throws IllegalAlphabetException {
        return SymbolListViews.translate(list, RNATools.transcriptionTable());
    }

    public static ReversibleTranslationTable complementTable() {
        return complementTable;
    }

    public static ReversibleTranslationTable transcriptionTable() {
        return transcriptionTable;
    }

    public static ManyToOneTranslationTable getGeneticCode(String name) {
        return (ManyToOneTranslationTable)geneticCodes.get(name);
    }

    public static ManyToOneTranslationTable getGeneticCode(int table_num) {
        Set tables = RNATools.getGeneticCodeNames();
        for (String tableName : tables) {
            SimpleGeneticCodeTable table = (SimpleGeneticCodeTable)geneticCodes.get(tableName);
            if (table.getTableNumber() != table_num) continue;
            return table;
        }
        throw new IllegalArgumentException("There is no genetic code table at that number");
    }

    public static Set getGeneticCodeNames() {
        return geneticCodes.keySet();
    }

    public static SymbolList translate(SymbolList syms) throws IllegalAlphabetException {
        if (syms.getAlphabet() == RNATools.getRNA()) {
            syms = SymbolListViews.windowedSymbolList(syms, 3);
        }
        return SymbolListViews.translate(syms, RNATools.getGeneticCode("UNIVERSAL"));
    }

    private static void loadGeneticCodes() {
        try {
            InputStream tablesStream = ClassTools.getClassLoader(RNATools.class).getResourceAsStream("org/biojava/bio/seq/TranslationTables.xml");
            if (tablesStream == null) {
                throw new BioError("Couldn't locate TranslationTables.xml.");
            }
            InputSource is = new InputSource(tablesStream);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = parser.parse(is);
            NodeList children = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element child;
                String name;
                Node cnode = children.item(i);
                if (!(cnode instanceof Element) || !(name = (child = (Element)cnode).getNodeName()).equals("table")) continue;
                String tableName = child.getAttribute("name");
                String source = child.getAttribute("source");
                String target = child.getAttribute("target");
                FiniteAlphabet sourceA = (FiniteAlphabet)AlphabetManager.alphabetForName(source);
                FiniteAlphabet targetA = (FiniteAlphabet)AlphabetManager.alphabetForName(target);
                SymbolTokenization targetP = targetA.getTokenization("name");
                SimpleGeneticCodeTable table = new SimpleGeneticCodeTable(sourceA, targetA);
                NodeList translates = child.getChildNodes();
                for (int j = 0; j < translates.getLength(); ++j) {
                    Node tn = translates.item(j);
                    if (!(tn instanceof Element)) continue;
                    Element te = (Element)tn;
                    if (te.getTagName().equals("transl_table")) {
                        int num = Integer.valueOf(te.getAttribute("value"));
                        String description = te.getAttribute("description");
                        table.setTableNumber(num);
                        table.setDescription(description);
                        continue;
                    }
                    String from = te.getAttribute("from");
                    String to = te.getAttribute("to");
                    SymbolList fromSymbols = RNATools.createRNA(from);
                    if (fromSymbols.length() != 3) {
                        throw new BioError("`" + from + "' is not a valid codon");
                    }
                    AtomicSymbol fromS = (AtomicSymbol)sourceA.getSymbol(fromSymbols.toList());
                    AtomicSymbol toS = (AtomicSymbol)targetP.parseToken(to);
                    table.setTranslation(fromS, toS);
                }
                geneticCodes.put(tableName, table);
            }
        }
        catch (Exception e) {
            throw new BioError("Couldn't parse TranslationTables.xml", e);
        }
    }

    static {
        try {
            rna = (FiniteAlphabet)AlphabetManager.alphabetForName("RNA");
            SimpleSymbolList syms = new SimpleSymbolList(rna.getTokenization("token"), "agcun");
            a = (AtomicSymbol)syms.symbolAt(1);
            g = (AtomicSymbol)syms.symbolAt(2);
            c = (AtomicSymbol)syms.symbolAt(3);
            u = (AtomicSymbol)syms.symbolAt(4);
            n = syms.symbolAt(5);
            symbolToComplement = new HashMap();
            Symbol gap = rna.getGapSymbol();
            symbolToComplement.put(gap, gap);
            for (Symbol as : AlphabetManager.getAllSymbols(rna)) {
                FiniteAlphabet matches = (FiniteAlphabet)as.getMatches();
                if (matches.size() <= 1) continue;
                HashSet<Symbol> l = new HashSet<Symbol>();
                Iterator<Symbol> j = matches.iterator();
                while (j.hasNext()) {
                    l.add(RNATools.complement(j.next()));
                }
                symbolToComplement.put(as, rna.getAmbiguity(l));
            }
            complementTable = new RNAComplementTranslationTable();
            transcriptionTable = new SimpleReversibleTranslationTable(DNATools.getDNA(), rna);
            transcriptionTable.setTranslation(DNATools.a(), a);
            transcriptionTable.setTranslation(DNATools.c(), c);
            transcriptionTable.setTranslation(DNATools.g(), g);
            transcriptionTable.setTranslation(DNATools.t(), u);
            geneticCodes = new HashMap();
            RNATools.loadGeneticCodes();
        }
        catch (Throwable t) {
            throw new BioError("Unable to initialize RNATools", t);
        }
    }

    private static class RNAComplementTranslationTable
    extends AbstractReversibleTranslationTable {
        private RNAComplementTranslationTable() {
        }

        public Symbol doTranslate(Symbol s) throws IllegalSymbolException {
            return RNATools.complement(s);
        }

        public Symbol doUntranslate(Symbol s) throws IllegalSymbolException {
            return RNATools.complement(s);
        }

        public Alphabet getSourceAlphabet() {
            return RNATools.getRNA();
        }

        public Alphabet getTargetAlphabet() {
            return RNATools.getRNA();
        }
    }
}

