/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.io.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.shared.io.logging.MessageHolder;
import org.apache.maven.shared.io.logging.MessageLevels;
import org.apache.maven.shared.io.logging.MessageSink;

public class DefaultMessageHolder
implements MessageHolder {
    private List messages = new ArrayList();
    private Message currentMessage;
    private int defaultMessageLevel = 1;
    private boolean[] messageLevelStates;
    private MessageSink onDemandSink;

    public DefaultMessageHolder() {
        this.messageLevelStates = MessageLevels.getLevelStates(1);
    }

    public DefaultMessageHolder(int maxMessageLevel, int defaultMessageLevel) {
        this.defaultMessageLevel = defaultMessageLevel;
        this.messageLevelStates = MessageLevels.getLevelStates(maxMessageLevel);
    }

    public DefaultMessageHolder(int maxMessageLevel, int defaultMessageLevel, MessageSink onDemandSink) {
        this.defaultMessageLevel = defaultMessageLevel;
        this.onDemandSink = onDemandSink;
        this.messageLevelStates = MessageLevels.getLevelStates(maxMessageLevel);
    }

    public MessageHolder addMessage(CharSequence messagePart, Throwable error) {
        return this.addMessage(this.defaultMessageLevel, messagePart, error);
    }

    protected MessageHolder addMessage(int level, CharSequence messagePart, Throwable error) {
        this.newMessage(level);
        this.append(((Object)messagePart).toString());
        this.append(error);
        return this;
    }

    public MessageHolder addMessage(CharSequence messagePart) {
        return this.addMessage(this.defaultMessageLevel, messagePart);
    }

    protected MessageHolder addMessage(int level, CharSequence messagePart) {
        this.newMessage(level);
        this.append(((Object)messagePart).toString());
        return this;
    }

    public MessageHolder addMessage(Throwable error) {
        return this.addMessage(this.defaultMessageLevel, error);
    }

    protected MessageHolder addMessage(int level, Throwable error) {
        this.newMessage(level);
        this.append(error);
        return this;
    }

    public MessageHolder append(CharSequence messagePart) {
        if (this.currentMessage == null) {
            this.newMessage();
        }
        this.currentMessage.append(((Object)messagePart).toString());
        return this;
    }

    public MessageHolder append(Throwable error) {
        if (this.currentMessage == null) {
            this.newMessage();
        }
        this.currentMessage.setError(error);
        return this;
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public MessageHolder newMessage() {
        this.newMessage(this.defaultMessageLevel);
        return this;
    }

    protected void newMessage(int messageLevel) {
        if (this.onDemandSink != null && this.currentMessage != null) {
            this.renderTo(this.currentMessage, this.onDemandSink);
        }
        this.currentMessage = new Message(messageLevel, this.onDemandSink);
        this.messages.add(this.currentMessage);
    }

    public String render() {
        StringBuffer buffer = new StringBuffer();
        int counter = 1;
        Iterator it = this.messages.iterator();
        while (it.hasNext()) {
            Message message = (Message)it.next();
            int ml = message.getMessageLevel();
            if (ml >= this.messageLevelStates.length || ml < 0) {
                ml = 0;
            }
            if (!this.messageLevelStates[ml]) continue;
            CharSequence content = message.render();
            String label = MessageLevels.getLevelLabel(message.getMessageLevel());
            if (content.length() <= label.length() + 3) continue;
            buffer.append('[').append(counter++).append("] ");
            buffer.append(((Object)content).toString());
            if (!it.hasNext()) continue;
            buffer.append("\n\n");
        }
        return buffer.toString();
    }

    public int size() {
        return this.messages.size();
    }

    public MessageHolder addDebugMessage(CharSequence messagePart, Throwable error) {
        return this.addMessage(0, messagePart, error);
    }

    public MessageHolder addDebugMessage(CharSequence messagePart) {
        return this.addMessage(0, messagePart);
    }

    public MessageHolder addDebugMessage(Throwable error) {
        return this.addMessage(0, error);
    }

    public MessageHolder addErrorMessage(CharSequence messagePart, Throwable error) {
        return this.addMessage(3, messagePart, error);
    }

    public MessageHolder addErrorMessage(CharSequence messagePart) {
        return this.addMessage(3, messagePart);
    }

    public MessageHolder addErrorMessage(Throwable error) {
        return this.addMessage(3, error);
    }

    public MessageHolder addInfoMessage(CharSequence messagePart, Throwable error) {
        return this.addMessage(1, messagePart, error);
    }

    public MessageHolder addInfoMessage(CharSequence messagePart) {
        return this.addMessage(1, messagePart);
    }

    public MessageHolder addInfoMessage(Throwable error) {
        return this.addMessage(1, error);
    }

    public MessageHolder addSevereMessage(CharSequence messagePart, Throwable error) {
        return this.addMessage(4, messagePart, error);
    }

    public MessageHolder addSevereMessage(CharSequence messagePart) {
        return this.addMessage(4, messagePart);
    }

    public MessageHolder addSevereMessage(Throwable error) {
        return this.addMessage(4, error);
    }

    public MessageHolder addWarningMessage(CharSequence messagePart, Throwable error) {
        return this.addMessage(2, messagePart, error);
    }

    public MessageHolder addWarningMessage(CharSequence messagePart) {
        return this.addMessage(2, messagePart);
    }

    public MessageHolder addWarningMessage(Throwable error) {
        return this.addMessage(2, error);
    }

    public int countDebugMessages() {
        return this.countMessagesOfType(0);
    }

    public int countErrorMessages() {
        return this.countMessagesOfType(3);
    }

    public int countInfoMessages() {
        return this.countMessagesOfType(1);
    }

    public int countMessages() {
        return this.size();
    }

    public int countSevereMessages() {
        return this.countMessagesOfType(4);
    }

    public int countWarningMessages() {
        return this.countMessagesOfType(2);
    }

    private int countMessagesOfType(int messageLevel) {
        int count = 0;
        Iterator it = this.messages.iterator();
        while (it.hasNext()) {
            Message message = (Message)it.next();
            if (messageLevel != message.getMessageLevel()) continue;
            ++count;
        }
        return count;
    }

    public boolean isDebugEnabled() {
        return this.messageLevelStates[0];
    }

    public boolean isErrorEnabled() {
        return this.messageLevelStates[3];
    }

    public boolean isInfoEnabled() {
        return this.messageLevelStates[1];
    }

    public boolean isSevereEnabled() {
        return this.messageLevelStates[4];
    }

    public boolean isWarningEnabled() {
        return this.messageLevelStates[2];
    }

    public MessageHolder newDebugMessage() {
        if (this.isDebugEnabled()) {
            this.newMessage(0);
        }
        return this;
    }

    public MessageHolder newErrorMessage() {
        if (this.isErrorEnabled()) {
            this.newMessage(3);
        }
        return this;
    }

    public MessageHolder newInfoMessage() {
        if (this.isInfoEnabled()) {
            this.newMessage(1);
        }
        return this;
    }

    public MessageHolder newSevereMessage() {
        if (this.isSevereEnabled()) {
            this.newMessage(4);
        }
        return this;
    }

    public MessageHolder newWarningMessage() {
        if (this.isWarningEnabled()) {
            this.newMessage(2);
        }
        return this;
    }

    public void setDebugEnabled(boolean enabled) {
        this.messageLevelStates[0] = enabled;
    }

    public void setErrorEnabled(boolean enabled) {
        this.messageLevelStates[3] = enabled;
    }

    public void setInfoEnabled(boolean enabled) {
        this.messageLevelStates[1] = enabled;
    }

    public void setSevereEnabled(boolean enabled) {
        this.messageLevelStates[4] = enabled;
    }

    public void setWarningEnabled(boolean enabled) {
        this.messageLevelStates[2] = enabled;
    }

    public void flush() {
        if (this.onDemandSink != null && this.currentMessage != null) {
            this.renderTo(this.currentMessage, this.onDemandSink);
            this.currentMessage = null;
        }
    }

    public void render(MessageSink sink) {
        Iterator it = this.messages.iterator();
        while (it.hasNext()) {
            Message message = (Message)it.next();
            this.renderTo(message, sink);
        }
    }

    protected void renderTo(Message message, MessageSink sink) {
        switch (message.getMessageLevel()) {
            case 4: {
                sink.severe(((Object)message.render()).toString());
                break;
            }
            case 3: {
                sink.error(((Object)message.render()).toString());
                break;
            }
            case 2: {
                sink.warning(((Object)message.render()).toString());
                break;
            }
            case 1: {
                sink.info(((Object)message.render()).toString());
                break;
            }
            default: {
                sink.debug(((Object)message.render()).toString());
            }
        }
    }

    private static final class Message {
        private StringBuffer message = new StringBuffer();
        private Throwable error;
        private final int messageLevel;
        private final MessageSink onDemandSink;

        public Message(int messageLevel, MessageSink onDemandSink) {
            this.messageLevel = messageLevel;
            this.onDemandSink = onDemandSink;
        }

        public Message setError(Throwable error) {
            this.error = error;
            return this;
        }

        public Message append(CharSequence message) {
            this.message.append(((Object)message).toString());
            return this;
        }

        public int getMessageLevel() {
            return this.messageLevel;
        }

        public CharSequence render() {
            StringBuffer buffer = new StringBuffer();
            if (this.onDemandSink == null) {
                buffer.append('[').append(MessageLevels.getLevelLabel(this.messageLevel)).append("] ");
            }
            if (this.message != null && this.message.length() > 0) {
                buffer.append(this.message);
                if (this.error != null) {
                    buffer.append('\n');
                }
            }
            if (this.error != null) {
                buffer.append("Error:\n");
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                this.error.printStackTrace(pw);
                buffer.append(sw.toString());
            }
            return buffer;
        }
    }
}

