/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics.sequence;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.pipes.HeaderPipe;
import edu.mayo.pipes.UNIX.CatGZPipe;
import edu.mayo.pipes.WritePipe;
import java.util.Arrays;

public class Fasta2Tabix {
    public static void main(String[] args) {
        String landmark = "Y";
        String fasta = "/data/NCBIgene/genomes/H_sapiens/Assembled_chromosomes/seq/hs_ref_GRCh37.p10_chr" + landmark + ".fa.gz";
        String out = "/tmp/hs_ref_GRCh37.p10.fa.tsv";
        System.out.println("Opening File: " + fasta);
        System.out.println("Using Landmark: " + landmark);
        System.out.println("Writing File: " + out);
        TransformFunctionPipe t = new TransformFunctionPipe((PipeFunction)new Fasta2SequenceTabix(landmark));
        Pipeline p = new Pipeline(new Pipe[]{new CatGZPipe("gzip"), new HeaderPipe(1), t, new WritePipe(out, true)});
        p.setStarts(Arrays.asList(fasta));
        int i = 0;
        while (p.hasNext()) {
            p.next();
            ++i;
        }
    }

    public static class Fasta2SequenceTabix
    implements PipeFunction<String, String> {
        private String landmark = "";
        private int count = 1;

        public Fasta2SequenceTabix(String landmark) {
            this.landmark = landmark;
        }

        public String compute(String s) {
            StringBuilder sb = new StringBuilder();
            if (this.count > 10) {
                ++this.count;
            }
            sb.append(this.landmark);
            sb.append("\t");
            sb.append(this.count);
            sb.append("\t");
            this.count += s.length() - 1;
            sb.append(this.count);
            sb.append("\t");
            sb.append(s);
            sb.append("\n");
            return sb.toString();
        }
    }
}

