/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;

public class BuildScriptsApp {
    private static final String PRP_CLASSES_DIR = "classes.dir";
    private static final String PRP_SCRIPT_TEMPLATE_CP = "script.template.classpath";
    private static final String PRP_SCRIPT_OUTPUT_DIR = "script.output.dir";
    private static final String PRP_ENV_HOME_VAR = "env.home.variable";
    private static final String PRP_JAVA_MINOR_VER = "minor.java.version";
    private static final String PRP_JVM_OPTS = "jvm.opts";
    private File mClassesDir;
    private String mTemplateStr;
    private File mOutputDir;
    private String mEnvHomeVar;
    private String mMinorJavaVersion;
    private String mJvmOpts;

    public BuildScriptsApp(Properties props) throws Exception {
        String templateClasspathLoc = this.getProperty(props, PRP_SCRIPT_TEMPLATE_CP);
        this.mTemplateStr = this.loadFileFromClasspath(templateClasspathLoc);
        this.mClassesDir = new File(this.getProperty(props, PRP_CLASSES_DIR));
        this.mOutputDir = new File(this.getProperty(props, PRP_SCRIPT_OUTPUT_DIR));
        if (!this.mOutputDir.exists()) {
            this.mOutputDir.mkdirs();
        }
        this.mEnvHomeVar = this.getProperty(props, PRP_ENV_HOME_VAR);
        this.mMinorJavaVersion = this.getProperty(props, PRP_JAVA_MINOR_VER);
        if (props.containsKey(PRP_JVM_OPTS)) {
            this.mJvmOpts = this.getProperty(props, PRP_JVM_OPTS);
        }
    }

    private String getProperty(Properties props, String key) throws Exception {
        if (props.containsKey(key)) {
            return props.getProperty(key);
        }
        throw new Exception(String.format("Missing property %s", key));
    }

    public void buildScripts() throws FileNotFoundException, IOException {
        File[] propFiles;
        for (File propFile : propFiles = this.getCommandPropertyFiles()) {
            this.buildScript(propFile);
        }
    }

    private String loadFileFromClasspath(String classpath) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        InputStream inStream = BuildScriptsApp.class.getResourceAsStream(classpath);
        BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
        String line = br.readLine();
        while (line != null) {
            pw.println(line);
            line = br.readLine();
        }
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    private String readFile(File f) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        BufferedReader br = new BufferedReader(new FileReader(f));
        String line = br.readLine();
        while (line != null) {
            pw.println(line);
            line = br.readLine();
        }
        pw.flush();
        sw.flush();
        pw.close();
        sw.close();
        return sw.toString();
    }

    private void writeFile(File f, String s) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(f));
        pw.print(s);
        pw.flush();
        pw.close();
    }

    private void buildScript(File propFile) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        props.load(new FileReader(propFile));
        String commandClass = props.getProperty("command.class");
        String commandName = props.getProperty("command.name");
        String jvmOpts = "";
        if (props.containsKey(PRP_JVM_OPTS)) {
            jvmOpts = props.getProperty(PRP_JVM_OPTS);
        } else if (this.mJvmOpts != null) {
            jvmOpts = this.mJvmOpts;
        }
        jvmOpts = jvmOpts.trim();
        String scriptContent = new String(this.mTemplateStr);
        scriptContent = scriptContent.replace("${command.class}", commandClass);
        scriptContent = scriptContent.replace("${home.env.var}", this.mEnvHomeVar);
        scriptContent = scriptContent.replace("${java.minor.version}", this.mMinorJavaVersion);
        scriptContent = scriptContent.replace("${jvm.opts}", jvmOpts);
        File script = new File(this.mOutputDir, commandName);
        this.writeFile(script, scriptContent);
        System.out.println(String.format("Built script %s", script.getAbsolutePath()));
    }

    private File[] getCommandPropertyFiles() {
        ArrayList<File> list = new ArrayList<File>();
        File propsDir = new File(this.mClassesDir, "cli");
        if (propsDir.exists()) {
            for (File f : propsDir.listFiles()) {
                if (!f.isFile() || !f.getName().endsWith(".properties") || f.getName().equals("Global.properties")) continue;
                list.add(f);
            }
        } else {
            String mesg = String.format("WARNING: Could not locate command properties directory: %s", propsDir.getAbsolutePath());
            System.err.println(mesg);
        }
        return list.toArray(new File[0]);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            String mesg = String.format("USAGE: java %s <BuildScriptsApp.properties file location>", BuildScriptsApp.class.getName());
            System.err.println();
        }
        File propsFile = new File(args[0]);
        try {
            Properties props = new Properties();
            props.load(new FileReader(propsFile));
            BuildScriptsApp app = new BuildScriptsApp(props);
            app.buildScripts();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

