/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTools {
    private XMLTools() {
    }

    public static boolean readXMLChunk(BufferedReader reader, DefaultHandler m_handler, String chunkToken) throws ParserConfigurationException, SAXException, IOException {
        StringBuffer buffer = new StringBuffer();
        Pattern start = Pattern.compile(".*<" + chunkToken + ".*");
        Pattern end = Pattern.compile(".*</" + chunkToken + ">.*");
        boolean begunChunk = false;
        boolean filledBuffer = false;
        String line = null;
        while (!filledBuffer && (line = reader.readLine()) != null) {
            line = line.trim();
            if (!begunChunk && !start.matcher(line).matches()) continue;
            begunChunk = true;
            buffer.append(line + "\n");
            if (!end.matcher(line).matches()) continue;
            filledBuffer = true;
        }
        if (!filledBuffer) {
            throw new SAXException("Unexpectedly reached end of file");
        }
        reader.mark(10000);
        boolean hasAnotherChunk = false;
        while (!hasAnotherChunk && (line = reader.readLine()) != null) {
            if (!start.matcher(line = line.trim()).matches()) continue;
            hasAnotherChunk = true;
        }
        reader.reset();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        SAXParser m_xmlParser = factory.newSAXParser();
        InputSource source = new InputSource(new StringReader(buffer.toString()));
        m_xmlParser.parse(source, m_handler);
        return hasAnotherChunk;
    }
}

