/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.process;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamPipe
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(StreamPipe.class.getName());
    private InputStream input = null;
    private OutputStream output = null;
    private String tag = null;

    public StreamPipe(InputStream input, OutputStream output, String tag) {
        this.setInput(input);
        this.setOutput(output);
        this.tag = tag;
    }

    public InputStream getInput() {
        return this.input;
    }

    public void setInput(InputStream input) {
        this.input = input;
    }

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    public OutputStream getOutput() {
        return this.output;
    }

    public void run() {
        LOGGER.entering(this.getClass().getName(), "run");
        if (this.input != null) {
            try {
                int len;
                BufferedOutputStream bout = null;
                if (this.output != null) {
                    bout = new BufferedOutputStream(this.output);
                }
                BufferedInputStream bin = new BufferedInputStream(this.input);
                boolean log = LOGGER.isLoggable(Level.FINEST);
                byte[] buffer = new byte[1024];
                while ((len = bin.read(buffer)) != -1) {
                    if (log) {
                        String data = new String(buffer, 0, len);
                        if (this.tag == null) {
                            LOGGER.finest(data);
                        } else {
                            LOGGER.finest("<" + this.tag + "> " + data);
                        }
                    }
                    if (bout == null) continue;
                    bout.write(buffer, 0, len);
                    bout.flush();
                }
            }
            catch (Exception e) {
                LOGGER.severe(e.toString());
            }
        }
        LOGGER.exiting(this.getClass().getName(), "run");
    }
}

