/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.biojava.utils.io.SoftHashMap;

public class FlatFileCache {
    private static FlatFileCache me;
    private static SoftHashMap cache;

    public static FlatFileCache getInstance() {
        if (me == null) {
            me = new FlatFileCache();
        }
        return me;
    }

    private FlatFileCache() {
        cache = new SoftHashMap(0);
    }

    public static void addToCache(String key, File fileToCache) {
        try {
            int offset;
            FileInputStream is = new FileInputStream(fileToCache);
            long length = fileToCache.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + fileToCache.getName());
            }
            ((InputStream)is).close();
            cache.put(key, bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static InputStream getInputStream(String key) {
        byte[] bytes = (byte[])cache.get(key);
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public int size() {
        if (cache != null) {
            return cache.size();
        }
        return -1;
    }

    public void clear() {
        cache.clear();
    }

    public static void destroy() {
        me.clear();
        me = null;
    }
}

