/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.utils.AssertionFailure;

public class BeanAsMap
extends AbstractMap {
    private static Map beanInfoCache = new HashMap();
    private static Object[] NO_PARAMS = new Object[0];
    private final BeanInfo beanInfo;
    private final Object bean;
    private final PropertyDescriptor[] descriptors;
    private final Set entrySet;

    private static BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        BeanInfo bi = (BeanInfo)beanInfoCache.get(clazz);
        if (bi == null) {
            bi = Introspector.getBeanInfo(clazz);
            beanInfoCache.put(clazz, bi);
        }
        return bi;
    }

    public BeanAsMap(Object bean) throws IntrospectionException {
        this.beanInfo = BeanAsMap.getBeanInfo(bean.getClass());
        this.bean = bean;
        this.descriptors = this.beanInfo.getPropertyDescriptors();
        this.entrySet = new PropertySet();
    }

    public int size() {
        return this.entrySet.size();
    }

    public Set entrySet() {
        return this.entrySet;
    }

    public Object put(Object key, Object value) {
        for (PropertyEntry pe : this.entrySet) {
            if (!pe.getKey().equals(key)) continue;
            return pe.setValue(value);
        }
        throw new IllegalArgumentException("BeanAsMap does not support key: " + key);
    }

    private class PropertyEntry
    implements Map.Entry {
        private final PropertyDescriptor pd;

        public PropertyEntry(PropertyDescriptor pd) {
            this.pd = pd;
        }

        public Object getKey() {
            return this.pd.getName();
        }

        public Object getValue() {
            try {
                return this.pd.getReadMethod().invoke(BeanAsMap.this.bean, NO_PARAMS);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionFailure("Could not set property", iae);
            }
            catch (InvocationTargetException ite) {
                throw new AssertionFailure("Could not invoke property", ite);
            }
        }

        public Object setValue(Object value) {
            try {
                Object old = this.getValue();
                this.pd.getWriteMethod().invoke(BeanAsMap.this.bean, value);
                return old;
            }
            catch (IllegalAccessException iae) {
                throw new AssertionFailure("Could not access property", iae);
            }
            catch (InvocationTargetException ite) {
                throw new AssertionFailure("Could not invoke property", ite);
            }
        }
    }

    private class PropertySet
    extends AbstractSet {
        private PropertyEntry[] entries;

        public PropertySet() {
            this.entries = new PropertyEntry[BeanAsMap.this.descriptors.length];
            for (int i = 0; i < this.entries.length; ++i) {
                this.entries[i] = new PropertyEntry(BeanAsMap.this.descriptors[i]);
            }
        }

        public int size() {
            return this.entries.length;
        }

        public Iterator iterator() {
            return new Iterator(){
                int i = 0;

                public boolean hasNext() {
                    return this.i < PropertySet.this.entries.length;
                }

                public Object next() {
                    return PropertySet.this.entries[this.i++];
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

