/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics.aaindex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.NoSuchElementException;
import org.biojava.bio.BioException;
import org.biojava.bio.proteomics.aaindex.AAindex;
import org.biojava.bio.proteomics.aaindex.SymbolPropertyTableIterator;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolPropertyTable;

public class AAindexStreamReader
implements SymbolPropertyTableIterator {
    private static final String TOKENIZER = "token";
    private static Symbol[] aa = null;
    private BufferedReader reader = null;
    private String line = null;
    private char keyChar;
    private String stringValue;

    public AAindexStreamReader(Reader reader) throws IOException, NullPointerException {
        this(new BufferedReader(reader));
    }

    public AAindexStreamReader(BufferedReader reader) throws IOException, NullPointerException {
        if (reader == null) {
            throw new NullPointerException("reader is null.");
        }
        this.reader = reader;
        this.line = reader.readLine();
    }

    public boolean eof() {
        if (this.line == null) {
            return true;
        }
        while (this.line != null && this.line.length() == 0) {
            try {
                this.line = this.reader.readLine();
            }
            catch (IOException e) {
                return true;
            }
        }
        return this.line == null;
    }

    private void readSection() throws BioException {
        this.keyChar = this.line.charAt(0);
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if (this.line.length() > 2) {
                stringBuffer.append(this.line.substring(2));
                if (!this.line.endsWith(" ")) {
                    stringBuffer.append(" ");
                }
            }
            try {
                this.line = this.reader.readLine();
            }
            catch (IOException e) {
                throw new BioException(e);
            }
        } while (!this.eof() && this.line.charAt(0) == ' ');
        this.stringValue = stringBuffer.toString();
    }

    public boolean hasNext() {
        return !this.eof();
    }

    public SymbolPropertyTable nextTable() throws BioException {
        if (this.eof()) {
            throw new NoSuchElementException();
        }
        this.readSection();
        if (this.keyChar != 'H') {
            throw new BioException("Expected 'H' but found: '" + this.keyChar + "'.");
        }
        AAindex aaIndex = new AAindex(this.stringValue.trim());
        block13: while (!this.eof()) {
            this.readSection();
            switch (this.keyChar) {
                case 'D': {
                    aaIndex.setDescription(this.stringValue);
                    break;
                }
                case 'R': {
                    aaIndex.setLITDBEntryNumbers(this.stringValue.split("\\s+"));
                    break;
                }
                case 'A': {
                    aaIndex.setArticleAuthors(this.stringValue);
                    break;
                }
                case 'T': {
                    aaIndex.setArticleTitle(this.stringValue);
                    break;
                }
                case 'J': {
                    aaIndex.setJournalReference(this.stringValue);
                    break;
                }
                case 'C': {
                    String[] keyValuePairs = this.stringValue.split("\\s+");
                    Map similarEntries = aaIndex.similarEntries();
                    for (int i = 0; i < keyValuePairs.length - 1; i += 2) {
                        similarEntries.put(keyValuePairs[i], Double.valueOf(keyValuePairs[i + 1]));
                    }
                    continue block13;
                }
                case 'I': {
                    String[] headersAndIndices = this.stringValue.split("\\s+");
                    for (int i = 0; i < 20; ++i) {
                        try {
                            aaIndex.setDoubleProperty(aa[i], headersAndIndices[11 + i]);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            aaIndex.setDoubleProperty(aa[i], "NaN");
                        }
                    }
                    continue block13;
                }
                case '*': {
                    aaIndex.setComment(this.stringValue);
                    break;
                }
                case '/': {
                    break block13;
                }
                default: {
                    throw new BioException("Invalid key char found: " + this.keyChar + "'.");
                }
            }
        }
        return aaIndex;
    }

    static {
        try {
            SymbolTokenization tokenizer = AAindex.PROTEIN_ALPHABET.getTokenization(TOKENIZER);
            aa = new Symbol[]{tokenizer.parseToken("A"), tokenizer.parseToken("R"), tokenizer.parseToken("N"), tokenizer.parseToken("D"), tokenizer.parseToken("C"), tokenizer.parseToken("Q"), tokenizer.parseToken("E"), tokenizer.parseToken("G"), tokenizer.parseToken("H"), tokenizer.parseToken("I"), tokenizer.parseToken("L"), tokenizer.parseToken("K"), tokenizer.parseToken("M"), tokenizer.parseToken("F"), tokenizer.parseToken("P"), tokenizer.parseToken("S"), tokenizer.parseToken("T"), tokenizer.parseToken("W"), tokenizer.parseToken("Y"), tokenizer.parseToken("V")};
        }
        catch (BioException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }
}

