/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.twohead.Cell;
import org.biojava.bio.dp.twohead.CellCalculator;
import org.biojava.bio.dp.twohead.CellCalculatorFactory;
import org.biojava.bio.dp.twohead.CellCalculatorFactoryMaker;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ClassTools;
import org.biojava.utils.bytecode.ByteCode;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.CodeUtils;
import org.biojava.utils.bytecode.GeneratedClassLoader;
import org.biojava.utils.bytecode.GeneratedCodeClass;
import org.biojava.utils.bytecode.GeneratedCodeMethod;
import org.biojava.utils.bytecode.IfExpression;
import org.biojava.utils.bytecode.InstructionVector;
import org.biojava.utils.bytecode.IntrospectedCodeClass;
import org.biojava.utils.bytecode.LocalVariable;

public class DPCompiler
implements CellCalculatorFactoryMaker {
    private final boolean debug = true;
    private final boolean dumpToDisk;
    private final GeneratedClassLoader classLoader;

    public DPCompiler(boolean dumpToDisk) {
        this.dumpToDisk = dumpToDisk;
        this.classLoader = new GeneratedClassLoader(ClassTools.getClassLoader(this));
    }

    public CellCalculatorFactory make(DP dp) {
        Class forwardC = this.generateForardClass(dp);
        Class backwardC = this.generateBackwardClass(dp);
        Class viterbiC = this.generateViterbiClass(dp);
        try {
            Constructor forward = forwardC.getConstructor(DP.class, ScoreType.class);
            Constructor backward = backwardC.getConstructor(DP.class, ScoreType.class);
            Constructor viterbi = viterbiC.getConstructor(DP.class, ScoreType.class, BackPointer.class);
            return new Factory(dp, forward, backward, viterbi);
        }
        catch (NoSuchMethodException nsme) {
            throw new BioError("Couldn't find constructor on generated class", nsme);
        }
    }

    public static String makeName(String prefix, MarkovModel model) {
        StringBuffer nameBuffer = new StringBuffer(prefix);
        Iterator<Symbol> i = model.stateAlphabet().iterator();
        while (i.hasNext()) {
            nameBuffer.append("_");
            try {
                nameBuffer.append(model.transitionsFrom((State)i.next()).size());
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("Assertion Failure: State dissapeared from model", ise);
            }
        }
        return nameBuffer.substring(0);
    }

    public Class generateForardClass(DP dp) {
        try {
            MarkovModel model = dp.getModel();
            String name = DPCompiler.makeName("org.biojava.bio.dp.twohead.Forward", model);
            if (!this.classLoader.hasGeneratedClass(name)) {
                CodeClass _Object = IntrospectedCodeClass.forClass(Object.class);
                CodeClass _DP = IntrospectedCodeClass.forClass(DP.class);
                CodeClass _ScoreType = IntrospectedCodeClass.forClass(ScoreType.class);
                CodeClass _State_A = IntrospectedCodeClass.forClass(State[].class);
                CodeClass _Cell_A_A = IntrospectedCodeClass.forClass(Cell[][].class);
                CodeClass _CellCalculator = IntrospectedCodeClass.forClass(CellCalculator.class);
                GeneratedCodeClass clazz = new GeneratedCodeClass(name, _Object, new CodeClass[]{_CellCalculator}, 2049);
                Symbol[] states = dp.getStates();
                AlphabetIndex stateIndexer = AlphabetManager.getAlphabetIndex(states);
                CodeField stateF = clazz.createField("states", _State_A, 4);
                CodeField[] transitionFields = new CodeField[states.length];
                AlphabetIndex[] transitionIndexers = new AlphabetIndex[states.length];
                GeneratedCodeMethod __init = clazz.createMethod("<init>", CodeUtils.TYPE_VOID, new CodeClass[]{_DP, _ScoreType}, new String[]{"dp", "scoreType"}, 1);
                clazz.setCodeGenerator((CodeMethod)__init, this.createInit(model, (State[])states, clazz, __init, transitionIndexers, transitionFields, stateF, null));
                GeneratedCodeMethod initialize = clazz.createMethod("initialize", CodeUtils.TYPE_VOID, new CodeClass[]{_Cell_A_A}, new String[]{"cells"}, 1);
                clazz.setCodeGenerator((CodeMethod)initialize, this.createFRecursion(true, model, (State[])states, stateIndexer, stateF, transitionFields, transitionIndexers, initialize));
                GeneratedCodeMethod calcCell = clazz.createMethod("calcCell", CodeUtils.TYPE_VOID, new CodeClass[]{_Cell_A_A}, new String[]{"cells"}, 1);
                clazz.setCodeGenerator((CodeMethod)calcCell, this.createFRecursion(false, model, (State[])states, stateIndexer, stateF, transitionFields, transitionIndexers, calcCell));
                if (this.dumpToDisk) {
                    try {
                        StringBuffer fName = new StringBuffer(name);
                        for (int i = 0; i < fName.length(); ++i) {
                            if (fName.charAt(i) != '.') continue;
                            fName.setCharAt(i, '/');
                        }
                        fName.append(".class");
                        File dumpFile = new File(fName.substring(0));
                        System.out.println("Dumping file: " + fName);
                        dumpFile.getParentFile().mkdirs();
                        FileOutputStream out = new FileOutputStream(dumpFile);
                        clazz.createCode((OutputStream)out);
                        ((OutputStream)out).close();
                    }
                    catch (FileNotFoundException fnfe) {
                        throw new BioError("Couldn't dump dp class", fnfe);
                    }
                    catch (IOException ioe) {
                        throw new BioError("Couldn't dump dp class", ioe);
                    }
                }
                this.classLoader.defineClass(clazz);
            }
            try {
                return this.classLoader.loadClass(name);
            }
            catch (Exception e) {
                throw new BioError("Can't find previously generated class for " + name, e);
            }
        }
        catch (CodeException ce) {
            throw new BioError("Couldn't generate class", ce);
        }
        catch (NoSuchMethodException nsme) {
            throw new BioError("Couldn't find method", nsme);
        }
        catch (NoSuchFieldException nsfe) {
            throw new BioError("Couldn't find field", nsfe);
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Couldn't find symbol", ise);
        }
        catch (BioException be) {
            throw new BioError("Couldn't create indexer", be);
        }
    }

    public Class generateBackwardClass(DP dp) {
        try {
            MarkovModel model = dp.getModel();
            String name = DPCompiler.makeName("org.biojava.bio.dp.twohead.Backward", model);
            if (!this.classLoader.hasGeneratedClass(name)) {
                CodeClass _Object = IntrospectedCodeClass.forClass(Object.class);
                CodeClass _DP = IntrospectedCodeClass.forClass(DP.class);
                CodeClass _ScoreType = IntrospectedCodeClass.forClass(ScoreType.class);
                CodeClass _State_A = IntrospectedCodeClass.forClass(State[].class);
                CodeClass _Cell_A_A = IntrospectedCodeClass.forClass(Cell[][].class);
                CodeClass _CellCalculator = IntrospectedCodeClass.forClass(CellCalculator.class);
                GeneratedCodeClass clazz = new GeneratedCodeClass(name, _Object, new CodeClass[]{_CellCalculator}, 2049);
                Symbol[] states = dp.getStates();
                AlphabetIndex stateIndexer = AlphabetManager.getAlphabetIndex(states);
                CodeField stateF = clazz.createField("states", _State_A, 4);
                CodeField[] transitionFields = new CodeField[states.length];
                AlphabetIndex[] transitionIndexers = new AlphabetIndex[states.length];
                GeneratedCodeMethod __init = clazz.createMethod("<init>", CodeUtils.TYPE_VOID, new CodeClass[]{_DP, _ScoreType}, new String[]{"dp", "scoreType"}, 1);
                clazz.setCodeGenerator((CodeMethod)__init, this.createInit(model, (State[])states, clazz, __init, transitionIndexers, transitionFields, stateF, null));
                GeneratedCodeMethod initialize = clazz.createMethod("initialize", CodeUtils.TYPE_VOID, new CodeClass[]{_Cell_A_A}, new String[]{"cells"}, 1);
                clazz.setCodeGenerator((CodeMethod)initialize, this.createBRecursion(true, model, (State[])states, stateIndexer, stateF, transitionFields, transitionIndexers, initialize));
                GeneratedCodeMethod calcCell = clazz.createMethod("calcCell", CodeUtils.TYPE_VOID, new CodeClass[]{_Cell_A_A}, new String[]{"cells"}, 1);
                clazz.setCodeGenerator((CodeMethod)calcCell, this.createBRecursion(false, model, (State[])states, stateIndexer, stateF, transitionFields, transitionIndexers, calcCell));
                if (this.dumpToDisk) {
                    try {
                        StringBuffer fName = new StringBuffer(name);
                        for (int i = 0; i < fName.length(); ++i) {
                            if (fName.charAt(i) != '.') continue;
                            fName.setCharAt(i, '/');
                        }
                        fName.append(".class");
                        File dumpFile = new File(fName.substring(0));
                        System.out.println("Dumping file: " + fName);
                        dumpFile.getParentFile().mkdirs();
                        FileOutputStream out = new FileOutputStream(dumpFile);
                        clazz.createCode((OutputStream)out);
                        ((OutputStream)out).close();
                    }
                    catch (FileNotFoundException fnfe) {
                        throw new BioError("Couldn't dump dp class", fnfe);
                    }
                    catch (IOException ioe) {
                        throw new BioError("Couldn't dump dp class", ioe);
                    }
                }
                this.classLoader.defineClass(clazz);
            }
            try {
                return this.classLoader.loadClass(name);
            }
            catch (Exception e) {
                throw new BioError("Can't find previously generated class for " + name, e);
            }
        }
        catch (CodeException ce) {
            throw new BioError("Couldn't generate class", ce);
        }
        catch (NoSuchMethodException nsme) {
            throw new BioError("Couldn't find method", nsme);
        }
        catch (NoSuchFieldException nsfe) {
            throw new BioError("Couldn't find field", nsfe);
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Couldn't find symbol", ise);
        }
        catch (BioException be) {
            throw new BioError("Couldn't create indexer", be);
        }
    }

    public Class generateViterbiClass(DP dp) {
        try {
            MarkovModel model = dp.getModel();
            String name = DPCompiler.makeName("org.biojava.bio.dp.twohead.Viterbi", model);
            if (!this.classLoader.hasGeneratedClass(name)) {
                CodeClass _Object = IntrospectedCodeClass.forClass(Object.class);
                CodeClass _DP = IntrospectedCodeClass.forClass(DP.class);
                CodeClass _BackPointer = IntrospectedCodeClass.forClass(BackPointer.class);
                CodeClass _ScoreType = IntrospectedCodeClass.forClass(ScoreType.class);
                CodeClass _State_A = IntrospectedCodeClass.forClass(State[].class);
                CodeClass _Cell_A_A = IntrospectedCodeClass.forClass(Cell[][].class);
                CodeClass _CellCalculator = IntrospectedCodeClass.forClass(CellCalculator.class);
                GeneratedCodeClass clazz = new GeneratedCodeClass(name, _Object, new CodeClass[]{_CellCalculator}, 2049);
                Symbol[] states = dp.getStates();
                AlphabetIndex stateIndexer = AlphabetManager.getAlphabetIndex(states);
                CodeField terminalBP = clazz.createField("terminalBP", _BackPointer, 4);
                CodeField stateF = clazz.createField("states", _State_A, 4);
                CodeField[] transitionFields = new CodeField[states.length];
                AlphabetIndex[] transitionIndexers = new AlphabetIndex[states.length];
                GeneratedCodeMethod __init = clazz.createMethod("<init>", CodeUtils.TYPE_VOID, new CodeClass[]{_DP, _ScoreType, _BackPointer}, new String[]{"dp", "scoreType", "backPointer"}, 1);
                clazz.setCodeGenerator((CodeMethod)__init, this.createInit(model, (State[])states, clazz, __init, transitionIndexers, transitionFields, stateF, terminalBP));
                GeneratedCodeMethod initialize = clazz.createMethod("initialize", CodeUtils.TYPE_VOID, new CodeClass[]{_Cell_A_A}, new String[]{"cells"}, 1);
                clazz.setCodeGenerator((CodeMethod)initialize, this.createVRecursion(true, model, (State[])states, stateIndexer, stateF, transitionFields, transitionIndexers, terminalBP, initialize));
                GeneratedCodeMethod calcCell = clazz.createMethod("calcCell", CodeUtils.TYPE_VOID, new CodeClass[]{_Cell_A_A}, new String[]{"cells"}, 1);
                clazz.setCodeGenerator((CodeMethod)calcCell, this.createVRecursion(false, model, (State[])states, stateIndexer, stateF, transitionFields, transitionIndexers, terminalBP, calcCell));
                if (this.dumpToDisk) {
                    try {
                        StringBuffer fName = new StringBuffer(name);
                        for (int i = 0; i < fName.length(); ++i) {
                            if (fName.charAt(i) != '.') continue;
                            fName.setCharAt(i, '/');
                        }
                        fName.append(".class");
                        File dumpFile = new File(fName.substring(0));
                        System.out.println("Dumping file: " + fName);
                        dumpFile.getParentFile().mkdirs();
                        FileOutputStream out = new FileOutputStream(dumpFile);
                        clazz.createCode((OutputStream)out);
                        ((OutputStream)out).close();
                    }
                    catch (FileNotFoundException fnfe) {
                        throw new BioError("Couldn't dump dp class", fnfe);
                    }
                    catch (IOException ioe) {
                        throw new BioError("Couldn't dump dp class", ioe);
                    }
                }
                this.classLoader.defineClass(clazz);
            }
            try {
                return this.classLoader.loadClass(name);
            }
            catch (Exception e) {
                throw new BioError("Can't find previously generated class for " + name, e);
            }
        }
        catch (CodeException ce) {
            throw new BioError("Couldn't generate class", ce);
        }
        catch (NoSuchMethodException nsme) {
            throw new BioError("Couldn't find method", nsme);
        }
        catch (NoSuchFieldException nsfe) {
            throw new BioError("Couldn't find field", nsfe);
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Couldn't find symbol", ise);
        }
        catch (BioException be) {
            throw new BioError("Couldn't create indexer", be);
        }
    }

    CodeGenerator createVRecursion(boolean isInit, MarkovModel model, State[] states, AlphabetIndex stateIndex, CodeField stateF, CodeField[] transitionFields, AlphabetIndex[] transitionIndexers, CodeField terminalBP, GeneratedCodeMethod method) throws NoSuchMethodException, NoSuchFieldException, IllegalSymbolException, CodeException {
        CodeClass _Cell = IntrospectedCodeClass.forClass(Cell.class);
        CodeField _Cell_score = _Cell.getFieldByName("scores");
        CodeField _Cell_backpointer = _Cell.getFieldByName("backPointers");
        CodeField _Cell_emissions = _Cell.getFieldByName("emissions");
        CodeClass _State = IntrospectedCodeClass.forClass(State.class);
        CodeClass _BackPointer = IntrospectedCodeClass.forClass(BackPointer.class);
        CodeClass _BackPointer_A = IntrospectedCodeClass.forClass(BackPointer[].class);
        CodeMethod _BackPointer_init = _BackPointer.getConstructor(new CodeClass[]{_State, _BackPointer, CodeUtils.TYPE_DOUBLE});
        CodeClass _double_A = IntrospectedCodeClass.forClass(double[].class);
        InstructionVector ccV = new InstructionVector();
        LocalVariable[][] cell = new LocalVariable[2][2];
        cell[0][0] = new LocalVariable(_Cell, "cell_00");
        cell[0][1] = new LocalVariable(_Cell, "cell_01");
        cell[1][0] = new LocalVariable(_Cell, "cell_10");
        cell[1][1] = new LocalVariable(_Cell, "cell_11");
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)method.getVariable("cells")));
        ccV.add((CodeGenerator)ByteCode.make_dup());
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)0));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_dup());
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)0));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)cell[0][0]));
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)1));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)cell[0][1]));
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)1));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_dup());
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)0));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)cell[1][0]));
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)1));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)cell[1][1]));
        LocalVariable[][] score = new LocalVariable[2][2];
        score[0][0] = new LocalVariable(_double_A, "score_00");
        score[0][1] = new LocalVariable(_double_A, "score_01");
        score[1][0] = new LocalVariable(_double_A, "score_10");
        score[1][1] = new LocalVariable(_double_A, "score_11");
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[0][0]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_score));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)score[0][0]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[0][1]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_score));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)score[0][1]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[1][0]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_score));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)score[1][0]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[1][1]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_score));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)score[1][1]));
        LocalVariable[][] backpointer = new LocalVariable[2][2];
        backpointer[0][0] = new LocalVariable(_BackPointer_A, "backpointer_00");
        backpointer[0][1] = new LocalVariable(_BackPointer_A, "backpointer_01");
        backpointer[1][0] = new LocalVariable(_BackPointer_A, "backpointer_10");
        backpointer[1][1] = new LocalVariable(_BackPointer_A, "backpointer_11");
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[0][0]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_backpointer));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)backpointer[0][0]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[0][1]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_backpointer));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)backpointer[0][1]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[1][0]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_backpointer));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)backpointer[1][0]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[1][1]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_backpointer));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)backpointer[1][1]));
        LocalVariable emissions = new LocalVariable(_double_A, "emissions");
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[0][0]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_emissions));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)emissions));
        LocalVariable max = new LocalVariable(CodeUtils.TYPE_DOUBLE, "max");
        LocalVariable max_j = new LocalVariable(CodeUtils.TYPE_INT, "max_j");
        for (int i = 0; i < states.length; ++i) {
            State state = states[i];
            InstructionVector stateV = new InstructionVector();
            if (isInit && state instanceof EmissionState) {
                stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)score[0][0]));
                stateV.add((CodeGenerator)ByteCode.make_iconst((int)i));
                if (state instanceof MagicalState) {
                    stateV.add((CodeGenerator)ByteCode.make_dconst((double)0.0));
                    stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)backpointer[0][0]));
                    stateV.add((CodeGenerator)ByteCode.make_iconst((int)i));
                    stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)method.getThis()));
                    stateV.add((CodeGenerator)ByteCode.make_getfield((CodeField)terminalBP));
                    stateV.add((CodeGenerator)ByteCode.make_aastore());
                } else {
                    stateV.add((CodeGenerator)ByteCode.make_dconst((double)Double.NaN));
                }
                stateV.add((CodeGenerator)ByteCode.make_dastore());
            } else {
                int[] advance = this.getAdvance(state);
                FiniteAlphabet trans = model.transitionsFrom(state);
                Iterator<Symbol> each_j = trans.iterator();
                stateV.add((CodeGenerator)ByteCode.make_dconst((double)Double.NEGATIVE_INFINITY));
                stateV.add((CodeGenerator)ByteCode.make_dstore((LocalVariable)max));
                stateV.add((CodeGenerator)ByteCode.make_iconst((int)-1));
                stateV.add((CodeGenerator)ByteCode.make_istore((LocalVariable)max_j));
                while (each_j.hasNext()) {
                    State state_j = (State)each_j.next();
                    int state_jIndx = stateIndex.indexForSymbol(state_j);
                    stateV.add((CodeGenerator)this.createTransitionLastSum(method, transitionIndexers[state_jIndx].indexForSymbol(state), state_jIndx, transitionFields, this.getAdvanced(score, advance)));
                    stateV.add((CodeGenerator)ByteCode.make_dup2());
                    stateV.add((CodeGenerator)ByteCode.make_dload((LocalVariable)max));
                    stateV.add((CodeGenerator)ByteCode.make_dcmpl());
                    InstructionVector saveNewMax = new InstructionVector();
                    saveNewMax.add((CodeGenerator)ByteCode.make_dstore((LocalVariable)max));
                    saveNewMax.add((CodeGenerator)ByteCode.make_iconst((int)state_jIndx));
                    saveNewMax.add((CodeGenerator)ByteCode.make_istore((LocalVariable)max_j));
                    InstructionVector useOldMax = new InstructionVector();
                    useOldMax.add((CodeGenerator)ByteCode.make_pop2());
                    stateV.add((CodeGenerator)new IfExpression(-100, (CodeGenerator)saveNewMax, (CodeGenerator)useOldMax));
                }
                stateV.add((CodeGenerator)ByteCode.make_iload((LocalVariable)max_j));
                InstructionVector ifNoIn = new InstructionVector();
                InstructionVector ifGotIn = new InstructionVector();
                ifNoIn.add((CodeGenerator)ByteCode.make_aload((LocalVariable)score[0][0]));
                ifNoIn.add((CodeGenerator)ByteCode.make_iconst((int)i));
                ifNoIn.add((CodeGenerator)ByteCode.make_dconst((double)Double.NaN));
                ifNoIn.add((CodeGenerator)ByteCode.make_dastore());
                ifNoIn.add((CodeGenerator)ByteCode.make_aload((LocalVariable)backpointer[0][0]));
                ifNoIn.add((CodeGenerator)ByteCode.make_iconst((int)i));
                ifNoIn.add((CodeGenerator)ByteCode.make_aconst_null());
                ifNoIn.add((CodeGenerator)ByteCode.make_aastore());
                ifGotIn.add((CodeGenerator)ByteCode.make_aload((LocalVariable)score[0][0]));
                ifGotIn.add((CodeGenerator)ByteCode.make_iconst((int)i));
                ifGotIn.add((CodeGenerator)ByteCode.make_dload((LocalVariable)max));
                if (state instanceof EmissionState) {
                    ifGotIn.add((CodeGenerator)ByteCode.make_aload((LocalVariable)emissions));
                    ifGotIn.add((CodeGenerator)ByteCode.make_iconst((int)i));
                    ifGotIn.add((CodeGenerator)ByteCode.make_daload());
                    ifGotIn.add((CodeGenerator)ByteCode.make_dadd());
                }
                ifGotIn.add((CodeGenerator)ByteCode.make_dastore());
                ifGotIn.add((CodeGenerator)ByteCode.make_aload((LocalVariable)backpointer[0][0]));
                ifGotIn.add((CodeGenerator)ByteCode.make_iconst((int)i));
                ifGotIn.add((CodeGenerator)ByteCode.make_new((CodeClass)_BackPointer));
                ifGotIn.add((CodeGenerator)ByteCode.make_dup());
                ifGotIn.add((CodeGenerator)ByteCode.make_aload((LocalVariable)method.getThis()));
                ifGotIn.add((CodeGenerator)ByteCode.make_getfield((CodeField)stateF));
                ifGotIn.add((CodeGenerator)ByteCode.make_iconst((int)i));
                ifGotIn.add((CodeGenerator)ByteCode.make_aaload());
                ifGotIn.add((CodeGenerator)ByteCode.make_aload((LocalVariable)this.getAdvanced(backpointer, advance)));
                ifGotIn.add((CodeGenerator)ByteCode.make_iload((LocalVariable)max_j));
                ifGotIn.add((CodeGenerator)ByteCode.make_aaload());
                ifGotIn.add((CodeGenerator)ByteCode.make_aload((LocalVariable)score[0][0]));
                ifGotIn.add((CodeGenerator)ByteCode.make_iconst((int)i));
                ifGotIn.add((CodeGenerator)ByteCode.make_daload());
                ifGotIn.add((CodeGenerator)ByteCode.make_invokespecial((CodeMethod)_BackPointer_init));
                ifGotIn.add((CodeGenerator)ByteCode.make_aastore());
                stateV.add((CodeGenerator)new IfExpression(-100, (CodeGenerator)ifGotIn, (CodeGenerator)ifNoIn));
            }
            ccV.add((CodeGenerator)stateV);
        }
        ccV.add((CodeGenerator)ByteCode.make_return());
        return ccV;
    }

    private CodeGenerator createFRecursion(boolean isInit, MarkovModel model, State[] states, AlphabetIndex stateIndex, CodeField stateF, CodeField[] transitionFields, AlphabetIndex[] transitionIndexers, GeneratedCodeMethod method) throws NoSuchMethodException, NoSuchFieldException, IllegalSymbolException, CodeException {
        CodeClass _Cell = IntrospectedCodeClass.forClass(Cell.class);
        CodeField _Cell_score = _Cell.getFieldByName("scores");
        CodeField _Cell_emissions = _Cell.getFieldByName("emissions");
        CodeClass _double_A = IntrospectedCodeClass.forClass(double[].class);
        CodeClass _Math = IntrospectedCodeClass.forClass(Math.class);
        CodeMethod _Math_exp = _Math.getMethod("exp", new CodeClass[]{CodeUtils.TYPE_DOUBLE});
        CodeMethod _Math_log = _Math.getMethod("log", new CodeClass[]{CodeUtils.TYPE_DOUBLE});
        InstructionVector ccV = new InstructionVector();
        ccV.add(this.debug(this.message("Retrieving local variables")));
        LocalVariable[][] cell = new LocalVariable[2][2];
        cell[0][0] = new LocalVariable(_Cell, "cell_00");
        cell[0][1] = new LocalVariable(_Cell, "cell_01");
        cell[1][0] = new LocalVariable(_Cell, "cell_10");
        cell[1][1] = new LocalVariable(_Cell, "cell_11");
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)method.getVariable("cells")));
        ccV.add((CodeGenerator)ByteCode.make_dup());
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)0));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_dup());
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)0));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)cell[0][0]));
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)1));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)cell[0][1]));
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)1));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_dup());
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)0));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)cell[1][0]));
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)1));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)cell[1][1]));
        LocalVariable[][] score = new LocalVariable[2][2];
        score[0][0] = new LocalVariable(_double_A, "score_00");
        score[0][1] = new LocalVariable(_double_A, "score_01");
        score[1][0] = new LocalVariable(_double_A, "score_10");
        score[1][1] = new LocalVariable(_double_A, "score_11");
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[0][0]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_score));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)score[0][0]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[0][1]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_score));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)score[0][1]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[1][0]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_score));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)score[1][0]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[1][1]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_score));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)score[1][1]));
        LocalVariable emissions = new LocalVariable(_double_A, "emissions");
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[0][0]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_emissions));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)emissions));
        LocalVariable max = new LocalVariable(CodeUtils.TYPE_DOUBLE, "max");
        for (int i = 0; i < states.length; ++i) {
            State state = states[i];
            InstructionVector stateV = new InstructionVector();
            stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)score[0][0]));
            stateV.add((CodeGenerator)ByteCode.make_iconst((int)i));
            if (isInit && state instanceof EmissionState) {
                if (state instanceof MagicalState) {
                    stateV.add((CodeGenerator)ByteCode.make_dconst((double)0.0));
                } else {
                    stateV.add((CodeGenerator)ByteCode.make_dconst((double)Double.NaN));
                }
            } else {
                int[] advance = this.getAdvance(state);
                FiniteAlphabet trans = model.transitionsFrom(state);
                LocalVariable j_scores = this.getAdvanced(score, advance);
                if (trans.size() == 1) {
                    State state_j = (State)trans.iterator().next();
                    int state_jIndx = stateIndex.indexForSymbol(state_j);
                    stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)method.getThis()));
                    stateV.add((CodeGenerator)ByteCode.make_getfield((CodeField)transitionFields[state_jIndx]));
                    stateV.add((CodeGenerator)ByteCode.make_iconst((int)transitionIndexers[state_jIndx].indexForSymbol(state)));
                    stateV.add((CodeGenerator)ByteCode.make_daload());
                    stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)j_scores));
                    stateV.add((CodeGenerator)ByteCode.make_iconst((int)state_jIndx));
                    stateV.add((CodeGenerator)ByteCode.make_daload());
                    stateV.add((CodeGenerator)ByteCode.make_dadd());
                    if (state instanceof EmissionState) {
                        stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)emissions));
                        stateV.add((CodeGenerator)ByteCode.make_iconst((int)i));
                        stateV.add((CodeGenerator)ByteCode.make_daload());
                        stateV.add((CodeGenerator)ByteCode.make_dadd());
                    }
                } else {
                    stateV.add((CodeGenerator)ByteCode.make_dconst((double)Double.NEGATIVE_INFINITY));
                    stateV.add((CodeGenerator)ByteCode.make_dstore((LocalVariable)max));
                    Iterator<Symbol> each_j = trans.iterator();
                    while (each_j.hasNext()) {
                        State state_j = (State)each_j.next();
                        int state_jIndx = stateIndex.indexForSymbol(state_j);
                        stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)j_scores));
                        stateV.add((CodeGenerator)ByteCode.make_iconst((int)state_jIndx));
                        stateV.add((CodeGenerator)ByteCode.make_daload());
                        stateV.add((CodeGenerator)ByteCode.make_dup2());
                        stateV.add((CodeGenerator)ByteCode.make_dload((LocalVariable)max));
                        stateV.add((CodeGenerator)ByteCode.make_dcmpl());
                        InstructionVector ifLargerThanMax = new InstructionVector();
                        ifLargerThanMax.add((CodeGenerator)ByteCode.make_dstore((LocalVariable)max));
                        InstructionVector ifSmallerThanMax = new InstructionVector();
                        ifSmallerThanMax.add((CodeGenerator)ByteCode.make_pop2());
                        stateV.add((CodeGenerator)new IfExpression(-100, (CodeGenerator)ifLargerThanMax, (CodeGenerator)ifSmallerThanMax));
                    }
                    LocalVariable maxDB = new LocalVariable(CodeUtils.TYPE_DOUBLE, "max");
                    InstructionVector dbi = new InstructionVector();
                    dbi.add((CodeGenerator)ByteCode.make_dload((LocalVariable)max));
                    dbi.add((CodeGenerator)ByteCode.make_dstore((LocalVariable)maxDB));
                    dbi.add(this.message("Max " + i + " = ", maxDB));
                    stateV.add(this.debug((CodeGenerator)dbi));
                    stateV.add((CodeGenerator)ByteCode.make_dconst((double)0.0));
                    each_j = trans.iterator();
                    while (each_j.hasNext()) {
                        State state_j = (State)each_j.next();
                        int state_jIndx = stateIndex.indexForSymbol(state_j);
                        stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)j_scores));
                        stateV.add((CodeGenerator)ByteCode.make_iconst((int)state_jIndx));
                        stateV.add((CodeGenerator)ByteCode.make_daload());
                        stateV.add((CodeGenerator)ByteCode.make_dup2());
                        stateV.add((CodeGenerator)ByteCode.make_dup2());
                        stateV.add((CodeGenerator)ByteCode.make_dcmpl());
                        InstructionVector scoreNotNaN = new InstructionVector();
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_dload((LocalVariable)max));
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_dsub());
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_aload((LocalVariable)method.getThis()));
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_getfield((CodeField)transitionFields[state_jIndx]));
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_iconst((int)transitionIndexers[state_jIndx].indexForSymbol(state)));
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_daload());
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_dadd());
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_invokestatic((CodeMethod)_Math_exp));
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_dadd());
                        InstructionVector scoreIsNaN = new InstructionVector();
                        scoreIsNaN.add((CodeGenerator)ByteCode.make_pop2());
                        stateV.add((CodeGenerator)new IfExpression(-100, (CodeGenerator)scoreNotNaN, (CodeGenerator)scoreIsNaN));
                    }
                    stateV.add((CodeGenerator)ByteCode.make_invokestatic((CodeMethod)_Math_log));
                    if (state instanceof EmissionState) {
                        stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)emissions));
                        stateV.add((CodeGenerator)ByteCode.make_iconst((int)i));
                        stateV.add((CodeGenerator)ByteCode.make_daload());
                        stateV.add((CodeGenerator)ByteCode.make_dadd());
                    }
                    stateV.add((CodeGenerator)ByteCode.make_dload((LocalVariable)max));
                    stateV.add((CodeGenerator)ByteCode.make_dadd());
                }
            }
            stateV.add((CodeGenerator)ByteCode.make_dastore());
            ccV.add((CodeGenerator)stateV);
        }
        LocalVariable sc = new LocalVariable(CodeUtils.TYPE_DOUBLE, "score_i");
        InstructionVector dbi = new InstructionVector();
        for (int i = 0; i < states.length; ++i) {
            dbi.add((CodeGenerator)ByteCode.make_aload((LocalVariable)score[0][0]));
            dbi.add((CodeGenerator)ByteCode.make_iconst((int)i));
            dbi.add((CodeGenerator)ByteCode.make_daload());
            dbi.add((CodeGenerator)ByteCode.make_dstore((LocalVariable)sc));
            dbi.add(this.message("Score " + i + " = ", sc));
        }
        ccV.add(this.debug((CodeGenerator)dbi));
        ccV.add((CodeGenerator)ByteCode.make_return());
        return ccV;
    }

    private CodeGenerator createBRecursion(boolean isInit, MarkovModel model, State[] states, AlphabetIndex stateIndex, CodeField stateF, CodeField[] transitionFields, AlphabetIndex[] transitionIndexers, GeneratedCodeMethod method) throws NoSuchMethodException, NoSuchFieldException, IllegalSymbolException, CodeException {
        CodeClass _Cell = IntrospectedCodeClass.forClass(Cell.class);
        CodeField _Cell_score = _Cell.getFieldByName("scores");
        CodeField _Cell_emissions = _Cell.getFieldByName("emissions");
        CodeClass _double_A = IntrospectedCodeClass.forClass(double[].class);
        CodeClass _Math = IntrospectedCodeClass.forClass(Math.class);
        CodeMethod _Math_exp = _Math.getMethod("exp", new CodeClass[]{CodeUtils.TYPE_DOUBLE});
        CodeMethod _Math_log = _Math.getMethod("log", new CodeClass[]{CodeUtils.TYPE_DOUBLE});
        InstructionVector ccV = new InstructionVector();
        ccV.add(this.debug(this.message("Retrieving local variables")));
        LocalVariable[][] cell = new LocalVariable[2][2];
        cell[0][0] = new LocalVariable(_Cell, "cell_00");
        cell[0][1] = new LocalVariable(_Cell, "cell_01");
        cell[1][0] = new LocalVariable(_Cell, "cell_10");
        cell[1][1] = new LocalVariable(_Cell, "cell_11");
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)method.getVariable("cells")));
        ccV.add((CodeGenerator)ByteCode.make_dup());
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)0));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_dup());
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)0));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)cell[0][0]));
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)1));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)cell[0][1]));
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)1));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_dup());
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)0));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)cell[1][0]));
        ccV.add((CodeGenerator)ByteCode.make_iconst((int)1));
        ccV.add((CodeGenerator)ByteCode.make_aaload());
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)cell[1][1]));
        LocalVariable[][] score = new LocalVariable[2][2];
        score[0][0] = new LocalVariable(_double_A, "score_00");
        score[0][1] = new LocalVariable(_double_A, "score_01");
        score[1][0] = new LocalVariable(_double_A, "score_10");
        score[1][1] = new LocalVariable(_double_A, "score_11");
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[0][0]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_score));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)score[0][0]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[0][1]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_score));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)score[0][1]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[1][0]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_score));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)score[1][0]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[1][1]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_score));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)score[1][1]));
        LocalVariable[][] emission = new LocalVariable[2][2];
        emission[0][1] = new LocalVariable(_double_A, "emission_01");
        emission[1][0] = new LocalVariable(_double_A, "emission_10");
        emission[1][1] = new LocalVariable(_double_A, "emission_11");
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[0][1]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_emissions));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)emission[0][1]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[1][0]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_emissions));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)emission[1][0]));
        ccV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)cell[1][1]));
        ccV.add((CodeGenerator)ByteCode.make_getfield((CodeField)_Cell_emissions));
        ccV.add((CodeGenerator)ByteCode.make_astore((LocalVariable)emission[1][1]));
        LocalVariable max = new LocalVariable(CodeUtils.TYPE_DOUBLE, "max");
        for (int i = states.length - 1; i >= 0; --i) {
            State state = states[i];
            ccV.add(this.debug(this.message("Calculating for state " + i + " " + state.getName())));
            InstructionVector stateV = new InstructionVector();
            stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)score[0][0]));
            stateV.add((CodeGenerator)ByteCode.make_iconst((int)i));
            if (isInit && state instanceof EmissionState) {
                stateV.add(this.debug(this.message("initalizing")));
                if (state instanceof MagicalState) {
                    stateV.add(this.debug(this.message("magical")));
                    stateV.add((CodeGenerator)ByteCode.make_dconst((double)0.0));
                } else {
                    stateV.add(this.debug(this.message("mundane")));
                    stateV.add((CodeGenerator)ByteCode.make_dconst((double)Double.NaN));
                }
            } else {
                FiniteAlphabet trans = model.transitionsFrom(state);
                if (trans.size() == 1) {
                    stateV.add(this.debug(this.message("single-source optimization")));
                    State state_j = (State)trans.iterator().next();
                    int state_jIndx = stateIndex.indexForSymbol(state_j);
                    int[] advance = this.getAdvance(state_j);
                    stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)method.getThis()));
                    stateV.add((CodeGenerator)ByteCode.make_getfield((CodeField)transitionFields[i]));
                    stateV.add((CodeGenerator)ByteCode.make_iconst((int)transitionIndexers[i].indexForSymbol(state_j)));
                    stateV.add((CodeGenerator)ByteCode.make_daload());
                    stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)this.getAdvanced(score, advance)));
                    stateV.add((CodeGenerator)ByteCode.make_iconst((int)state_jIndx));
                    stateV.add((CodeGenerator)ByteCode.make_daload());
                    stateV.add((CodeGenerator)ByteCode.make_dadd());
                    if (state_j instanceof EmissionState) {
                        stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)this.getAdvanced(emission, advance)));
                        stateV.add((CodeGenerator)ByteCode.make_iconst((int)i));
                        stateV.add((CodeGenerator)ByteCode.make_daload());
                        stateV.add((CodeGenerator)ByteCode.make_dadd());
                    }
                    LocalVariable tmp = new LocalVariable(CodeUtils.TYPE_DOUBLE, "tmp");
                    InstructionVector dbi = new InstructionVector();
                    dbi.add((CodeGenerator)ByteCode.make_dup2());
                    dbi.add((CodeGenerator)ByteCode.make_dstore((LocalVariable)tmp));
                    dbi.add(this.message("got sum of ", tmp));
                    stateV.add(this.debug((CodeGenerator)dbi));
                } else {
                    int[] advance;
                    stateV.add(this.debug(this.message("full recursion")));
                    stateV.add((CodeGenerator)ByteCode.make_dconst((double)Double.NEGATIVE_INFINITY));
                    stateV.add((CodeGenerator)ByteCode.make_dstore((LocalVariable)max));
                    Iterator<Symbol> each_j = trans.iterator();
                    while (each_j.hasNext()) {
                        State state_j = (State)each_j.next();
                        int state_jIndx = stateIndex.indexForSymbol(state_j);
                        advance = this.getAdvance(state_j);
                        stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)this.getAdvanced(score, advance)));
                        stateV.add((CodeGenerator)ByteCode.make_iconst((int)state_jIndx));
                        stateV.add((CodeGenerator)ByteCode.make_daload());
                        stateV.add((CodeGenerator)ByteCode.make_dup2());
                        stateV.add((CodeGenerator)ByteCode.make_dload((LocalVariable)max));
                        stateV.add((CodeGenerator)ByteCode.make_dcmpl());
                        InstructionVector ifLargerThanMax = new InstructionVector();
                        ifLargerThanMax.add(this.debug(this.message("Larger")));
                        ifLargerThanMax.add(this.debug(this.message("  max: ", max)));
                        ifLargerThanMax.add((CodeGenerator)ByteCode.make_dstore((LocalVariable)max));
                        InstructionVector ifSmallerThanMax = new InstructionVector();
                        ifSmallerThanMax.add(this.debug(this.message("Smaller")));
                        ifSmallerThanMax.add(this.debug(this.message("  max: ", max)));
                        ifSmallerThanMax.add((CodeGenerator)ByteCode.make_pop2());
                        stateV.add((CodeGenerator)new IfExpression(-100, (CodeGenerator)ifLargerThanMax, (CodeGenerator)ifSmallerThanMax));
                    }
                    stateV.add(this.debug(this.message("Taking out factor ", max)));
                    stateV.add((CodeGenerator)ByteCode.make_dconst((double)0.0));
                    each_j = trans.iterator();
                    while (each_j.hasNext()) {
                        State state_j = (State)each_j.next();
                        int state_jIndx = stateIndex.indexForSymbol(state_j);
                        advance = this.getAdvance(state_j);
                        stateV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)this.getAdvanced(score, advance)));
                        stateV.add((CodeGenerator)ByteCode.make_iconst((int)state_jIndx));
                        stateV.add((CodeGenerator)ByteCode.make_daload());
                        stateV.add((CodeGenerator)ByteCode.make_dup2());
                        stateV.add((CodeGenerator)ByteCode.make_dup2());
                        stateV.add((CodeGenerator)ByteCode.make_dcmpl());
                        InstructionVector scoreNotNaN = new InstructionVector();
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_dload((LocalVariable)max));
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_dsub());
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_aload((LocalVariable)method.getThis()));
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_getfield((CodeField)transitionFields[i]));
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_iconst((int)transitionIndexers[i].indexForSymbol(state_j)));
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_daload());
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_dadd());
                        if (state_j instanceof EmissionState) {
                            scoreNotNaN.add((CodeGenerator)ByteCode.make_aload((LocalVariable)this.getAdvanced(score, advance)));
                            scoreNotNaN.add((CodeGenerator)ByteCode.make_iconst((int)state_jIndx));
                            scoreNotNaN.add((CodeGenerator)ByteCode.make_daload());
                            scoreNotNaN.add((CodeGenerator)ByteCode.make_dadd());
                        }
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_invokestatic((CodeMethod)_Math_exp));
                        scoreNotNaN.add((CodeGenerator)ByteCode.make_dadd());
                        InstructionVector scoreIsNaN = new InstructionVector();
                        scoreIsNaN.add((CodeGenerator)ByteCode.make_pop2());
                        stateV.add((CodeGenerator)new IfExpression(-100, (CodeGenerator)scoreNotNaN, (CodeGenerator)scoreIsNaN));
                    }
                    stateV.add((CodeGenerator)ByteCode.make_invokestatic((CodeMethod)_Math_log));
                    stateV.add((CodeGenerator)ByteCode.make_dload((LocalVariable)max));
                    stateV.add((CodeGenerator)ByteCode.make_dadd());
                }
            }
            stateV.add((CodeGenerator)ByteCode.make_dastore());
            ccV.add((CodeGenerator)stateV);
        }
        LocalVariable sc = new LocalVariable(CodeUtils.TYPE_DOUBLE, "score_i");
        InstructionVector dbi = new InstructionVector();
        for (int i = 0; i < states.length; ++i) {
            dbi.add((CodeGenerator)ByteCode.make_aload((LocalVariable)score[0][0]));
            dbi.add((CodeGenerator)ByteCode.make_iconst((int)i));
            dbi.add((CodeGenerator)ByteCode.make_daload());
            dbi.add((CodeGenerator)ByteCode.make_dstore((LocalVariable)sc));
            dbi.add(this.message("Score " + i + " = ", sc));
        }
        ccV.add(this.debug((CodeGenerator)dbi));
        ccV.add((CodeGenerator)ByteCode.make_return());
        return ccV;
    }

    private CodeGenerator createInit(MarkovModel model, State[] states, GeneratedCodeClass clazz, GeneratedCodeMethod __init, AlphabetIndex[] transitionIndexers, CodeField[] transitionFields, CodeField stateF, CodeField terminalBP) throws NoSuchFieldException, NoSuchMethodException, CodeException, IllegalSymbolException, BioException {
        CodeClass _Object = IntrospectedCodeClass.forClass(Object.class);
        CodeMethod _Object_init = _Object.getConstructor(CodeUtils.EMPTY_LIST);
        CodeClass _Symbol = IntrospectedCodeClass.forClass(Symbol.class);
        CodeClass _State = IntrospectedCodeClass.forClass(State.class);
        CodeClass _State_A = IntrospectedCodeClass.forClass(State[].class);
        CodeClass _double_A = IntrospectedCodeClass.forClass(double[].class);
        CodeClass _DP = IntrospectedCodeClass.forClass(DP.class);
        CodeMethod _DP_getStates = _DP.getMethod("getStates", CodeUtils.EMPTY_LIST);
        CodeMethod _DP_getModel = _DP.getMethod("getModel", CodeUtils.EMPTY_LIST);
        CodeClass _Distribution = IntrospectedCodeClass.forClass(Distribution.class);
        CodeMethod _Distribution_getAlphabet = _Distribution.getMethod("getAlphabet", CodeUtils.EMPTY_LIST);
        CodeClass _ScoreType = IntrospectedCodeClass.forClass(ScoreType.class);
        CodeMethod _ScoreType_calculateScore = _ScoreType.getMethod("calculateScore", new CodeClass[]{_Distribution, _Symbol});
        CodeClass _MarkovModel = IntrospectedCodeClass.forClass(MarkovModel.class);
        CodeMethod _MarkovModel_getWeights = _MarkovModel.getMethod("getWeights", new CodeClass[]{_State});
        CodeClass _FiniteAlphabet = IntrospectedCodeClass.forClass(FiniteAlphabet.class);
        CodeMethod _FiniteAlphabet_size = _FiniteAlphabet.getMethod("size", CodeUtils.EMPTY_LIST);
        CodeClass _Math = IntrospectedCodeClass.forClass(Math.class);
        CodeMethod _Math_log = _Math.getMethod("log", new CodeClass[]{CodeUtils.TYPE_DOUBLE});
        int[] indexToFieldIndex = new int[states.length];
        HashMap<Distribution, Integer> distToIndx = new HashMap<Distribution, Integer>();
        for (int i = 0; i < states.length; ++i) {
            State s = states[i];
            Distribution dist = model.getWeights(s);
            Integer indxI = (Integer)distToIndx.get(dist);
            if (indxI == null) {
                indxI = new Integer(i);
                distToIndx.put(dist, indxI);
                transitionFields[i] = clazz.createField("t_" + i, _double_A, 4);
                indexToFieldIndex[i] = i;
                continue;
            }
            int indx = indxI;
            transitionFields[i] = transitionFields[indx];
            indexToFieldIndex[i] = indexToFieldIndex[indx];
        }
        InstructionVector initG = new InstructionVector();
        initG.add((CodeGenerator)ByteCode.make_aload((LocalVariable)__init.getThis()));
        initG.add((CodeGenerator)ByteCode.make_invokespecial((CodeMethod)_Object_init));
        LocalVariable statesLV = new LocalVariable(_State_A, "states");
        LocalVariable modelLV = new LocalVariable(_MarkovModel, "model");
        initG.add((CodeGenerator)ByteCode.make_aload((LocalVariable)__init.getVariable("dp")));
        initG.add((CodeGenerator)ByteCode.make_dup());
        initG.add((CodeGenerator)ByteCode.make_invokevirtual((CodeMethod)_DP_getStates));
        initG.add((CodeGenerator)ByteCode.make_astore((LocalVariable)statesLV));
        initG.add((CodeGenerator)ByteCode.make_invokevirtual((CodeMethod)_DP_getModel));
        initG.add((CodeGenerator)ByteCode.make_astore((LocalVariable)modelLV));
        initG.add((CodeGenerator)ByteCode.make_aload((LocalVariable)__init.getThis()));
        initG.add((CodeGenerator)ByteCode.make_aload((LocalVariable)statesLV));
        initG.add((CodeGenerator)ByteCode.make_putfield((CodeField)stateF));
        if (terminalBP != null) {
            initG.add((CodeGenerator)ByteCode.make_aload((LocalVariable)__init.getThis()));
            initG.add((CodeGenerator)ByteCode.make_aload((LocalVariable)__init.getVariable("backPointer")));
            initG.add((CodeGenerator)ByteCode.make_putfield((CodeField)terminalBP));
        }
        LocalVariable distLV = new LocalVariable(_Distribution, "dist");
        for (int i = 0; i < transitionFields.length; ++i) {
            if (indexToFieldIndex[i] != i) continue;
            Distribution dist = model.getWeights(states[i]);
            initG.add((CodeGenerator)ByteCode.make_aload((LocalVariable)modelLV));
            initG.add((CodeGenerator)ByteCode.make_aload((LocalVariable)statesLV));
            initG.add((CodeGenerator)ByteCode.make_iconst((int)i));
            initG.add((CodeGenerator)ByteCode.make_aaload());
            initG.add((CodeGenerator)ByteCode.make_invokeinterface((CodeMethod)_MarkovModel_getWeights));
            initG.add((CodeGenerator)ByteCode.make_astore((LocalVariable)distLV));
            int size = ((FiniteAlphabet)dist.getAlphabet()).size();
            Symbol[] transitionSymbols = new Symbol[size];
            initG.add((CodeGenerator)ByteCode.make_aload((LocalVariable)distLV));
            initG.add((CodeGenerator)ByteCode.make_invokeinterface((CodeMethod)_Distribution_getAlphabet));
            initG.add((CodeGenerator)ByteCode.make_invokeinterface((CodeMethod)_FiniteAlphabet_size));
            initG.add((CodeGenerator)ByteCode.make_iconst((int)size));
            initG.add((CodeGenerator)ByteCode.make_newarray((CodeClass)CodeUtils.TYPE_DOUBLE));
            initG.add((CodeGenerator)ByteCode.make_dup());
            initG.add((CodeGenerator)ByteCode.make_aload((LocalVariable)__init.getThis()));
            initG.add((CodeGenerator)ByteCode.make_swap());
            initG.add((CodeGenerator)ByteCode.make_putfield((CodeField)transitionFields[i]));
            int j = 0;
            for (int jj = 0; jj < states.length; ++jj) {
                State state = states[jj];
                if (!dist.getAlphabet().contains(state)) continue;
                transitionSymbols[j] = state;
                initG.add((CodeGenerator)ByteCode.make_dup());
                initG.add((CodeGenerator)ByteCode.make_iconst((int)j));
                initG.add((CodeGenerator)ByteCode.make_aload((LocalVariable)__init.getVariable("scoreType")));
                initG.add((CodeGenerator)ByteCode.make_aload((LocalVariable)distLV));
                initG.add((CodeGenerator)ByteCode.make_aload((LocalVariable)statesLV));
                initG.add((CodeGenerator)ByteCode.make_iconst((int)jj));
                initG.add((CodeGenerator)ByteCode.make_aaload());
                initG.add((CodeGenerator)ByteCode.make_invokeinterface((CodeMethod)_ScoreType_calculateScore));
                initG.add((CodeGenerator)ByteCode.make_invokestatic((CodeMethod)_Math_log));
                initG.add((CodeGenerator)ByteCode.make_dastore());
                ++j;
            }
            transitionIndexers[i] = AlphabetManager.getAlphabetIndex(transitionSymbols);
            initG.add((CodeGenerator)ByteCode.make_pop());
        }
        initG.add((CodeGenerator)ByteCode.make_return());
        return initG;
    }

    private InstructionVector createTransitionLastSum(GeneratedCodeMethod method, int i, int j, CodeField[] transition, LocalVariable lastScore) throws CodeException {
        InstructionVector sumV = new InstructionVector();
        sumV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)method.getThis()));
        sumV.add((CodeGenerator)ByteCode.make_getfield((CodeField)transition[j]));
        sumV.add((CodeGenerator)ByteCode.make_iconst((int)i));
        sumV.add((CodeGenerator)ByteCode.make_daload());
        sumV.add((CodeGenerator)ByteCode.make_aload((LocalVariable)lastScore));
        sumV.add((CodeGenerator)ByteCode.make_iconst((int)j));
        sumV.add((CodeGenerator)ByteCode.make_daload());
        sumV.add((CodeGenerator)ByteCode.make_dadd());
        return sumV;
    }

    private CodeGenerator message(String message) {
        try {
            CodeClass _String = IntrospectedCodeClass.forClass(String.class);
            CodeClass _System = IntrospectedCodeClass.forClass(System.class);
            CodeField _System_out = _System.getFieldByName("out");
            CodeClass _PrintStream = IntrospectedCodeClass.forClass(PrintStream.class);
            CodeMethod _PrintStream_println = _PrintStream.getMethod("println", new CodeClass[]{_String});
            InstructionVector iv = new InstructionVector();
            iv.add((CodeGenerator)ByteCode.make_getstatic((CodeField)_System_out));
            iv.add((CodeGenerator)ByteCode.make_sconst((String)message));
            iv.add((CodeGenerator)ByteCode.make_invokevirtual((CodeMethod)_PrintStream_println));
            return iv;
        }
        catch (NoSuchFieldException nsfe) {
            throw new BioError("Can't make message statements", nsfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new BioError("Can't make message statements", nsme);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CodeGenerator message(String message, LocalVariable var) {
        try {
            CodeMethod _PrintStream_printXln;
            CodeClass _Object = IntrospectedCodeClass.forClass(Object.class);
            CodeClass _String = IntrospectedCodeClass.forClass(String.class);
            CodeClass _System = IntrospectedCodeClass.forClass(System.class);
            CodeField _System_out = _System.getFieldByName("out");
            CodeClass _PrintStream = IntrospectedCodeClass.forClass(PrintStream.class);
            CodeMethod _PrintStream_print = _PrintStream.getMethod("print", new CodeClass[]{_String});
            InstructionVector iv = new InstructionVector();
            iv.add((CodeGenerator)ByteCode.make_getstatic((CodeField)_System_out));
            iv.add((CodeGenerator)ByteCode.make_sconst((String)message));
            iv.add((CodeGenerator)ByteCode.make_invokevirtual((CodeMethod)_PrintStream_print));
            iv.add((CodeGenerator)ByteCode.make_getstatic((CodeField)_System_out));
            if (var.getType().isPrimitive()) {
                _PrintStream_printXln = _PrintStream.getMethod("println", new CodeClass[]{var.getType()});
                if (var.getType() == CodeUtils.TYPE_INT) {
                    iv.add((CodeGenerator)ByteCode.make_iload((LocalVariable)var));
                } else {
                    if (var.getType() != CodeUtils.TYPE_DOUBLE) throw new BioError("Unsupported primative " + var.getType());
                    iv.add((CodeGenerator)ByteCode.make_dload((LocalVariable)var));
                }
            } else {
                iv.add((CodeGenerator)ByteCode.make_aload((LocalVariable)var));
                _PrintStream_printXln = _PrintStream.getMethod("println", new CodeClass[]{_Object});
            }
            iv.add((CodeGenerator)ByteCode.make_invokevirtual((CodeMethod)_PrintStream_printXln));
            return iv;
        }
        catch (NoSuchFieldException nsfe) {
            throw new BioError("Can't make message statements", nsfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new BioError("Can't make message statements", nsme);
        }
        catch (CodeException ce) {
            throw new BioError("Can't make message statements", ce);
        }
    }

    private CodeGenerator debug(CodeGenerator child) {
        return child;
    }

    private int[] getAdvance(State s) {
        if (s instanceof EmissionState) {
            return ((EmissionState)s).getAdvance();
        }
        return new int[]{0, 0};
    }

    private LocalVariable getAdvanced(LocalVariable[][] what, int[] advance) {
        return what[advance[0]][advance[1]];
    }

    private static class Factory
    implements CellCalculatorFactory {
        private final DP dp;
        private final Constructor forwards;
        private final Constructor backwards;
        private final Constructor viterbi;

        public Factory(DP dp, Constructor forwards, Constructor backwards, Constructor viterbi) {
            this.dp = dp;
            this.viterbi = viterbi;
            this.forwards = forwards;
            this.backwards = backwards;
        }

        public CellCalculator forwards(ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            try {
                return (CellCalculator)this.forwards.newInstance(this.dp, scoreType);
            }
            catch (InstantiationException ie) {
                throw new BioError("Counld not instantiate auto-generated class");
            }
            catch (IllegalAccessException ie) {
                throw new BioError("Counld not instantiate auto-generated class");
            }
            catch (InvocationTargetException ie) {
                throw new BioError("Counld not instantiate auto-generated class");
            }
        }

        public CellCalculator backwards(ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            try {
                return (CellCalculator)this.backwards.newInstance(this.dp, scoreType);
            }
            catch (InstantiationException ie) {
                throw new BioError("Counld not instantiate auto-generated class");
            }
            catch (IllegalAccessException ie) {
                throw new BioError("Counld not instantiate auto-generated class");
            }
            catch (InvocationTargetException ie) {
                throw new BioError("Counld not instantiate auto-generated class");
            }
        }

        public CellCalculator viterbi(ScoreType scoreType, BackPointer terminal) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            try {
                return (CellCalculator)this.viterbi.newInstance(this.dp, scoreType, terminal);
            }
            catch (InstantiationException ie) {
                throw new BioError("Counld not instantiate auto-generated class", ie);
            }
            catch (IllegalAccessException ie) {
                throw new BioError("Counld not instantiate auto-generated class-", ie);
            }
            catch (InvocationTargetException ie) {
                throw new BioError("Counld not instantiate auto-generated class using " + this.viterbi + " with " + this.dp + ", " + scoreType + ", " + terminal, ie);
            }
        }
    }
}

