/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bsi.genomics.exometablebrowser.server;

import edu.mayo.bsi.genomics.exometablebrowser.server.Usage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GetOpts {
    private char shortOption;
    private String longOption;
    private ArgType argument;
    private OptType required;
    private boolean wasDone;
    private String value;
    private List<String> values;
    private static List<GetOpts> theOpts = new ArrayList<GetOpts>();
    private static final char kOptChar = '-';
    private static final String kLongOpt = "--";
    public static final char kNoShortArg = '\u0000';
    public static final String kArgumentSeparator = "\n";

    private GetOpts(char shortOption, String longOption, ArgType argument, OptType required) {
        this.longOption = longOption;
        this.shortOption = shortOption;
        this.argument = argument;
        this.required = required;
        this.value = null;
        this.values = null;
    }

    private boolean isOpt(char theArg) {
        if (this.shortOption != theArg) {
            return false;
        }
        this.wasDone = true;
        return true;
    }

    private boolean isOpt(String theArg) {
        if (!this.longOption.equalsIgnoreCase(theArg)) {
            return false;
        }
        this.wasDone = true;
        return true;
    }

    private String report() {
        if (!this.wasDone) {
            return null;
        }
        if (this.values != null) {
            StringBuilder result = new StringBuilder();
            int numValues = this.values.size();
            result.append(this.values.get(0));
            for (int i = 1; i < numValues; ++i) {
                result.append(kArgumentSeparator);
                result.append(this.values.get(i));
            }
            return result.toString();
        }
        if (this.value != null) {
            return this.value;
        }
        return "";
    }

    public final void setValue(String value) {
        if (this.value == null && this.values == null) {
            this.value = value;
        } else if (this.argument == ArgType.kMultiRequiredArgument) {
            if (this.values == null) {
                this.values = new ArrayList<String>();
                this.values.add(this.value);
                this.value = null;
            }
            this.values.add(value);
        }
    }

    private final boolean isGood() {
        if (!this.wasDone) {
            return this.required != OptType.kRequiredParam;
        }
        if (this.value != null) {
            return true;
        }
        if (this.argument == ArgType.kMultiRequiredArgument) {
            return this.values != null;
        }
        return this.argument != ArgType.kRequiredArgument;
    }

    private final boolean isOnly() {
        if (!this.wasDone || this.required != OptType.kOnlyParam) {
            return false;
        }
        if (this.value != null) {
            return true;
        }
        if (this.argument == ArgType.kMultiRequiredArgument) {
            return this.values != null;
        }
        return this.argument != ArgType.kRequiredArgument;
    }

    private final boolean isIgnore() {
        return this.wasDone && this.required != OptType.kIgnoreParam;
    }

    private static final boolean hasIgnore() {
        if (theOpts == null) {
            return false;
        }
        for (GetOpts anOpt : theOpts) {
            if (anOpt.required != OptType.kIgnoreParam) continue;
            return true;
        }
        return false;
    }

    public static void addOption(char shortOption, String longOption, ArgType argument, OptType required) {
        theOpts.add(new GetOpts(shortOption, longOption, argument, required));
    }

    public static String[] parseArgs(String[] args, Usage target) {
        String[] results = null;
        GetOpts curOption = null;
        ArrayList<String> unused = new ArrayList<String>();
        boolean canIgnore = GetOpts.hasIgnore();
        boolean mustIgnore = false;
        boolean hasIgnore = false;
        for (String theArg : args) {
            if (theArg.startsWith(kLongOpt)) {
                if ((curOption = GetOpts.handleLongOption(theArg, curOption)) != null) continue;
                if (!canIgnore) {
                    GetOpts.reportBadOption(args, target);
                    return null;
                }
                unused.add(theArg);
                mustIgnore = true;
                continue;
            }
            if (!theArg.isEmpty() && theArg.charAt(0) == '-') {
                int numUnused = unused.size();
                if ((curOption = GetOpts.handleSingleCharOptions(theArg, curOption, unused)) != null || numUnused != unused.size()) continue;
                if (!canIgnore) {
                    GetOpts.reportBadOption(args, target);
                    return null;
                }
                unused.add(theArg);
                mustIgnore = true;
                continue;
            }
            if (curOption != null && curOption.argument != ArgType.kNoArgument) {
                curOption.setValue(theArg);
                curOption = null;
                continue;
            }
            unused.add(theArg);
        }
        for (GetOpts theOpt : theOpts) {
            if (theOpt.isOnly()) break;
            if (theOpt.isIgnore()) {
                hasIgnore = true;
            }
            if (theOpt.isGood()) continue;
            if (!canIgnore) {
                GetOpts.reportBadOption(args, target);
                return null;
            }
            mustIgnore = true;
        }
        if (mustIgnore && !hasIgnore) {
            GetOpts.reportBadOption(args, target);
            return null;
        }
        int pos = 0;
        results = new String[theOpts.size() + unused.size()];
        for (GetOpts theOpt : theOpts) {
            results[pos] = theOpt.report();
            ++pos;
        }
        Iterator<GetOpts> i$ = unused.iterator();
        while (i$.hasNext()) {
            String theArg;
            results[pos] = theArg = (String)((Object)i$.next());
            ++pos;
        }
        return results;
    }

    private static GetOpts handleSingleCharOptions(String theArg, GetOpts curOption, List<String> unused) {
        int optsLen = theArg.length();
        if (optsLen == 1) {
            if (curOption != null && curOption.argument != ArgType.kNoArgument) {
                curOption.setValue(theArg);
            } else {
                unused.add(theArg);
            }
            return curOption;
        }
        for (int i = 1; i < optsLen; ++i) {
            if (curOption != null && !curOption.isGood()) {
                return null;
            }
            curOption = null;
            char theChar = theArg.charAt(i);
            for (GetOpts theOpt : theOpts) {
                if (!theOpt.isOpt(theChar)) continue;
                curOption = theOpt;
                break;
            }
            if (curOption != null) continue;
            return null;
        }
        return curOption;
    }

    private static GetOpts handleLongOption(String theArg, GetOpts curOption) {
        if (curOption != null && !curOption.isGood()) {
            return null;
        }
        curOption = null;
        for (GetOpts theOpt : theOpts) {
            if (!theOpt.isOpt(theArg)) continue;
            curOption = theOpt;
            break;
        }
        return curOption;
    }

    private static void reportBadOption(String[] args, Usage target) {
        if (args.length > 0) {
            System.err.print("Error running " + target.name());
            for (String theArg : args) {
                System.err.print(" " + theArg);
            }
            System.err.println();
        }
        System.err.println(target.usage());
    }

    public static enum OptType {
        kOptionalParam,
        kRequiredParam,
        kOnlyParam,
        kIgnoreParam;

    }

    public static enum ArgType {
        kNoArgument,
        kOptionalArgument,
        kRequiredArgument,
        kMultiRequiredArgument;

    }
}

