/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util;

import edu.mayo.bior.util.BiorProperties;
import java.io.File;
import java.io.IOException;

public class DependancyUtil {
    public static boolean isToolInstalled(String toolPath) {
        if (toolPath == null) {
            return false;
        }
        File f = new File(toolPath);
        if (f == null) {
            return false;
        }
        if (!f.canExecute()) {
            return false;
        }
        return f.exists();
    }

    public static boolean isSNPEffInstalled() throws IOException {
        BiorProperties prop = new BiorProperties();
        String snpeffpath = prop.get("SnpEffJar");
        File snpefF = new File(snpeffpath);
        if (snpefF == null || !snpefF.exists()) {
            System.err.println("SNPEffect is not correctly installed and on your path! you need to install it and modify the bior.properties file to use this feature!");
            System.err.println("Current Path: " + snpeffpath);
            System.err.println("bior.properties: " + BiorProperties.getFile());
            return false;
        }
        String snpconfpath = prop.get("SnpEffConfig");
        File snpconf = new File(snpconfpath);
        if (snpconf == null || !snpconf.exists()) {
            System.err.println("SNPEffect config is not correctly installed and in the bior.properties file! You need to create a valid config file, please see the SNPEff documentation");
            System.err.println("Current Path: " + snpconfpath);
            System.err.println("bior.properties: " + BiorProperties.getFile());
            return false;
        }
        return true;
    }

    public static boolean isVEPInstalled() throws IOException {
        BiorProperties prop = new BiorProperties();
        String veperl = prop.get("BioRVepPerl");
        if (DependancyUtil.isToolInstalled(veperl)) {
            System.err.println("VEP needs perl 5.14.2 or greater, make sure it is installed and in the location specified in the bior.properties file");
            System.err.println("Current Path: " + veperl);
            System.err.println("bior.properties: " + BiorProperties.getFile());
            return false;
        }
        String vepcache = prop.get("BiorVepCache");
        File vepc = new File(vepcache);
        if (vepc == null || !vepc.exists() || !vepc.isDirectory()) {
            System.err.println("VEP needs the cache to be downloaded, please read the VEP documentation to download the cache and specify the cache directory correctly in the bior.properties file");
            System.err.println("Current Path: " + vepcache);
            System.err.println("bior.properties: " + BiorProperties.getFile());
            return false;
        }
        String vep = prop.get("BiorVep");
        File vepf = new File(vep);
        if (vepf == null || !vepf.exists()) {
            System.err.println("VEP needs to be installed and in the location specified in your bior.properties file");
            System.err.println("Current Path: " + vep);
            System.err.println("bior.properties: " + BiorProperties.getFile());
            return false;
        }
        return true;
    }
}

