/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.cli.InvalidDataException;
import edu.mayo.pipes.InputStreamPipe;
import edu.mayo.pipes.PrintPipe;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class UnixStreamPipeline {
    private static Logger sLogger = Logger.getLogger(UnixStreamPipeline.class);

    public void execute(Pipe<History, History> logic) throws InvalidDataException {
        HistoryInPipe historyIn = new HistoryInPipe();
        HistoryOutPipe historyOut = new HistoryOutPipe();
        this.execute((Pipe)historyIn, logic, (Pipe)historyOut);
    }

    public void execute(Pipe preLogic, Pipe logic, Pipe postLogic) throws InvalidDataException {
        InputStreamPipe in = new InputStreamPipe();
        PrintPipe print = new PrintPipe();
        Pipeline pipeline = new Pipeline(new Pipe[]{in, preLogic, logic, postLogic, print});
        pipeline.setStarts(Arrays.asList(System.in));
        int invalidDataErrorCnt = 0;
        boolean hasNext = true;
        while (hasNext) {
            try {
                pipeline.next();
            }
            catch (NoSuchElementException e) {
                hasNext = false;
            }
            catch (InvalidPipeInputException e) {
                ++invalidDataErrorCnt;
                sLogger.error((Object)e.getMessage());
            }
        }
        if (invalidDataErrorCnt > 0) {
            String mesg = String.format("WARNING: Found %s data error(s).  Not all input data rows could be successfully processed.", String.valueOf(invalidDataErrorCnt));
            throw new InvalidDataException(mesg);
        }
    }
}

