/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.bior.pipeline.Treat.AnnotateEXE;
import edu.mayo.bior.pipeline.Treat.EndLineGeneratorPipe;
import edu.mayo.bior.pipeline.Treat.JsonColumn;
import edu.mayo.bior.pipeline.Treat.format.BgiFormatter;
import edu.mayo.bior.pipeline.Treat.format.CosmicFormatter;
import edu.mayo.bior.pipeline.Treat.format.DbsnpClinvarFormatter;
import edu.mayo.bior.pipeline.Treat.format.DbsnpFormatter;
import edu.mayo.bior.pipeline.Treat.format.EspFormatter;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import edu.mayo.bior.pipeline.Treat.format.FormatterPipeFunction;
import edu.mayo.bior.pipeline.Treat.format.HapmapFormatter;
import edu.mayo.bior.pipeline.Treat.format.HgncFormatter;
import edu.mayo.bior.pipeline.Treat.format.MirBaseFormatter;
import edu.mayo.bior.pipeline.Treat.format.NcbiGeneFormatter;
import edu.mayo.bior.pipeline.Treat.format.OmimFormatter;
import edu.mayo.bior.pipeline.Treat.format.SNPEffFormatter;
import edu.mayo.bior.pipeline.Treat.format.ThousandGenomesFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscBlacklistedFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscConservationFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscEnhancerFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscRegulationFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscRepeatFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscTfbsFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscTssFormatter;
import edu.mayo.bior.pipeline.Treat.format.UcscUniqueFormatter;
import edu.mayo.bior.pipeline.Treat.format.VEPFormatter;
import edu.mayo.bior.pipeline.Treat.format.VEPHgncFormatter;
import edu.mayo.bior.util.BiorProperties;
import edu.mayo.bior.util.DependancyUtil;
import edu.mayo.exec.AbnormalExitException;
import edu.mayo.pipes.history.CompressPipe;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.FieldSpecification;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class TreatPipeline
extends Pipeline<History, History> {
    private BiorProperties mProps;
    private List<String> mConfigColumnsToOutput;
    private static Logger sLogger = Logger.getLogger(TreatPipeline.class);
    private String mBiorLiteHome = "";
    private String mBiorCmdDir = "";
    private List<Metadata> mMetadataToAdd = new ArrayList<Metadata>();
    private List<String> mCatalogForColumn = new ArrayList<String>();
    private String generatedCommand = "";

    public TreatPipeline() throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException, URISyntaxException {
        this(null);
    }

    public TreatPipeline(String configFilePath) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException, URISyntaxException {
        this.mProps = new BiorProperties();
        this.mConfigColumnsToOutput = this.loadConfig(configFilePath);
        this.validateConfigFileColumns(this.mConfigColumnsToOutput);
        this.initPipes();
    }

    public String getGeneratedCommand() {
        return this.generatedCommand;
    }

    private void initPipes() throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException, URISyntaxException {
        ArrayList<JsonColumn> order = new ArrayList<JsonColumn>();
        ArrayList<String> pipeList = new ArrayList<String>();
        this.setBiorLiteCmdDir();
        order.add(JsonColumn.VARIANT);
        pipeList.add(this.vcfToJson());
        if (this.isNeedPipe(new VEPFormatter())) {
            if (!DependancyUtil.isVEPInstalled()) {
                System.exit(1);
            }
            order.add(JsonColumn.VEP);
            pipeList.add(this.vep());
        }
        if (this.isNeedPipe(new VEPHgncFormatter())) {
            order.add(order.size() - 1, JsonColumn.IGNORE);
            pipeList.add(this.drill("Gene"));
            order.add(JsonColumn.VEP_HGNC);
            pipeList.add(this.lookup(BiorProperties.Key.hgncFile, BiorProperties.Key.hgncEnsemblGeneIndexFile, "Ensembl_Gene_ID"));
        }
        if (this.isNeedPipe(new SNPEffFormatter())) {
            if (!DependancyUtil.isSNPEffInstalled()) {
                System.exit(1);
            }
            order.add(JsonColumn.SNPEFF);
            pipeList.add(this.snpeff());
        }
        if (this.isNeedPipe(new DbsnpFormatter())) {
            order.add(JsonColumn.DBSNP_ALL);
            pipeList.add(this.sameVariant(BiorProperties.Key.dbsnpFile, order));
        }
        if (this.isNeedPipe(new DbsnpClinvarFormatter())) {
            order.add(JsonColumn.DBSNP_CLINVAR);
            pipeList.add(this.sameVariant(BiorProperties.Key.dbsnpClinvarFile, order));
        }
        if (this.isNeedPipe(new CosmicFormatter())) {
            order.add(JsonColumn.COSMIC);
            pipeList.add(this.sameVariant(BiorProperties.Key.cosmicFile, order));
        }
        if (this.isNeedPipe(new UcscBlacklistedFormatter())) {
            order.add(JsonColumn.UCSC_BLACKLISTED);
            pipeList.add(this.overlap(BiorProperties.Key.blacklistedFile, order));
        }
        if (this.isNeedPipe(new UcscConservationFormatter())) {
            order.add(JsonColumn.UCSC_CONSERVATION);
            pipeList.add(this.overlap(BiorProperties.Key.conservationFile, order));
        }
        if (this.isNeedPipe(new UcscEnhancerFormatter())) {
            order.add(JsonColumn.UCSC_ENHANCER);
            pipeList.add(this.overlap(BiorProperties.Key.enhancerFile, order));
        }
        if (this.isNeedPipe(new UcscTfbsFormatter())) {
            order.add(JsonColumn.UCSC_TFBS);
            pipeList.add(this.overlap(BiorProperties.Key.tfbsFile, order));
        }
        if (this.isNeedPipe(new UcscTssFormatter())) {
            order.add(JsonColumn.UCSC_TSS);
            pipeList.add(this.overlap(BiorProperties.Key.tssFile, order));
        }
        if (this.isNeedPipe(new UcscUniqueFormatter())) {
            order.add(JsonColumn.UCSC_UNIQUE);
            pipeList.add(this.overlap(BiorProperties.Key.uniqueFile, order));
        }
        if (this.isNeedPipe(new UcscRepeatFormatter())) {
            order.add(JsonColumn.UCSC_REPEAT);
            pipeList.add(this.overlap(BiorProperties.Key.repeatFile, order));
        }
        if (this.isNeedPipe(new UcscRegulationFormatter())) {
            order.add(JsonColumn.UCSC_REGULATION);
            pipeList.add(this.overlap(BiorProperties.Key.regulationFile, order));
        }
        if (this.isNeedPipe(new MirBaseFormatter())) {
            order.add(JsonColumn.MIRBASE);
            pipeList.add(this.overlap(BiorProperties.Key.mirBaseFile, order));
        }
        if (this.isNeedPipe(new BgiFormatter())) {
            order.add(JsonColumn.BGI);
            pipeList.add(this.sameVariant(BiorProperties.Key.bgiFile, order));
        }
        if (this.isNeedPipe(new EspFormatter())) {
            order.add(JsonColumn.ESP);
            pipeList.add(this.sameVariant(BiorProperties.Key.espFile, order));
        }
        if (this.isNeedPipe(new HapmapFormatter())) {
            order.add(JsonColumn.HAPMAP);
            pipeList.add(this.sameVariant(BiorProperties.Key.hapMapFile, order));
        }
        if (this.isNeedPipe(new ThousandGenomesFormatter())) {
            order.add(JsonColumn.THOUSAND_GENOMES);
            pipeList.add(this.sameVariant(BiorProperties.Key.kGenomeFile, order));
        }
        if (this.isNeedPipe(new NcbiGeneFormatter())) {
            order.add(JsonColumn.NCBI_GENE);
            pipeList.add(this.overlap(BiorProperties.Key.genesFile, order));
        }
        if (this.isNeedPipe(new HgncFormatter())) {
            order.add(order.size() - 1, JsonColumn.IGNORE);
            pipeList.add(this.drill("GeneID"));
            order.add(JsonColumn.HGNC);
            pipeList.add(this.lookup(BiorProperties.Key.hgncFile, BiorProperties.Key.hgncIndexFile, "Entrez_Gene_ID"));
        }
        if (this.isNeedPipe(new OmimFormatter())) {
            order.add(order.size() - 1, JsonColumn.IGNORE);
            pipeList.add(this.drill("mapped_OMIM_ID"));
            order.add(JsonColumn.OMIM);
            pipeList.add(this.lookup(BiorProperties.Key.omimFile, BiorProperties.Key.omimIndexFile, "MIM_Number"));
        }
        String pipesAsStr = this.pipeAsString(pipeList);
        sLogger.info((Object)("bior_annotate pipeline long cmd: " + pipesAsStr));
        this.generatedCommand = pipesAsStr;
        HashMap<String, String> envVars = new HashMap<String, String>();
        sLogger.info((Object)("BIOR_LITE_HOME: " + this.mBiorLiteHome));
        envVars.put("BIOR_LITE_HOME", this.mBiorLiteHome);
        FormatterPipeFunction formatterPipe = new FormatterPipeFunction(order, this.mConfigColumnsToOutput);
        this.mMetadataToAdd = formatterPipe.getMetadataForUserColumns(this.mCatalogForColumn);
        FieldSpecification fSpec = new FieldSpecification(formatterPipe.getColumnsAdded().size() + "-", FieldSpecification.FieldDirection.RIGHT_TO_LEFT);
        String DUMMY_LINE = "1\t1\trsXXXXXXXX\tA\tC\t.\t.\t.";
        this.setPipes(new Pipeline(new Pipe[]{new EndLineGeneratorPipe("1\t1\trsXXXXXXXX\tA\tC\t.\t.\t.", true), new TransformFunctionPipe((PipeFunction)new AnnotateEXE(new String[]{"/bin/sh", "-c", pipesAsStr}, envVars, "1\t1\trsXXXXXXXX\tA\tC\t.\t.\t.", this.getMaxLinesInFlight())), new TransformFunctionPipe((PipeFunction)formatterPipe), new CompressPipe(AnnotateCmds.bior_compress.toString(), fSpec, "|", "\\|", true)}).getPipes());
    }

    private int getMaxLinesInFlight() {
        String maxLinesStr = this.mProps.get(BiorProperties.Key.AnnotateMaxLinesInFlight);
        int maxLines = this.isInteger(maxLinesStr) ? Integer.parseInt(maxLinesStr) : 10;
        sLogger.info((Object)("AnnotateMaxLinesInFlight = " + maxLines));
        if (maxLines <= 1) {
            throw new IllegalArgumentException("AnnotateMaxLinesInFlight must be 2 or greater to prevent hangs!");
        }
        if (maxLines > 50) {
            sLogger.warn((Object)"WARNING: AnnotateMaxLinesInFlight is set to > 50.  This may cause a hang state as the process buffers can overflow and cause data loss, especially in the case of a high number of fanouts!");
        }
        return maxLines;
    }

    private boolean isInteger(String val) {
        try {
            Integer.parseInt(val);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String pipeAsString(List<String> pipeCmds) {
        StringBuilder bigPipe = new StringBuilder();
        for (int i = 0; i < pipeCmds.size(); ++i) {
            bigPipe.append(pipeCmds.get(i));
            if (i >= pipeCmds.size() - 1) continue;
            bigPipe.append(" | ");
        }
        return bigPipe.toString();
    }

    private String vcfToJson() {
        this.mCatalogForColumn.add(null);
        return this.mBiorCmdDir + (Object)((Object)AnnotateCmds.bior_vcf_to_tjson) + this.logFlag();
    }

    private String vep() throws URISyntaxException, IOException {
        this.mCatalogForColumn.add("/tools/vep");
        return this.mBiorCmdDir + (Object)((Object)AnnotateCmds.bior_vep) + this.logFlag();
    }

    private String snpeff() throws URISyntaxException, IOException {
        this.mCatalogForColumn.add("/tools/snpeff");
        return this.mBiorCmdDir + (Object)((Object)AnnotateCmds.bior_snpeff) + this.logFlag();
    }

    private String lookup(BiorProperties.Key catalogFile, BiorProperties.Key indexFile, String jsonKey) throws IOException {
        this.mCatalogForColumn.add(this.getFile(catalogFile));
        return this.mBiorCmdDir + (Object)((Object)AnnotateCmds.bior_lookup) + " -d " + this.getFile(catalogFile) + " -i " + this.getFile(indexFile) + " -p " + jsonKey + " -c -2" + this.logFlag();
    }

    private String sameVariant(BiorProperties.Key catalogFile, List<JsonColumn> order) throws IOException {
        this.mCatalogForColumn.add(this.getFile(catalogFile));
        return this.mBiorCmdDir + (Object)((Object)AnnotateCmds.bior_same_variant) + " -d " + this.getFile(catalogFile) + " -c " + (1 - order.size()) + this.logFlag();
    }

    private String overlap(BiorProperties.Key catalogFile, List<JsonColumn> order) throws IOException {
        this.mCatalogForColumn.add(this.getFile(catalogFile));
        return this.mBiorCmdDir + (Object)((Object)AnnotateCmds.bior_overlap) + " -d " + this.getFile(catalogFile) + " -c " + (1 - order.size()) + this.logFlag();
    }

    private String drill(String jsonPath) {
        this.mCatalogForColumn.add(this.mCatalogForColumn.size() - 1, null);
        return this.mBiorCmdDir + (Object)((Object)AnnotateCmds.bior_drill) + " -p " + jsonPath + " -k" + this.logFlag();
    }

    private String logFlag() {
        boolean isLogOn = sLogger.isDebugEnabled() || sLogger.isInfoEnabled();
        sLogger.info((Object)("If logging is on, then set it for all bior_annotate sub-commands.  Is logging on?  " + isLogOn));
        return isLogOn ? " -l" : "";
    }

    private String setBiorLiteCmdDir() throws IOException {
        this.mBiorLiteHome = System.getenv().get("BIOR_LITE_HOME");
        if (this.mBiorLiteHome == null || this.mBiorLiteHome.trim().length() == 0) {
            File targetFolder = new File("target");
            for (File f : targetFolder.listFiles()) {
                if (!f.isDirectory() || !f.getName().startsWith("bior_pipeline")) continue;
                this.mBiorLiteHome = f.getCanonicalPath();
                break;
            }
        }
        this.mBiorCmdDir = this.mBiorLiteHome + "/bin/";
        if (!new File(this.mBiorCmdDir).exists()) {
            throw new IOException("Could not find the directory containing the BioR commands!");
        }
        return this.mBiorCmdDir;
    }

    private boolean isNeedPipe(Formatter colFormatter) {
        if (colFormatter == null || this.mConfigColumnsToOutput == null) {
            return true;
        }
        for (String colFromPipe : colFormatter.getHeaders()) {
            if (!this.mConfigColumnsToOutput.contains(colFromPipe)) continue;
            return true;
        }
        if (colFormatter instanceof VEPFormatter && this.isNeedPipe(new VEPHgncFormatter())) {
            return true;
        }
        if (colFormatter instanceof NcbiGeneFormatter && this.isNeedPipe(new HgncFormatter())) {
            return true;
        }
        if (colFormatter instanceof NcbiGeneFormatter && this.isNeedPipe(new OmimFormatter())) {
            return true;
        }
        return colFormatter instanceof HgncFormatter && this.isNeedPipe(new OmimFormatter());
    }

    private String getFile(BiorProperties.Key propKey) {
        String path = this.mProps.get(BiorProperties.Key.fileBase) + this.mProps.get(propKey);
        return path;
    }

    private List<String> loadConfig(String configFilePath) throws IOException {
        if (configFilePath == null || configFilePath.length() == 0) {
            return null;
        }
        List configCols = Files.readLines((File)new File(configFilePath), (Charset)Charsets.UTF_8);
        for (int i = configCols.size() - 1; i >= 0; --i) {
            if (!((String)configCols.get(i)).startsWith("#") && ((String)configCols.get(i)).trim().length() != 0) continue;
            configCols.remove(i);
        }
        return configCols;
    }

    private void validateConfigFileColumns(List<String> configFileCols) {
        if (configFileCols == null) {
            return;
        }
        if (configFileCols.size() == 0) {
            String MSG = "Error: The config file does not contain any output columns.  Please add some columns to output.  Or, to add all columns, do not add the config file option.";
            throw new IllegalArgumentException("Error: The config file does not contain any output columns.  Please add some columns to output.  Or, to add all columns, do not add the config file option.");
        }
        List<String> allCols = FormatterPipeFunction.getAllPossibleColumns();
        StringBuffer errMsg = new StringBuffer();
        for (String configCol : configFileCols) {
            if (allCols.contains(configCol)) continue;
            errMsg.append("    " + configCol + "\n");
        }
        if (errMsg.length() > 0) {
            errMsg.insert(0, "Error: these columns specified in the config file are not recognized:\n");
            throw new IllegalArgumentException(errMsg.toString());
        }
    }

    public List<Metadata> getMetdata() {
        return this.mMetadataToAdd;
    }

    private static enum AnnotateCmds {
        bior_vcf_to_tjson,
        bior_vep,
        bior_snpeff,
        bior_lookup,
        bior_same_variant,
        bior_overlap,
        bior_drill,
        bior_compress;

    }
}

