/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import com.tinkerpop.pipes.Pipe;
import edu.mayo.bior.pipeline.Treat.TreatPipeline;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.bior.util.DependancyUtil;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.cli.InvalidDataException;
import edu.mayo.cli.InvalidOptionArgValueException;
import edu.mayo.exec.AbnormalExitException;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class AnnotateCommand
implements CommandPlugin {
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private static final Logger sLogger = Logger.getLogger(AnnotateCommand.class);
    private static final String OPTION_GENOME_VERSION = "genome_version";
    private static final char OPTION_CONFIG_FILE = 'c';

    public void init(Properties props) throws Exception {
    }

    public void execute(CommandLine line, Options opts) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException, InvalidOptionArgValueException, InvalidDataException {
        String configFilePath = null;
        if (line.hasOption('c')) {
            configFilePath = line.getOptionValue('c');
            if (!new File(configFilePath).exists() || new File(configFilePath).length() == 0L) {
                throw new InvalidOptionArgValueException(opts.getOption("c"), configFilePath, "The Config file path '" + configFilePath + "' does not exist (or is empty). Please specify a valid config file path.");
            }
            if (!DependancyUtil.isVEPInstalled()) {
                System.exit(1);
            }
            if (!DependancyUtil.isSNPEffInstalled()) {
                System.exit(1);
            }
        }
        try {
            TreatPipeline treatPipeline = new TreatPipeline(configFilePath);
            List<Metadata> treatMetadata = treatPipeline.getMetdata();
            this.mPipeline.execute((Pipe)new HistoryInPipe(treatMetadata), (Pipe)treatPipeline, (Pipe)new HistoryOutPipe());
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidOptionArgValueException(opts.getOption("c"), configFilePath, ex.getMessage());
        }
        catch (URISyntaxException e) {
            throw new IOException("Could not load properties file for catalog or tool: " + e.getMessage());
        }
    }

    private String[] getCommandLineOptions(CommandLine line) {
        ArrayList<String> cmdoptions = new ArrayList<String>();
        String genomeDatabase = line.hasOption(OPTION_GENOME_VERSION) ? line.getOptionValue(OPTION_GENOME_VERSION) : "GRCh37.64";
        sLogger.debug((Object)String.format("Using genome database version %s", genomeDatabase));
        cmdoptions.add(genomeDatabase);
        return cmdoptions.toArray(new String[cmdoptions.size()]);
    }
}

