/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.sage;

import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LoggerUtils {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final int UC_LENGTH = 4;

    private LoggerUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, Object> arrayToMap(Object[] data) {
        if (data.length % 2 == 1) {
            throw new IllegalArgumentException("Programmer error: the array of key-value pairs was of an odd length");
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(data.length / 2);
        int count = 0;
        String key = null;
        for (Object object : data) {
            if (count % 2 == 0) {
                if (!(object instanceof String)) throw new IllegalArgumentException("Programmer error: the key was not of type string for argument #" + (count + 1));
                key = (String)object;
            } else {
                map.put(key, object);
            }
            ++count;
        }
        return map;
    }

    public static byte[] mapToJsonByteArray(Map<String, Object> data) {
        StringBuilder sb = new StringBuilder();
        LoggerUtils.appendValue(sb, data);
        sb.append('\n');
        return sb.toString().getBytes(UTF_8);
    }

    private static void appendValue(StringBuilder sb, Object value) {
        if (value == null) {
            LoggerUtils.escape(sb, "null");
        } else if (value instanceof String) {
            LoggerUtils.appendString(sb, (String)value);
        } else if (value instanceof Number) {
            LoggerUtils.escape(sb, ((Number)value).toString());
        } else if (value instanceof Boolean) {
            LoggerUtils.escape(sb, ((Boolean)value).toString());
        } else if (value instanceof Date) {
            LoggerUtils.appendString(sb, LoggerUtils.dateToIso8601((Date)value));
        } else if (value instanceof Map) {
            LoggerUtils.appendMap(sb, (Map)value);
        } else if (value instanceof Iterable) {
            LoggerUtils.appendIterable(sb, (Iterable)value);
        } else {
            LoggerUtils.appendString(sb, value.toString());
        }
    }

    private static void appendString(StringBuilder sb, String value) {
        sb.append('\"');
        LoggerUtils.escape(sb, value);
        sb.append('\"');
    }

    private static void appendIterable(StringBuilder sb, Iterable value) {
        sb.append('[');
        boolean comma = false;
        for (Object item : value) {
            if (comma) {
                sb.append(',');
            }
            comma = true;
            LoggerUtils.appendValue(sb, item);
        }
        sb.append(']');
    }

    private static void appendMap(StringBuilder sb, Map<String, Object> value) {
        sb.append("{");
        boolean comma = false;
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            if (comma) {
                sb.append(',');
            }
            comma = true;
            LoggerUtils.appendString(sb, entry.getKey());
            sb.append(':');
            LoggerUtils.appendValue(sb, entry.getValue());
        }
        sb.append("}");
    }

    private static String dateToIso8601(Date value) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        simpleDateFormat.setTimeZone(UTC);
        return simpleDateFormat.format(value);
    }

    static void escape(StringBuilder sb, String s) {
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
    }

    public static String getUsername() {
        return System.getProperty("user.name");
    }

    public static long getHeapSize() {
        return Runtime.getRuntime().totalMemory();
    }

    public static int getProcessID() {
        int pid;
        try {
            pid = Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
        }
        catch (NumberFormatException e) {
            pid = -1;
        }
        return pid;
    }
}

