/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util.index;

import edu.mayo.pipes.JSON.lookup.lookupUtils.IndexUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class FindIndex {
    private Connection mDbConn;
    private boolean mIsKeyAnInteger = false;
    private boolean mIsKeyCaseSensitive = false;

    public FindIndex(Connection dbConn, boolean isKeyCaseSensitive) {
        this.mDbConn = dbConn;
        this.mIsKeyAnInteger = IndexUtils.isKeyAnInteger(dbConn);
        this.mIsKeyCaseSensitive = isKeyCaseSensitive;
    }

    public FindIndex(Connection dbConn) {
        this(dbConn, false);
    }

    public HashMap<String, List<Long>> find(List<String> idsToFind) throws SQLException {
        String SQL = "SELECT Key,FilePos FROM Indexer WHERE Key = ?";
        PreparedStatement stmt = this.mDbConn.prepareStatement("SELECT Key,FilePos FROM Indexer WHERE Key = ?");
        HashMap<String, List<Long>> key2posMap = new HashMap<String, List<Long>>();
        int count = 0;
        double start = System.currentTimeMillis();
        HashSet<String> idSet = new HashSet<String>(idsToFind);
        Iterator it = idSet.iterator();
        double end = System.currentTimeMillis();
        long maxMem = 0L;
        while (it.hasNext()) {
            String id = (String)it.next();
            ++count;
            List<Long> positions = key2posMap.get(id);
            if (positions == null) {
                positions = new ArrayList<Long>();
                key2posMap.put(id, positions);
            }
            if (this.mIsKeyAnInteger) {
                stmt.setLong(1, Long.valueOf(id));
            } else {
                stmt.setString(1, id);
            }
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                Long pos = rs.getLong("FilePos");
                Object key = rs.getObject("Key");
                if (!this.mIsKeyAnInteger && this.mIsKeyCaseSensitive && !id.equals((String)key)) continue;
                positions.add(pos);
            }
            rs.close();
        }
        stmt.close();
        return key2posMap;
    }

    public LinkedList<Long> find(String idToFind) throws SQLException {
        String SQL = "SELECT Key,FilePos FROM Indexer WHERE Key = ?";
        PreparedStatement stmt = this.mDbConn.prepareStatement("SELECT Key,FilePos FROM Indexer WHERE Key = ?");
        ResultSet rs = null;
        LinkedList<Long> positions = new LinkedList<Long>();
        try {
            if (this.mIsKeyAnInteger) {
                if (!IndexUtils.isInteger(idToFind)) {
                    LinkedList<Long> linkedList = positions;
                    return linkedList;
                }
                stmt.setLong(1, Long.valueOf(idToFind));
            } else {
                stmt.setString(1, idToFind);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                Long pos = rs.getLong("FilePos");
                Object key = rs.getObject("Key");
                if (!this.mIsKeyAnInteger && this.mIsKeyCaseSensitive && !idToFind.equals((String)key)) continue;
                positions.add(pos);
            }
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger((String)FindIndex.class.getName()).log((Priority)Level.DEBUG, (Object)"Invalid search ID. ID needs to be a number.", (Throwable)nfe);
        }
        catch (Exception ex) {
            throw new SQLException("Exception in FindIndex.find(idToFind). " + ex.getMessage());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return positions;
    }
}

