/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.SNPEff;

import ca.mcgill.mcb.pcingola.fileIterator.NeedlemanWunsch;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import com.tinkerpop.pipes.PipeFunction;
import edu.mayo.bior.util.BiorProperties;
import edu.mayo.exec.AbnormalExitException;
import edu.mayo.exec.UnixStreamCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class SNPEFFEXE
implements PipeFunction<String, String> {
    private static final Logger log = Logger.getLogger(SNPEFFEXE.class);
    private UnixStreamCommand snpeff;
    private static final long serialVersionUID = 4226374412681243433L;
    private String line;
    private int lineNum;
    private String chromosomeName;
    private String ref;
    private String[] alts;
    private Double quality;
    private String filterPass;
    private String infoStr = "";
    private HashMap<String, String> info;
    private String format;
    private ArrayList<VcfGenotype> vcfGenotypes = null;
    private SeqChange.ChangeType changeType;
    private String[] genotypeFields;
    private String genotypeFieldsStr;
    private Marker parent;
    protected Genome genome = new Genome();

    public SNPEFFEXE(String[] snpEffCmd) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException {
        Map NO_CUSTOM_ENV = Collections.emptyMap();
        this.snpeff = new UnixStreamCommand(SNPEFFEXE.getSnpEffCommand(snpEffCmd), NO_CUSTOM_ENV, true, false);
        this.snpeff.launch();
        this.snpeff.send("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO");
        this.snpeff.send("chr1\t1588717\trs009\tG\tA\t0.0\t.\t.");
        this.snpeff.receive();
        this.snpeff.receive();
        this.snpeff.receive();
        this.snpeff.receive();
        this.snpeff.receive();
    }

    public SNPEFFEXE() throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException {
        this(SNPEFFEXE.getSnpEffCommand(null));
    }

    public SNPEFFEXE(boolean silent) {
    }

    public static String[] getSnpEffCommand(String[] userCmd) throws IOException {
        BiorProperties biorProps = new BiorProperties();
        String[] command = new String[]{"java", "-Xmx4g", "-jar", biorProps.get(BiorProperties.Key.SnpEffJar), "eff", "-c", biorProps.get(BiorProperties.Key.SnpEffConfig), "-v", "-o", "vcf", "-noLog", "-noStats"};
        if (userCmd != null) {
            return SNPEFFEXE.concat(command, userCmd);
        }
        return command;
    }

    public static String[] concat(String[] A, String[] B) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(A));
        list.addAll(Arrays.asList(B));
        return list.toArray(new String[list.size()]);
    }

    public String compute(String a) {
        try {
            String error = this.canCreateSeqChange(a);
            if (error == null) {
                this.snpeff.send(a);
                String result = this.snpeff.receive();
                return result;
            }
            System.err.println("SnpEff could not process line: " + a);
            System.err.println("    " + error);
            log.warn((Object)("SnpEff could not process line: " + a));
            log.warn((Object)("    " + error));
            return a + "\t" + error;
        }
        catch (Exception ex) {
            this.terminate();
            log.error((Object)("SNPEff failed at line:" + a + "\n" + ex));
            throw new RuntimeException("SNPEff failed at line:" + a + "\n" + ex);
        }
    }

    public void terminate() {
        try {
            this.snpeff.terminate();
        }
        catch (Exception e) {
            log.error((Object)("Error terminating SNPEFFEXE pipe" + e));
        }
    }

    public Chromosome getChromosome(String chromoName) {
        return this.genome.getChromosome(chromoName);
    }

    private int parsepos(String posStr) {
        return Gpr.parseIntSafe((String)posStr) - 1;
    }

    public String canCreateSeqChange(String line) {
        String[] fields = line.split("\t", 10);
        if (fields.length >= 4) {
            this.chromosomeName = fields[0].trim();
            Chromosome chromo = this.getChromosome(this.chromosomeName);
            this.parent = chromo;
            int start = this.parsepos(fields[1]);
            this.ref = fields[3].toUpperCase();
            String altsStr = fields[4].toUpperCase();
            this.parseAlts(altsStr);
            String id = fields[2];
            int strand = 1;
            String qStr = fields[5];
            this.quality = !qStr.isEmpty() ? Double.valueOf(Gpr.parseDoubleSafe((String)qStr)) : null;
            this.filterPass = fields[6];
            if (fields.length > 7) {
                this.infoStr = fields[7];
                this.info = null;
            }
            int coverage = Gpr.parseIntSafe((String)this.getInfo("DP"));
            String error = null;
            for (String altN : this.alts) {
                error = this.canCreateSeqChange(chromo, start, this.ref, altN, strand, id, this.quality, coverage);
                if (error == null) continue;
                return error;
            }
            return error;
        }
        if (fields.length < 4) {
            return "Malformed VCF SNPEFFERR this line is too short to be valid VCF: " + line;
        }
        return null;
    }

    private String canCreateSeqChange(Chromosome chromo, int start, String reference, String alt, int strand, String id, double quality, int coverage) {
        if (alt.isEmpty()) {
            return null;
        }
        if ((alt = alt.toUpperCase()).startsWith("<DEL")) {
            int end = start + reference.length() - 1;
            if (this.getInfo("END") != null && (end = (int)this.getInfoInt("END")) < start) {
                return "SNPEFFERR=INFO field 'END' is before varaint's 'POS'\n\tEND : " + end + "\n\tPOS : " + start;
            }
            int size = end - start + 1;
            char[] change = new char[size];
            for (int i = 0; i < change.length; ++i) {
                change[i] = reference.length() > i ? (int)reference.charAt(i) : 78;
            }
            String ch = "-" + new String(change);
            return null;
        }
        if (reference.length() == alt.length()) {
            int startDiff = Integer.MAX_VALUE;
            String ch = "";
            String ref = "";
            for (int i = 0; i < reference.length(); ++i) {
                if (reference.charAt(i) == alt.charAt(i)) continue;
                ref = ref + reference.charAt(i);
                ch = ch + alt.charAt(i);
                startDiff = Math.min(startDiff, i);
            }
            return null;
        }
        if (reference.length() > alt.length()) {
            NeedlemanWunsch nw = new NeedlemanWunsch(alt, reference);
            nw.align();
            int startDiff = nw.getOffset();
            String ref = "*";
            String ch = nw.getAlignment();
            if (!ch.startsWith("-")) {
                return "SNPEFFERR=Deletion '" + ch + "' does not start with '-'. This should never happen!";
            }
            return null;
        }
        if (reference.length() < alt.length()) {
            NeedlemanWunsch nw = new NeedlemanWunsch(alt, reference);
            nw.align();
            int startDiff = nw.getOffset();
            String ch = nw.getAlignment();
            String ref = "*";
            if (!ch.startsWith("+")) {
                return "SNPEFFERR=Insertion '" + ch + "' does not start with '+'. This should never happen!";
            }
            return null;
        }
        return "SNPEFFERR=Unsupported VCF change type '" + reference + "' => '" + alt + "'\nVcfEntry: " + this.line;
    }

    public String getInfo(String key) {
        if (this.info == null) {
            this.parseInfo();
        }
        return this.info.get(key);
    }

    void parseInfo() {
        this.info = new HashMap();
        for (String inf : this.infoStr.split(";")) {
            String[] vp = inf.split("=");
            if (vp.length > 1) {
                this.info.put(vp[0], vp[1]);
                continue;
            }
            this.info.put(vp[0], "true");
        }
    }

    public long getInfoInt(String key) {
        if (this.info == null) {
            this.parseInfo();
        }
        return Gpr.parseLongSafe((String)this.info.get(key));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAlts(String altsStr) {
        if (altsStr.length() == 1) {
            if (altsStr.equals("A") || altsStr.equals("C") || altsStr.equals("G") || altsStr.equals("T") || altsStr.equals(".")) {
                this.alts = new String[]{altsStr};
            } else if ("N".equals(altsStr)) {
                this.alts = new String[]{"A", "C", "G", "T"};
            } else if ("B".equals(altsStr)) {
                this.alts = new String[]{"C", "G", "T"};
            } else if ("D".equals(altsStr)) {
                this.alts = new String[]{"A", "G", "T"};
            } else if ("H".equals(altsStr)) {
                this.alts = new String[]{"A", "C", "T"};
            } else if ("V".equals(altsStr)) {
                this.alts = new String[]{"A", "C", "G"};
            } else if ("M".equals(altsStr)) {
                this.alts = new String[]{"A", "C"};
            } else if ("R".equals(altsStr)) {
                this.alts = new String[]{"A", "G"};
            } else if ("W".equals(altsStr)) {
                this.alts = new String[]{"A", "T"};
            } else if ("S".equals(altsStr)) {
                this.alts = new String[]{"C", "G"};
            } else if ("Y".equals(altsStr)) {
                this.alts = new String[]{"C", "T"};
            } else if ("K".equals(altsStr)) {
                this.alts = new String[]{"G", "T"};
            } else {
                if (!".".equals(altsStr)) throw new RuntimeException("WARNING: Unknown IUB code for SNP '" + altsStr + "'");
                this.alts = new String[]{this.ref};
            }
        } else {
            this.alts = altsStr.split(",");
        }
        int maxAltLen = Integer.MIN_VALUE;
        int minAltLen = Integer.MAX_VALUE;
        for (int i = 0; i < this.alts.length; ++i) {
            maxAltLen = Math.max(maxAltLen, this.alts[i].length());
            minAltLen = Math.min(minAltLen, this.alts[i].length());
        }
        this.changeType = this.ref.length() == maxAltLen && this.ref.length() == minAltLen ? (this.ref.length() == 1 ? SeqChange.ChangeType.SNP : SeqChange.ChangeType.MNP) : (this.ref.length() > minAltLen ? SeqChange.ChangeType.DEL : (this.ref.length() < maxAltLen ? SeqChange.ChangeType.INS : SeqChange.ChangeType.MIXED));
    }
}

