/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import com.tinkerpop.pipes.Pipe;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.JSON.DrillPipe;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class DrillCommand
implements CommandPlugin {
    private static final char OPTION_KEEP_JSON = 'k';
    private static final char OPTION_PATH = 'p';
    private static final char OPTION_DRILL_COLUMN = 'c';
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        boolean keepJSON = false;
        if (line.hasOption('k')) {
            keepJSON = true;
        }
        ArrayList<String> paths = new ArrayList<String>();
        if (line.hasOption('p')) {
            for (String value : line.getOptionValues('p')) {
                paths.add(value);
            }
        }
        Integer col = -1;
        if (line.hasOption('c')) {
            col = new Integer(line.getOptionValue('c'));
        }
        String[] pathArr = paths.toArray(new String[0]);
        Metadata metadata = new Metadata(col.intValue(), this.operation, keepJSON, pathArr);
        HistoryInPipe preLogic = new HistoryInPipe(metadata);
        DrillPipe logic = new DrillPipe(keepJSON, pathArr, col.intValue());
        HistoryOutPipe postLogic = new HistoryOutPipe();
        this.mPipeline.execute((Pipe)preLogic, (Pipe)logic, (Pipe)postLogic);
    }
}

