/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.pipeline.createCatalogProps.ColumnMetaFromCatalogCrawling;
import edu.mayo.bior.pipeline.createCatalogProps.ColumnMetaFromVcf;
import edu.mayo.bior.util.ClasspathUtil;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.cli.InvalidDataException;
import edu.mayo.cli.InvalidOptionArgValueException;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.util.metadata.AddMetadataLines;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class CreateCatalogPropsCommand
implements CommandPlugin {
    public static final char OPTION_CATALOG = 'd';
    public static final char OPTION_ORIGINAL_VCF = 'v';
    public static final char OPTION_TARGET_DIR = 't';
    private List<AddMetadataLines.BiorMetaControlledVocabulary> biorMetaControlledVocabulary = Arrays.asList(AddMetadataLines.BiorMetaControlledVocabulary.values());
    private final String COLUMNS_EXTENSION = ".columns.tsv";
    private final String DATASOURCE_EXTENSION = ".datasource.properties";

    public void init(Properties props) throws Exception {
    }

    public void execute(CommandLine line, Options opts) throws InvalidOptionArgValueException, InvalidDataException, IOException {
        String catalogBgzipPath = line.getOptionValue('d');
        boolean isVcfSpecified = line.hasOption('v');
        String catalogOriginalVcfPath = line.getOptionValue('v');
        String targetDir = line.getOptionValue('t');
        try {
            this.execNoCmd(catalogBgzipPath, catalogOriginalVcfPath, targetDir, isVcfSpecified);
        }
        catch (IOException ioe) {
            throw new InvalidDataException("Error accessing one of the files: " + ioe.getMessage());
        }
        catch (URISyntaxException e) {
            throw new InvalidDataException("Could not find the columns defaults properties file: " + e.getMessage());
        }
    }

    public void execNoCmd(String catalogBgzipPath, String catalogOriginalVcfPath, String targetDirPath, boolean isVcfSpecified) throws InvalidOptionArgValueException, InvalidDataException, IOException, URISyntaxException {
        boolean isCrawlCatalog;
        File originalVcfFile;
        String catalogFullFilename;
        File targetDir;
        File catalogFile = new File(catalogBgzipPath);
        if (!catalogFile.exists()) {
            throw new IOException("Catalog file could not be found: " + catalogBgzipPath);
        }
        if (targetDirPath == null || targetDirPath.length() == 0) {
            targetDirPath = new File(catalogBgzipPath).getCanonicalFile().getParent();
        }
        if (!(targetDir = new File(targetDirPath).getCanonicalFile()).exists()) {
            throw new IOException("Target directory does not exist: " + targetDir);
        }
        if (!targetDir.isDirectory()) {
            throw new IOException("Target directory is not a directory: " + targetDir);
        }
        if (!targetDir.canWrite()) {
            throw new IOException("Target directory is not writable: " + targetDir);
        }
        String catalogFilenamePrefix = catalogFullFilename = catalogFile.getName();
        if (catalogFullFilename.endsWith(".tsv")) {
            catalogFilenamePrefix = catalogFullFilename.substring(0, catalogFullFilename.lastIndexOf(".tsv"));
        } else if (catalogFullFilename.endsWith(".tsv.bgz")) {
            catalogFilenamePrefix = catalogFullFilename.substring(0, catalogFullFilename.lastIndexOf(".tsv.bgz"));
        }
        File columnsPropsFile = new File(targetDir.getCanonicalPath() + File.separator + catalogFilenamePrefix + ".columns.tsv");
        File datasrcPropsFile = new File(targetDir.getCanonicalPath() + File.separator + catalogFilenamePrefix + ".datasource.properties");
        if (datasrcPropsFile.isDirectory()) {
            throw new IOException("Datasource properties file is an existing directory.  It should be a file");
        }
        if (columnsPropsFile.isDirectory()) {
            throw new IOException("Columns properties file is an existing directory.  It should be a file");
        }
        if (datasrcPropsFile.exists()) {
            throw new IOException("Datasource properties file already exists.  If you would like to recreate the properties files, first remove the existing ones, then recreate them.");
        }
        if (columnsPropsFile.exists()) {
            throw new IOException("Columns properties file already exists.  If you would like to recreate the properties files, first remove the existing ones, then recreate them.");
        }
        File file = originalVcfFile = isVcfSpecified ? new File(catalogOriginalVcfPath) : null;
        if (isVcfSpecified && (originalVcfFile == null || !originalVcfFile.exists())) {
            throw new IOException("Orginal VCF source file that the catalog was built from does not exist!: " + catalogOriginalVcfPath);
        }
        boolean bl = isCrawlCatalog = !isVcfSpecified;
        if (isCrawlCatalog) {
            long MB = 0x100000L;
            if (catalogFile.length() > 0xA00000L) {
                System.out.println("  WARNING: Catalog is large (" + catalogFile.length() / 0x100000L + "MB).  This may take a while to process)...");
            }
        }
        this.createDatasourcePropsFile(datasrcPropsFile);
        this.createColumnPropsFile(columnsPropsFile, catalogFile, originalVcfFile, isVcfSpecified);
        System.out.println("Datasource properties file created at: " + datasrcPropsFile.getCanonicalPath());
        System.out.println("Columns    properties file created at: " + columnsPropsFile.getCanonicalPath());
        System.out.println("Done.");
    }

    protected void createDatasourcePropsFile(File datasourcePropsFile) throws InvalidOptionArgValueException, InvalidDataException, IOException {
        datasourcePropsFile.createNewFile();
        List<String> dsAttribs = Arrays.asList(AddMetadataLines.BiorMetaControlledVocabulary.SHORTNAME.toString(), AddMetadataLines.BiorMetaControlledVocabulary.DESCRIPTION.toString(), AddMetadataLines.BiorMetaControlledVocabulary.SOURCE.toString(), AddMetadataLines.BiorMetaControlledVocabulary.VERSION.toString(), AddMetadataLines.BiorMetaControlledVocabulary.BUILD.toString());
        String catalogNamePrefix = datasourcePropsFile.getName().replace(".datasource.properties", "");
        StringBuilder content = new StringBuilder();
        content.append("### Datasource properties file for Catalog - " + catalogNamePrefix + ". Please fill in the descriptions to the keys below.\n");
        for (String key : dsAttribs) {
            content.append(key + "=\n");
        }
        this.writeToFile(datasourcePropsFile, content.toString());
    }

    protected void createColumnPropsFile(File columnPropsFile, File catalogFile, File originalVcfFile, boolean isVcfSpecified) throws InvalidOptionArgValueException, InvalidDataException, IOException, URISyntaxException {
        List<ColumnMetaData> colMetaList = this.mergeCrawlerWithVcf(catalogFile, originalVcfFile, isVcfSpecified);
        colMetaList = this.mergeWithDefaults(colMetaList);
        StringBuilder content = this.getColumnContents(columnPropsFile, colMetaList);
        columnPropsFile.createNewFile();
        this.writeToFile(columnPropsFile, content.toString());
    }

    private List<ColumnMetaData> mergeCrawlerWithVcf(File catalogFile, File originalVcfFile, boolean isVcfSpecified) throws IOException {
        List<ColumnMetaData> colMetaList = new ColumnMetaFromCatalogCrawling().getColumnMetadata(catalogFile.getCanonicalPath());
        if (isVcfSpecified && originalVcfFile != null && originalVcfFile.exists()) {
            List<ColumnMetaData> fromVcfColMetaList = new ColumnMetaFromVcf().getColumnMetadata(originalVcfFile.getCanonicalPath());
            for (ColumnMetaData colMetaVcf : fromVcfColMetaList) {
                for (int i = colMetaList.size() - 1; i >= 0; --i) {
                    if (!colMetaList.get((int)i).columnName.equals(colMetaVcf.columnName)) continue;
                    colMetaList.remove(i);
                }
                colMetaList.add(colMetaVcf);
            }
        }
        return colMetaList;
    }

    private List<ColumnMetaData> mergeWithDefaults(List<ColumnMetaData> colMetaList) throws URISyntaxException, IOException {
        File colDefaultsProps = ClasspathUtil.loadResource("/allCatalogs.columns.tsv");
        HashMap defaultsColNameToMetaMap = new AddMetadataLines().parseColumnProperties(colDefaultsProps.getCanonicalPath());
        for (int i = 0; i < colMetaList.size(); ++i) {
            String colName = colMetaList.get((int)i).columnName;
            if (!defaultsColNameToMetaMap.containsKey(colName)) continue;
            colMetaList.set(i, (ColumnMetaData)defaultsColNameToMetaMap.get(colName));
        }
        return colMetaList;
    }

    private StringBuilder getColumnContents(File columnPropsFile, List<ColumnMetaData> colMetaList) throws FileNotFoundException, URISyntaxException, IOException {
        String catalogNamePrefix = columnPropsFile.getName().replace(".columns.tsv", "");
        StringBuilder content = new StringBuilder();
        content.append("### Column properties file for Catalog - " + catalogNamePrefix + ". Please fill in and/or edit the descriptions to the keys below.\n");
        content.append("##-----------------------------------------------------\n");
        content.append("##ColumnName=The key or column name\n");
        content.append("##Type=The type of the object, as can be determined from parsing the VCF file or taking and educated guess based on the catalog values (Possible values: JSON, String, Integer, Float, Boolean)\n");
        content.append("##Count=The number of values that repeatedly occur  (Possible values: 0 (Boolean), 1 (JSON,Integer,Float,String), or '.' (JsonArrays - which will be resolved to other primitives such as String,Integer,Float)\n");
        content.append("##Description=The description of the ColumnName\n");
        content.append("##-----------------------------------------------------\n");
        content.append("#ColumnName\tType\tCount\tDescription\n");
        Collections.sort(colMetaList);
        for (ColumnMetaData colMeta : colMetaList) {
            content.append(colMeta.toString() + "\n");
        }
        return content;
    }

    private void writeToFile(File source, String content) throws IOException {
        FileWriter fw = new FileWriter(source.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(content);
        bw.close();
    }
}

