/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.stats.IntStats;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesIntStats
extends TestCase {
    public static double EPSILON = 1.0E-6;
    boolean verbose = false;
    Random rand;

    public TestCasesIntStats() {
        this.initRand();
    }

    void initRand() {
        this.rand = new Random(20110328L);
    }

    public void test_01() {
        String[] lines;
        String fileName = "tests/intStats_test_01.txt";
        String file = Gpr.readFile(fileName);
        for (String line : lines = file.split("\n")) {
            String[] recs = line.split("\t");
            int min = (int)Gpr.parseDoubleSafe(recs[0]);
            int max = (int)Gpr.parseDoubleSafe(recs[1]);
            double mean = Gpr.parseDoubleSafe(recs[2]);
            double median = Gpr.parseDoubleSafe(recs[3]);
            double std = Gpr.parseDoubleSafe(recs[4]);
            IntStats intStats = new IntStats();
            for (int i = 5; i < recs.length; ++i) {
                int value = Gpr.parseIntSafe(recs[i]);
                intStats.sample(value);
            }
            Assert.assertEquals((int)min, (int)intStats.getMin());
            Assert.assertEquals((int)max, (int)intStats.getMax());
            Assert.assertEquals((double)mean, (double)intStats.getMean(), (double)EPSILON);
            Assert.assertEquals((double)median, (double)intStats.getMedian(), (double)EPSILON);
            Assert.assertEquals((double)std, (double)intStats.getStd(), (double)EPSILON);
        }
    }
}

