/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.FileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FastaFileIterator
extends FileIterator<String> {
    Pattern transcriptPattern = Pattern.compile("transcript:(\\S*)");
    String header = null;
    String nextHeader = null;

    public FastaFileIterator(String fastaFileName) {
        super(fastaFileName);
    }

    public String getHeader() {
        return this.header;
    }

    public String getName() {
        if (this.header == null) {
            return "";
        }
        String name = this.header.split("\\s+")[0];
        return Chromosome.simpleName(name);
    }

    public String getTranscriptId() {
        Matcher mmatcher = this.transcriptPattern.matcher(this.getHeader());
        if (mmatcher.find()) {
            return mmatcher.group(1);
        }
        return this.getName();
    }

    void header(String line) {
        this.header = this.header == null ? line.substring(1).trim() : this.nextHeader;
        this.nextHeader = line.substring(1).trim();
    }

    @Override
    protected String readNext() {
        StringBuffer sb = new StringBuffer();
        try {
            State state = State.DESCRIPTION;
            while (this.ready()) {
                if (this.line == null) {
                    this.line = this.readLine();
                }
                if (debug) {
                    Gpr.debug("State:" + (Object)((Object)state) + "\tLine " + this.lineNum + ": " + this.line);
                }
                switch (state) {
                    case DESCRIPTION: {
                        if (this.line.startsWith(">")) {
                            state = State.SEQUENCE;
                        }
                        this.header(this.line);
                        break;
                    }
                    case SEQUENCE: {
                        if (this.line.startsWith(">")) {
                            state = State.COMPLETE;
                            this.header(this.line);
                        } else {
                            sb.append(this.line.trim());
                        }
                        state = State.COMPLETE;
                        break;
                    }
                    case COMPLETE: {
                        if (this.line.startsWith(">")) {
                            this.header(this.line);
                            state = State.COMPLETE;
                            return sb.toString();
                        }
                        sb.append(this.line.trim());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unkown state '" + (Object)((Object)state) + "'");
                    }
                }
                this.line = null;
            }
            if (state == State.COMPLETE) {
                return sb.toString();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private static enum State {
        DESCRIPTION,
        SEQUENCE,
        COMPLETE;

    }
}

