/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.booter.StartupReportConfiguration;
import org.apache.maven.surefire.report.AbstractConsoleReporter;
import org.apache.maven.surefire.report.AbstractFileReporter;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.DefaultDirectConsoleReporter;
import org.apache.maven.surefire.report.MulticastingReporter;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.report.TestSetRunListener;
import org.apache.maven.surefire.report.XMLReporter;
import org.apache.maven.surefire.suite.RunResult;

public class FileReporterFactory
implements ReporterFactory {
    private final ReporterConfiguration reporterConfiguration;
    private final RunStatistics globalStats = new RunStatistics();
    private final MulticastingReporter multicastingReporter;
    private final StartupReportConfiguration reportConfiguration;

    public FileReporterFactory(StartupReportConfiguration reportConfiguration) {
        this.reportConfiguration = reportConfiguration;
        this.reporterConfiguration = this.getReporterConfiguration();
        this.multicastingReporter = new MulticastingReporter(this.instantiateReports());
        this.runStarting();
    }

    private ReporterConfiguration getReporterConfiguration() {
        return new ReporterConfiguration(this.reportConfiguration.getReportsDirectory(), new Boolean(this.reportConfiguration.isTrimStackTrace()));
    }

    public RunListener createReporter() {
        return new TestSetRunListener(this.instantiateConsoleReporter(), this.instantiateFileReporter(), this.instantiateXmlReporter(), this.instantiateConsoleOutputFileReporter(), this.globalStats);
    }

    private AbstractConsoleReporter instantiateConsoleReporter() {
        return this.reportConfiguration.instantiateConsoleReporter();
    }

    private AbstractFileReporter instantiateFileReporter() {
        return this.reportConfiguration.instantiateFileReporter();
    }

    private XMLReporter instantiateXmlReporter() {
        return this.reportConfiguration.instantiateXmlReporter();
    }

    private Reporter instantiateConsoleOutputFileReporter() {
        return this.reportConfiguration.instantiateConsoleOutputFileReporterName(this.reporterConfiguration.getOriginalSystemOut());
    }

    private List instantiateReports() {
        ArrayList result = new ArrayList();
        this.addIfNotNull(result, this.instantiateConsoleReporter());
        this.addIfNotNull(result, this.instantiateFileReporter());
        this.addIfNotNull(result, this.instantiateXmlReporter());
        this.addIfNotNull(result, this.instantiateConsoleOutputFileReporter());
        return result;
    }

    private void addIfNotNull(List result, Reporter reporter) {
        if (reporter != null) {
            result.add(reporter);
        }
    }

    public RunResult close() {
        this.runCompleted();
        return this.globalStats.getRunResult();
    }

    private ConsoleLogger createConsoleLogger() {
        return new DefaultDirectConsoleReporter(this.reporterConfiguration.getOriginalSystemOut());
    }

    public void runStarting() {
        ConsoleLogger consoleReporter = this.createConsoleLogger();
        consoleReporter.info("");
        consoleReporter.info("-------------------------------------------------------");
        consoleReporter.info(" T E S T S");
        consoleReporter.info("-------------------------------------------------------");
    }

    private void runCompleted() {
        Iterator iterator;
        ConsoleLogger logger = this.createConsoleLogger();
        logger.info("");
        logger.info("Results :");
        logger.info("");
        if (this.globalStats.hadFailures()) {
            this.multicastingReporter.writeMessage("Failed tests: ");
            iterator = this.globalStats.getFailureSources().iterator();
            while (iterator.hasNext()) {
                logger.info("  " + iterator.next());
            }
            logger.info("");
        }
        if (this.globalStats.hadErrors()) {
            logger.info("Tests in error: ");
            iterator = this.globalStats.getErrorSources().iterator();
            while (iterator.hasNext()) {
                logger.info("  " + iterator.next());
            }
            logger.info("");
        }
        logger.info(this.globalStats.getSummary());
        logger.info("");
    }

    public RunStatistics getGlobalRunStatistics() {
        return this.globalStats;
    }
}

