/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.analysis.Stat;

public class ImmunoChemistry {
    protected static double molecularWeightIgG1 = 146000.0;
    protected static double molecularWeightIgG2 = 146000.0;
    protected static double molecularWeightIgG3 = 170000.0;
    protected static double molecularWeightIgG4 = 146000.0;
    protected static double molecularWeightIgM = 970000.0;
    protected static double molecularWeightIgA1 = 160000.0;
    protected static double molecularWeightIgA2 = 160000.0;
    protected static double molecularWeightIgD = 184000.0;
    protected static double molecularWeightIgE = 188000.0;

    public static double diffusionCoefficient(double effectiveRadius, double viscosity, double temperature) {
        double tempK = temperature - -273.15;
        double fTerm = Math.PI * 6 * viscosity * effectiveRadius;
        return 1.380650324E-23 * tempK / fTerm;
    }

    public static double diffusionCoefficient(double molecularWeight, double specificVolume, double viscosity, double temperature) {
        double tempK = temperature - -273.15;
        double molecularVolume = molecularWeight * specificVolume / 6.0221419947E26;
        double molecularRadius = Math.pow(3.0 * molecularVolume / (Math.PI * 4), 0.3333333333333333);
        double fTerm = Math.PI * 6 * viscosity * molecularRadius;
        return 1.380650324E-23 * tempK / fTerm;
    }

    public static double oneDimensionalDiffusion(double diffusionCoefficient, double ZeroDistanceConcentration, double distance, double time) {
        double arg = distance / (2.0 * Math.sqrt(diffusionCoefficient * time));
        return ZeroDistanceConcentration * Stat.erfc(arg);
    }

    public static double diffusionControlledRate(double diffCoeffA, double diffCoeffB, double radiusA, double radiusB, double fractA, double fractB) {
        return 7.567646819769641E24 * fractA * fractB * (diffCoeffA + diffCoeffB) * (radiusA + radiusB) * 0.001;
    }

    public static double molecularRadius(double molWt, double specVol) {
        double molecularMass = molWt / 6.0221419947E23;
        double molecularVolume = molecularMass * 0.001 * specVol;
        return Math.pow(molecularVolume * 3.0 / (Math.PI * 4), 0.3333333333333333);
    }

    public static double molecularRadius(double molWt) {
        return ImmunoChemistry.molecularRadius(molWt, 7.4E-4);
    }

    public static double effectiveRadius(double diffusionCoefficient, double viscosity, double temperature) {
        double tempK = temperature - -273.15;
        double dTerm = Math.PI * 6 * viscosity * diffusionCoefficient;
        return 1.380650324E-23 * tempK / dTerm;
    }

    public static double surfaceNumberConcn(double effectiveRadius) {
        double molecularArea = 2.0 * effectiveRadius * Math.sqrt(3.0);
        double numberPerSquareMetre = 1.0 / molecularArea;
        return numberPerSquareMetre;
    }

    public static double surfaceNumberConcn(double molWt, double specVol) {
        double molecularMass = molWt / 6.0221419947E23;
        double molecularVolume = molecularMass * 0.001 * specVol;
        double molecularRadius = Math.pow(molecularVolume * 3.0 / (Math.PI * 4), 0.3333333333333333);
        double molecularArea = 2.0 * molecularRadius * Math.sqrt(3.0);
        double numberPerSquareMetre = 1.0 / molecularArea;
        return numberPerSquareMetre;
    }

    public static double surfaceMolarConcn(double effectiveRadius) {
        double surfaceNumberConcn = ImmunoChemistry.surfaceNumberConcn(effectiveRadius);
        return surfaceNumberConcn / 6.0221419947E23;
    }

    public static double surfaceMolarConcn(double molWt, double specVol) {
        double surfaceNumberConcn = ImmunoChemistry.surfaceNumberConcn(molWt, specVol);
        return surfaceNumberConcn / 6.0221419947E23;
    }

    public static double convertSurfaceToVolumeConcn(double surfaceConcn, double area, double volume) {
        return surfaceConcn * area * 0.001 / volume;
    }

    public static double equivalentVolumeConcn(double effectiveRadius, double area, double volume) {
        double surfaceMolarConcn = ImmunoChemistry.surfaceMolarConcn(effectiveRadius);
        return surfaceMolarConcn * area * 0.001 / volume;
    }

    public static double equivalentVolumeConcn(double molWt, double area, double volume, double specVol) {
        double surfaceMolarConcn = ImmunoChemistry.surfaceMolarConcn(molWt, specVol);
        return surfaceMolarConcn * area * 0.001 / volume;
    }

    public static double getMolWeightIgG1() {
        return molecularWeightIgG1;
    }

    public static double getMolWeightIgG2() {
        return molecularWeightIgG2;
    }

    public static double getMolWeightIgG3() {
        return molecularWeightIgG3;
    }

    public static double getMolWeightIgG4() {
        return molecularWeightIgG4;
    }

    public static double getMolWeightIgM() {
        return molecularWeightIgM;
    }

    public static double getMolWeightIgA1() {
        return molecularWeightIgA1;
    }

    public static double getMolWeightIgA2() {
        return molecularWeightIgA2;
    }

    public static double getMolWeightIgD() {
        return molecularWeightIgD;
    }

    public static double getMolWeightIgE() {
        return molecularWeightIgE;
    }
}

