/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexMatrix;
import flanagan.complex.ComplexPoly;
import flanagan.interpolation.CubicSpline;
import flanagan.io.Db;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;
import flanagan.plot.PlotPoleZero;

public class BlackBox {
    protected int sampLen = 0;
    protected double[] inputT = null;
    protected double[] outputT = null;
    protected double[] time = null;
    protected double forgetFactor = 1.0;
    protected double deltaT = 0.0;
    protected double sampFreq = 0.0;
    protected Complex inputS = new Complex();
    protected Complex outputS = new Complex();
    protected Complex sValue = new Complex();
    protected Complex zValue = new Complex();
    protected ComplexPoly sNumer = new ComplexPoly(1.0);
    protected ComplexPoly sDenom = new ComplexPoly(1.0);
    protected ComplexPoly zNumer = new ComplexPoly(1.0);
    protected ComplexPoly zDenom = new ComplexPoly(1.0);
    protected boolean sNumerSet = false;
    protected boolean sDenomSet = false;
    protected Complex sNumerScaleFactor = Complex.plusOne();
    protected Complex sDenomScaleFactor = Complex.plusOne();
    protected Complex sNumerWorkingFactor = Complex.plusOne();
    protected Complex sDenomWorkingFactor = Complex.plusOne();
    protected Complex[] sPoles = null;
    protected Complex[] sZeros = null;
    protected Complex[] zPoles = null;
    protected Complex[] zZeros = null;
    protected int sNumerDeg = 0;
    protected int sDenomDeg = 0;
    protected int zNumerDeg = 0;
    protected int zDenomDeg = 0;
    protected double deadTime = 0.0;
    protected int orderPade = 2;
    protected ComplexPoly sNumerPade = new ComplexPoly(1.0);
    protected ComplexPoly sDenomPade = new ComplexPoly(1.0);
    protected Complex[] sPolesPade = null;
    protected Complex[] sZerosPade = null;
    protected int sNumerDegPade = 0;
    protected int sDenomDegPade = 0;
    protected boolean maptozero = true;
    protected boolean padeAdded = false;
    protected double integrationSum = 0.0;
    protected int integMethod = 1;
    protected int ztransMethod = 0;
    protected String name = "BlackBox";
    protected String fixedName = "BlackBox";
    protected int nPlotPoints = 400;
    protected String[] subclassName = new String[]{"BlackBox", "OpenLoop", "ClosedLoop", "Prop", "PropDeriv", "PropInt", "PropIntDeriv", "FirstOrder", "SecondOrder", "Compensator", "LowPassPassive", "HighPassPassive", "Transducer", "DelayLine", "ZeroOrderHold", "AtoD", "DtoA"};
    protected int nSubclasses = this.subclassName.length;
    protected int subclassIndex = 0;

    public BlackBox() {
    }

    public BlackBox(String name) {
        this.name = name;
        this.fixedName = name;
        this.setSubclassIndex();
    }

    protected void setSubclassIndex() {
        boolean test = true;
        int i = 0;
        while (test) {
            if (this.fixedName.equals(this.subclassName[i])) {
                this.subclassIndex = i;
                test = false;
                continue;
            }
            if (++i < this.nSubclasses) continue;
            System.out.println("Subclass name, " + this.fixedName + ", not recognised as a recorder subclass");
            System.out.println("Subclass, " + this.fixedName + ", handled as BlackBox");
            this.subclassIndex = i;
            test = false;
        }
    }

    public void setSnumer(double[] coeff) {
        this.sNumerDeg = coeff.length - 1;
        this.sNumer = new ComplexPoly(coeff);
        this.sNumerSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    protected void addDeadTimeExtras() {
        this.sNumerDegPade = this.sNumerDeg;
        this.sNumerPade = this.sNumer.copy();
        this.sDenomDegPade = this.sDenomDeg;
        this.sDenomPade = this.sDenom.copy();
        if (this.deadTime == 0.0) {
            this.transferPolesZeros();
        } else {
            this.pade();
        }
    }

    public void setSnumer(Complex[] coeff) {
        this.sNumerDeg = coeff.length - 1;
        this.sNumer = new ComplexPoly(coeff);
        this.sNumerSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public void setSnumer(ComplexPoly coeff) {
        this.sNumerDeg = coeff.getDeg();
        this.sNumer = ComplexPoly.copy(coeff);
        this.sNumerSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public void setSdenom(double[] coeff) {
        this.sDenomDeg = coeff.length - 1;
        this.sDenom = new ComplexPoly(coeff);
        this.sDenomSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public void setSdenom(Complex[] coeff) {
        this.sDenomDeg = coeff.length - 1;
        this.sDenom = new ComplexPoly(coeff);
        this.sDenomSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public void setSdenom(ComplexPoly coeff) {
        this.sDenomDeg = coeff.getDeg();
        this.sDenom = coeff.copy();
        this.sDenomSet = true;
        this.calcPolesZerosS();
        this.addDeadTimeExtras();
    }

    public static Complex scaleFactor(ComplexPoly poly, Complex[] roots) {
        int nRoots = roots.length;
        Complex mean = new Complex(0.0, 0.0);
        for (int i = 0; i < nRoots; ++i) {
            mean = mean.plus(roots[i]);
        }
        mean = mean.over(nRoots);
        boolean test = true;
        int ii = 0;
        while (test) {
            if (mean.isEqual(roots[ii])) {
                if (mean.isEqual(Complex.zero())) {
                    for (int i = 0; i < nRoots; ++i) {
                        mean = mean.plus(roots[i].abs());
                    }
                    if (mean.isEqual(Complex.zero())) {
                        mean = Complex.plusOne();
                    }
                } else {
                    mean = mean.times(1.5);
                }
                ii = 0;
                continue;
            }
            if (++ii <= nRoots - 1) continue;
            test = false;
        }
        Complex product = new Complex(1.0, 0.0);
        for (int i = 0; i < nRoots; ++i) {
            product = product.times(mean.minus(roots[i]));
        }
        Complex eval = poly.evaluate(mean);
        return eval.over(product);
    }

    public Complex getSnumerScaleFactor() {
        if (this.sNumerScaleFactor == null) {
            this.calcPolesZerosS();
        }
        return this.sNumerScaleFactor;
    }

    public Complex getSdenomScaleFactor() {
        if (this.sDenomScaleFactor == null) {
            this.calcPolesZerosS();
        }
        return this.sDenomScaleFactor;
    }

    public void setDeadTime(double deadtime) {
        this.deadTime = deadtime;
        this.pade();
    }

    public void setDeadTime(double deadtime, int orderPade) {
        this.deadTime = deadtime;
        if (orderPade > 5) {
            orderPade = 4;
            System.out.println("BlackBox does not support Pade approximations above an order of 4");
            System.out.println("The order has been set to 4");
        }
        if (orderPade < 1) {
            orderPade = 1;
            System.out.println("Pade approximation order was less than 1");
            System.out.println("The order has been set to 1");
        }
        this.orderPade = orderPade;
        this.pade();
    }

    public void setPadeOrder(int orderPade) {
        if (orderPade > 5) {
            orderPade = 4;
            System.out.println("BlackBox does not support Pade approximations above an order of 4");
            System.out.println("The order has been set to 4");
        }
        if (orderPade < 1) {
            orderPade = 2;
            System.out.println("Pade approximation order was less than 1");
            System.out.println("The order has been set to 2");
        }
        this.orderPade = orderPade;
        this.pade();
    }

    public double getDeadTime() {
        return this.deadTime;
    }

    public int getPadeOrder() {
        return this.orderPade;
    }

    protected void pade() {
        ComplexPoly sNumerExtra = null;
        ComplexPoly sDenomExtra = null;
        Complex[] newZeros = null;
        Complex[] newPoles = null;
        switch (this.orderPade) {
            case 1: {
                this.sNumerDegPade = this.sNumerDeg + 1;
                this.sDenomDegPade = this.sDenomDeg + 1;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                sNumerExtra = new ComplexPoly(1.0, -this.deadTime / 2.0);
                sDenomExtra = new ComplexPoly(1.0, this.deadTime / 2.0);
                this.sNumerPade = this.sNumer.times(sNumerExtra);
                this.sDenomPade = this.sDenom.times(sDenomExtra);
                newZeros = Complex.oneDarray(1);
                newZeros[0].reset(2.0 / this.deadTime, 0.0);
                newPoles = Complex.oneDarray(1);
                newPoles[0].reset(-2.0 / this.deadTime, 0.0);
                break;
            }
            case 2: {
                this.sNumerDegPade = this.sNumerDeg + 2;
                this.sDenomDegPade = this.sDenomDeg + 2;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                sNumerExtra = new ComplexPoly(1.0, -this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 12.0);
                sDenomExtra = new ComplexPoly(1.0, this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 12.0);
                this.sNumerPade = this.sNumer.times(sNumerExtra);
                this.sDenomPade = this.sDenom.times(sDenomExtra);
                newZeros = sNumerExtra.rootsNoMessages();
                newPoles = sDenomExtra.rootsNoMessages();
                break;
            }
            case 3: {
                this.sNumerDegPade = this.sNumerDeg + 3;
                this.sDenomDegPade = this.sDenomDeg + 3;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                double[] termn3 = new double[]{1.0, -this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 10.0, -Math.pow(this.deadTime, 3.0) / 120.0};
                sNumerExtra = new ComplexPoly(termn3);
                this.sNumerPade = this.sNumer.times(sNumerExtra);
                newZeros = sNumerExtra.rootsNoMessages();
                double[] termd3 = new double[]{1.0, this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 10.0, Math.pow(this.deadTime, 3.0) / 120.0};
                sDenomExtra = new ComplexPoly(termd3);
                this.sDenomPade = this.sDenom.times(sDenomExtra);
                newPoles = sDenomExtra.rootsNoMessages();
                break;
            }
            case 4: {
                this.sNumerDegPade = this.sNumerDeg + 4;
                this.sDenomDegPade = this.sDenomDeg + 4;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                double[] termn4 = new double[]{1.0, -this.deadTime / 2.0, 3.0 * Math.pow(this.deadTime, 2.0) / 28.0, -Math.pow(this.deadTime, 3.0) / 84.0, Math.pow(this.deadTime, 4.0) / 1680.0};
                sNumerExtra = new ComplexPoly(termn4);
                this.sNumerPade = this.sNumer.times(sNumerExtra);
                newZeros = sNumerExtra.rootsNoMessages();
                double[] termd4 = new double[]{1.0, this.deadTime / 2.0, 3.0 * Math.pow(this.deadTime, 2.0) / 28.0, Math.pow(this.deadTime, 3.0) / 84.0, Math.pow(this.deadTime, 4.0) / 1680.0};
                sDenomExtra = new ComplexPoly(termd4);
                this.sDenomPade = this.sDenom.times(sDenomExtra);
                newPoles = sDenomExtra.rootsNoMessages();
                break;
            }
            default: {
                this.orderPade = 2;
                this.sNumerDegPade = this.sNumerDeg + 2;
                this.sDenomDegPade = this.sDenomDeg + 2;
                this.sNumerPade = new ComplexPoly(this.sNumerDegPade);
                this.sDenomPade = new ComplexPoly(this.sDenomDegPade);
                sNumerExtra = new ComplexPoly(1.0, -this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 12.0);
                sDenomExtra = new ComplexPoly(1.0, this.deadTime / 2.0, Math.pow(this.deadTime, 2.0) / 12.0);
                this.sNumerPade = this.sNumer.times(sNumerExtra);
                this.sDenomPade = this.sDenom.times(sDenomExtra);
                newZeros = sNumerExtra.rootsNoMessages();
                newPoles = sDenomExtra.rootsNoMessages();
            }
        }
        if (this.sNumerPade != null && this.sNumerDegPade > 0) {
            int i;
            this.sZerosPade = Complex.oneDarray(this.sNumerDegPade);
            for (i = 0; i < this.sNumerDeg; ++i) {
                this.sZerosPade[i] = this.sZeros[i].copy();
            }
            for (i = 0; i < this.orderPade; ++i) {
                this.sZerosPade[i + this.sNumerDeg] = newZeros[i].copy();
            }
        }
        if (this.sDenomPade != null && this.sDenomDegPade > 0) {
            int i;
            this.sPolesPade = Complex.oneDarray(this.sDenomDegPade);
            for (i = 0; i < this.sDenomDeg; ++i) {
                this.sPolesPade[i] = this.sPoles[i].copy();
            }
            for (i = 0; i < this.orderPade; ++i) {
                this.sPolesPade[i + this.sDenomDeg] = newPoles[i].copy();
            }
        }
        this.zeroPoleCancellation();
        this.padeAdded = true;
    }

    protected void transferPolesZeros() {
        int i;
        this.sNumerDegPade = this.sNumerDeg;
        this.sNumerPade = this.sNumer.copy();
        if (this.sNumerDeg > 0 && this.sZeros != null) {
            this.sZerosPade = Complex.oneDarray(this.sNumerDeg);
            for (i = 0; i < this.sNumerDeg; ++i) {
                this.sZerosPade[i] = this.sZeros[i].copy();
            }
        }
        this.sDenomDegPade = this.sDenomDeg;
        this.sDenomPade = this.sDenom.copy();
        if (this.sDenomDeg > 0 && this.sPoles != null) {
            this.sPolesPade = Complex.oneDarray(this.sDenomDeg);
            for (i = 0; i < this.sDenomDeg; ++i) {
                this.sPolesPade[i] = this.sPoles[i].copy();
            }
        }
        this.zeroPoleCancellation();
        this.padeAdded = true;
    }

    public int orderPade() {
        return this.orderPade;
    }

    protected boolean deadTimeWarning(String method) {
        boolean warning = false;
        if (this.deadTime > this.deltaT) {
            System.out.println(this.name + "." + method + ": The dead time is greater than the sampling period");
            System.out.println("Dead time:       " + this.deadTime);
            System.out.println("Sampling period: " + this.deltaT);
            System.out.println("!!! The results of this program may not be physically meaningful !!!");
            warning = true;
        }
        return warning;
    }

    public void zTransform(double deltat) {
        this.mapstozAdHoc(deltat);
    }

    public void zTransform() {
        this.mapstozAdHoc();
    }

    public void mapstozAdHoc(double deltaT) {
        this.deltaT = deltaT;
        this.mapstozAdHoc();
    }

    public void mapstozAdHoc() {
        int infZeros;
        this.deadTimeWarning("mapstozAdHoc");
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.zDenomDeg = this.sDenomDegPade;
        ComplexPoly root = new ComplexPoly(1);
        this.zDenom = new ComplexPoly(this.zDenomDeg);
        if (this.zDenomDeg > 0) {
            this.zPoles = Complex.oneDarray(this.zDenomDeg);
            for (int i = 0; i < this.zDenomDeg; ++i) {
                this.zPoles[i] = Complex.exp(this.sPolesPade[i].times(this.deltaT));
            }
            this.zDenom = ComplexPoly.rootsToPoly(this.zPoles);
        }
        if ((infZeros = this.sDenomDegPade) + this.sNumerDegPade > this.sDenomDegPade) {
            infZeros = this.sDenomDegPade - this.sNumerDegPade;
        }
        this.zNumerDeg = this.sNumerDegPade + infZeros;
        this.zNumer = new ComplexPoly(this.zNumerDeg);
        this.zZeros = Complex.oneDarray(this.zNumerDeg);
        if (this.zNumerDeg > 0) {
            int i;
            for (i = 0; i < this.sNumerDegPade; ++i) {
                this.zZeros[i] = Complex.exp(this.sZerosPade[i].times(this.deltaT));
            }
            if (infZeros > 0) {
                if (this.maptozero) {
                    for (i = this.sNumerDegPade; i < this.zNumerDeg; ++i) {
                        this.zZeros[i] = Complex.zero();
                    }
                } else {
                    for (i = this.sNumerDegPade; i < this.zNumerDeg; ++i) {
                        this.zZeros[i] = Complex.minusOne();
                    }
                }
            }
            this.zNumer = ComplexPoly.rootsToPoly(this.zZeros);
        }
        this.sValue = Complex.zero();
        this.zValue = Complex.plusOne();
        boolean testzeros = true;
        while (testzeros) {
            int i;
            testzeros = false;
            if (this.sDenomDegPade > 0) {
                for (i = 0; i < this.sDenomDegPade; ++i) {
                    if (!this.sPolesPade[i].truncate(3).equals(this.sValue.truncate(3))) continue;
                    testzeros = true;
                }
            }
            if (!testzeros && this.sNumerDegPade > 0) {
                for (i = 0; i < this.sDenomDegPade; ++i) {
                    if (!this.sZerosPade[i].truncate(3).equals(this.sValue.truncate(3))) continue;
                    testzeros = true;
                }
            }
            if (!testzeros && this.zDenomDeg > 0) {
                for (i = 0; i < this.zDenomDeg; ++i) {
                    if (!this.zPoles[i].truncate(3).equals(this.zValue.truncate(3))) continue;
                    testzeros = true;
                }
            }
            if (!testzeros && this.zNumerDeg > 0) {
                for (i = 0; i < this.zDenomDeg; ++i) {
                    if (!this.zZeros[i].truncate(3).equals(this.zValue.truncate(3))) continue;
                    testzeros = true;
                }
            }
            if (!testzeros) continue;
            this.sValue = this.sValue.plus(Complex.plusJay()).truncate(3);
            this.zValue = Complex.exp(this.sValue.times(this.deltaT).truncate(3));
        }
        Complex gs = this.evalTransFunctS(this.sValue);
        Complex gz = this.evalTransFunctZ(this.zValue);
        Complex constant = gs.over(gz);
        ComplexPoly constantPoly = new ComplexPoly(constant);
        this.zNumer = this.zNumer.times(constantPoly);
    }

    public void setMaptozero(boolean maptozero) {
        this.maptozero = maptozero;
    }

    public void setZnumer(double[] coeff) {
        this.zNumerDeg = coeff.length - 1;
        this.zNumer = new ComplexPoly(coeff);
        this.zZeros = this.zNumer.rootsNoMessages();
    }

    public void setZnumer(Complex[] coeff) {
        this.zNumerDeg = coeff.length - 1;
        this.zNumer = new ComplexPoly(coeff);
        this.zZeros = this.zNumer.rootsNoMessages();
    }

    public void setZnumer(ComplexPoly coeff) {
        this.zNumerDeg = coeff.getDeg();
        this.zNumer = ComplexPoly.copy(coeff);
        this.zZeros = this.zNumer.rootsNoMessages();
    }

    public void setZdenom(double[] coeff) {
        this.zDenomDeg = coeff.length - 1;
        this.zDenom = new ComplexPoly(coeff);
        this.zPoles = this.zDenom.rootsNoMessages();
    }

    public void setZdenom(Complex[] coeff) {
        this.zDenomDeg = coeff.length - 1;
        this.zDenom = new ComplexPoly(coeff);
        this.zPoles = this.zDenom.rootsNoMessages();
    }

    public void setZdenom(ComplexPoly coeff) {
        this.zDenomDeg = coeff.getDeg();
        this.zDenom = ComplexPoly.copy(coeff);
        this.zPoles = this.zDenom.rootsNoMessages();
    }

    public void setDeltaT(double deltaT) {
        if (this.deltaT == 0.0) {
            this.deltaT = deltaT;
            this.sampFreq = 1.0 / this.deltaT;
            this.deadTimeWarning("setDeltaT");
        } else {
            String question = "BlackBox setDeltaT: Do you wish to replace the deltaT value, " + this.deltaT + " with " + deltaT;
            if (Db.yesNo(question)) {
                this.deltaT = deltaT;
                this.sampFreq = 1.0 / this.deltaT;
                this.deadTimeWarning("setDeltaT");
                if (this.time != null) {
                    int holdS = this.sampLen;
                    this.sampLen = (int)Math.round(this.time[this.sampLen - 1] / this.deltaT);
                    double[] holdT = Conv.copy(this.time);
                    double[] holdI = Conv.copy(this.inputT);
                    this.time = new double[this.sampLen];
                    this.inputT = new double[this.sampLen];
                    CubicSpline cs = new CubicSpline(holdT, holdI);
                    this.time[0] = holdT[0];
                    this.inputT[0] = holdI[0];
                    for (int i = 1; i < this.sampLen - 1; ++i) {
                        double d = this.deltaT;
                        this.time[i - 1] = d;
                        this.time[i] = d;
                        this.inputT[i] = cs.interpolate(this.time[i]);
                    }
                    this.time[this.sampLen - 1] = holdT[holdS];
                    this.inputT[this.sampLen - 1] = holdI[holdS];
                }
            }
        }
    }

    public void setForgetFactor(double forget) {
        this.forgetFactor = forget;
    }

    public void setSampFreq(double sfreq) {
        this.sampFreq = sfreq;
        this.setDeltaT(1.0 / sfreq);
    }

    public void setS(Complex s) {
        this.sValue = Complex.copy(s);
    }

    public void setS(double sr, double si) {
        this.sValue.reset(sr, si);
    }

    public void setS(double si) {
        this.sValue.reset(0.0, si);
    }

    public void setZ(Complex z) {
        this.zValue = Complex.copy(z);
    }

    public void setZ(double zr, double zi) {
        this.zValue.reset(zr, zi);
    }

    public void setZtransformMethod(int ztransMethod) {
        if (ztransMethod < 0 || ztransMethod > 1) {
            System.out.println("z transform method option number " + ztransMethod + " not recognised");
            System.out.println("z tr methodansform option number set in BlackBox to the default value of 0 (s -> z ad hoc mapping)");
            this.integMethod = 0;
        } else {
            this.ztransMethod = ztransMethod;
        }
    }

    public void setIntegrateOption(int integMethod) {
        if (integMethod < 0 || integMethod > 2) {
            System.out.println("integration method option number " + integMethod + " not recognised");
            System.out.println("integration method option number set in BlackBox to the default value of 0 (trapezium rule)");
            this.integMethod = 0;
        } else {
            this.integMethod = integMethod;
        }
    }

    public void setIntegrateOption(String integMethodS) {
        if (integMethodS.equals("trapezium") || integMethodS.equals("Trapezium") || integMethodS.equals("tutin") || integMethodS.equals("Tutin")) {
            this.integMethod = 0;
        } else if (integMethodS.equals("backward") || integMethodS.equals("Backward") || integMethodS.equals("back") || integMethodS.equals("Back")) {
            this.integMethod = 1;
        } else if (integMethodS.equals("foreward") || integMethodS.equals("Foreward") || integMethodS.equals("fore") || integMethodS.equals("Fore")) {
            this.integMethod = 2;
        } else {
            System.out.println("integration method option  " + integMethodS + " not recognised");
            System.out.println("integration method option number set in PID to the default value of 0 (trapezium rule)");
            this.integMethod = 0;
        }
    }

    public void setSampleLength(int samplen) {
        if (samplen == 0) {
            throw new IllegalArgumentException("Entered sample length must be greater than zero");
        }
        if (samplen == 1) {
            samplen = 2;
        }
        if (this.sampLen == 0) {
            this.sampLen = samplen;
            this.time = new double[samplen];
            this.inputT = new double[samplen];
            this.outputT = new double[samplen];
        } else {
            String question = "BlackBox setSampleLength: Do you wish to replace the sample length, " + this.sampLen + " with " + samplen;
            if (Db.yesNo(question)) {
                int holdS = this.sampLen;
                this.sampLen = samplen;
                if (this.time != null) {
                    this.deltaT = this.time[holdS - 1] / (double)(samplen - 1);
                    double[] holdT = Conv.copy(this.time);
                    double[] holdI = Conv.copy(this.inputT);
                    this.time = new double[this.sampLen];
                    this.inputT = new double[this.sampLen];
                    CubicSpline cs = new CubicSpline(holdT, holdI);
                    this.time[0] = holdT[0];
                    this.inputT[0] = holdI[0];
                    for (int i = 1; i < this.sampLen - 1; ++i) {
                        double d = this.deltaT;
                        this.time[i - 1] = d;
                        this.time[i] = d;
                        this.inputT[i] = cs.interpolate(this.time[i]);
                    }
                    this.time[this.sampLen - 1] = holdT[holdS];
                    this.inputT[this.sampLen - 1] = holdI[holdS];
                }
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInputT(double ttime, double inputt) {
        if (this.deltaT == 0.0) {
            this.time = new double[2];
            this.time[0] = 0.0;
            this.time[1] = ttime;
            this.inputT = new double[2];
            this.inputT[0] = inputt;
            this.inputT[1] = inputt;
            this.outputT = new double[2];
            this.sampLen = 2;
        } else {
            double delta = this.deltaT;
            this.sampLen = (int)Math.round(ttime / delta);
            this.deltaT = ttime / (double)this.sampLen;
            if (!Fmath.isEqualWithinLimits(this.deltaT, delta, delta * 0.001)) {
                System.out.println("BlackBox setInputT method; deltaT has been reset from " + delta + " to " + this.deltaT);
            }
            this.sampFreq = 1.0 / this.deltaT;
            this.time = new double[this.sampLen];
            this.time[this.sampLen - 1] = ttime;
            this.inputT = new double[this.sampLen];
            this.inputT[this.sampLen - 1] = inputt;
            this.outputT = new double[this.sampLen];
            for (int i = this.sampLen - 2; i > 0; --i) {
                this.time[i] = this.time[i + 1] - this.deltaT;
                this.inputT[i] = inputt;
            }
            this.time[0] = 0.0;
            this.inputT[0] = inputt;
        }
    }

    public void setInputT(double[] ttime, double[] inputt) {
        int samplen = ttime.length;
        if (samplen != inputt.length) {
            throw new IllegalArgumentException("time and input arrays are of different lengths: " + samplen + ", " + inputt.length);
        }
        if (samplen == 1) {
            this.setInputT(ttime[0], inputt[0]);
        } else {
            this.sampLen = samplen;
            this.time = ttime;
            this.inputT = inputt;
            this.outputT = new double[this.sampLen];
            this.deltaT = ttime[this.sampLen] / (double)(this.sampLen - 1);
            this.sampFreq = 1.0 / this.deltaT;
        }
    }

    public void setInputS(Complex input) {
        this.inputS = input;
    }

    public void resetZero() {
        for (int i = 0; i < this.sampLen - 1; ++i) {
            this.outputT[i] = 0.0;
            this.inputT[i] = 0.0;
            this.time[i] = 0.0;
        }
        this.outputS = Complex.zero();
        this.inputS = Complex.zero();
        this.deltaT = 0.0;
        this.sampLen = 0;
    }

    protected void calcPolesZerosS() {
        if (this.sNumer != null) {
            if (this.sNumer.getDeg() > 0) {
                this.sZeros = this.sNumer.rootsNoMessages();
            }
            this.sNumerScaleFactor = this.sZeros != null ? BlackBox.scaleFactor(this.sNumer, this.sZeros) : this.sNumer.coeffCopy(0);
        }
        if (this.sDenom != null) {
            if (this.sDenom.getDeg() > 0) {
                this.sPoles = this.sDenom.rootsNoMessages();
            }
            this.sDenomScaleFactor = this.sPoles != null ? BlackBox.scaleFactor(this.sDenom, this.sPoles) : this.sDenom.coeffCopy(0);
        }
        if (this.sNumerPade != null && this.sNumerPade.getDeg() > 0) {
            this.sZerosPade = this.sNumerPade.rootsNoMessages();
        }
        if (this.sDenomPade != null && this.sDenomPade.getDeg() > 0) {
            this.sPolesPade = this.sDenomPade.rootsNoMessages();
        }
    }

    protected void zeroPoleCancellation() {
        int ii;
        boolean check = false;
        boolean testI = true;
        boolean testJ = true;
        int i = 0;
        int j = 0;
        if (this.sNumerDegPade == 0 || this.sDenomDegPade == 0) {
            testI = false;
        }
        if (this.sZerosPade == null || this.sPolesPade == null) {
            testI = false;
        }
        while (testI) {
            j = 0;
            while (testJ) {
                if (this.sZerosPade[i].isEqual(this.sPolesPade[j])) {
                    int k;
                    for (k = j + 1; k < this.sDenomDegPade; ++k) {
                        this.sPolesPade[k - 1] = this.sPolesPade[k].copy();
                    }
                    --this.sDenomDegPade;
                    for (k = i + 1; k < this.sNumerDegPade; ++k) {
                        this.sZerosPade[k - 1] = this.sZerosPade[k].copy();
                    }
                    --this.sNumerDegPade;
                    check = true;
                    testJ = false;
                    --i;
                    continue;
                }
                if (++j <= this.sDenomDegPade - 1) continue;
                testJ = false;
            }
            if (++i <= this.sNumerDegPade - 1) continue;
            testI = false;
        }
        if (check) {
            if (this.sNumerDegPade == 0) {
                this.sNumerPade = new ComplexPoly(1.0);
            } else {
                Complex[] holdn = Complex.oneDarray(this.sNumerDegPade);
                for (ii = 0; ii < this.sNumerDegPade; ++ii) {
                    holdn[i] = this.sZerosPade[ii].copy();
                }
                this.sZerosPade = holdn;
                this.sNumerPade = ComplexPoly.rootsToPoly(this.sZerosPade);
            }
            if (this.sDenomDegPade == 0) {
                this.sDenomPade = new ComplexPoly(1.0);
            } else {
                Complex[] holdd = Complex.oneDarray(this.sDenomDegPade);
                for (ii = 0; ii < this.sDenomDegPade; ++ii) {
                    holdd[i] = this.sPolesPade[ii].copy();
                }
                this.sPolesPade = holdd;
                this.sDenomPade = ComplexPoly.rootsToPoly(this.sPolesPade);
            }
        }
        check = false;
        testI = true;
        testJ = true;
        i = 0;
        j = 0;
        if (this.sNumerDeg == 0 || this.sDenomDeg == 0) {
            testI = false;
        }
        if (this.sZeros == null || this.sPoles == null) {
            testI = false;
        }
        while (testI) {
            j = 0;
            while (testJ) {
                if (this.sZeros[i].isEqual(this.sPoles[j])) {
                    int k;
                    for (k = j + 1; k < this.sDenomDeg; ++k) {
                        this.sPoles[k - 1] = this.sPoles[k].copy();
                    }
                    --this.sDenomDeg;
                    for (k = i + 1; k < this.sNumerDeg; ++k) {
                        this.sZeros[k - 1] = this.sZeros[k].copy();
                    }
                    --this.sNumerDeg;
                    check = true;
                    testJ = false;
                    --i;
                    continue;
                }
                if (++j <= this.sDenomDeg - 1) continue;
                testJ = false;
            }
            if (++i <= this.sNumerDeg - 1) continue;
            testI = false;
        }
        if (check) {
            if (this.sNumerDeg == 0) {
                this.sNumer = new ComplexPoly(1.0);
            } else {
                Complex[] holdn = Complex.oneDarray(this.sNumerDeg);
                for (ii = 0; ii < this.sNumerDeg; ++ii) {
                    holdn[i] = this.sZeros[ii].copy();
                }
                this.sZeros = holdn;
                this.sNumer = ComplexPoly.rootsToPoly(this.sZeros);
                this.sNumerWorkingFactor = this.sNumerScaleFactor;
            }
            if (this.sDenomDeg == 0) {
                this.sDenom = new ComplexPoly(1.0);
            } else {
                Complex[] holdd = Complex.oneDarray(this.sDenomDeg);
                for (ii = 0; ii < this.sDenomDeg; ++ii) {
                    holdd[i] = this.sPoles[ii].copy();
                }
                this.sPoles = holdd;
                this.sDenom = ComplexPoly.rootsToPoly(this.sPoles);
                this.sDenomWorkingFactor = this.sDenomScaleFactor;
            }
        }
    }

    public double getSeadyStateValue() {
        Complex num = this.sNumer.evaluate(Complex.zero());
        Complex den = this.sDenom.evaluate(Complex.zero());
        Complex ssc = num.over(den);
        double ssdr = ssc.getReal();
        double ssdi = ssc.getImag();
        if (Math.abs(ssdi) > Math.abs(ssdr) * 0.01) {
            System.out.println("method getSteadyStateValue: The imaginary part, " + ssdi + ", is greater than 1 per cent of the the real part, " + ssdr);
            System.out.println("Magnitude has  been returned");
        }
        return ssc.abs();
    }

    public double getSeadyStateValue(double mag) {
        Complex num = this.sNumer.evaluate(Complex.zero());
        Complex den = this.sDenom.evaluate(Complex.zero());
        Complex ssc = num.over(den);
        double ssdr = ssc.getReal();
        double ssdi = ssc.getImag();
        if (Math.abs(ssdi) > Math.abs(ssdr) * 0.01) {
            System.out.println("method getSteadyStateValue: The imaginary part, " + ssdi + ", is greater than 1 per cent of the the real part, " + ssdr);
            System.out.println("Magnitude has  been returned");
        }
        return mag * ssc.abs();
    }

    public Complex evalTransFunctS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm);
    }

    public Complex evalTransFunctS(Complex sValue) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue = Complex.copy(sValue);
        Complex num = this.sNumer.evaluate(sValue);
        Complex den = this.sDenom.evaluate(sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm);
    }

    public Complex evalTransFunctS(double freq) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue.reset(0.0, Math.PI * 2 * freq);
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm);
    }

    public double evalMagTransFunctS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm).abs();
    }

    public double evalMagTransFunctS(Complex sValue) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue = Complex.copy(sValue);
        Complex num = this.sNumer.evaluate(sValue);
        Complex den = this.sDenom.evaluate(sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm).abs();
    }

    public double evalMagTransFunctS(double freq) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue.reset(0.0, Math.PI * 2 * freq);
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm).abs();
    }

    public double evalPhaseTransFunctS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm).arg();
    }

    public double evalPhaseTransFunctS(Complex sValue) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue = Complex.copy(sValue);
        Complex num = this.sNumer.evaluate(sValue);
        Complex den = this.sDenom.evaluate(sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm).arg();
    }

    public double evalPhaseTransFunctS(double freq) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.sValue.reset(0.0, Math.PI * 2 * freq);
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        Complex lagterm = Complex.plusOne();
        if (this.deadTime != 0.0) {
            lagterm = Complex.exp(this.sValue.times(-this.deadTime));
        }
        return num.over(den).times(lagterm).arg();
    }

    public Complex evalTransFunctZ() {
        Complex num = this.zNumer.evaluate(this.zValue);
        Complex den = this.zDenom.evaluate(this.zValue);
        return num.over(den);
    }

    public Complex evalTransFunctZ(Complex zValue) {
        this.zValue = Complex.copy(zValue);
        Complex num = this.zNumer.evaluate(zValue);
        Complex den = this.zDenom.evaluate(zValue);
        return num.over(den);
    }

    public double evalMagTransFunctZ() {
        Complex num = this.zNumer.evaluate(this.zValue);
        Complex den = this.zDenom.evaluate(this.zValue);
        return num.over(den).abs();
    }

    public double evalMagTransFunctZ(Complex zValue) {
        this.zValue = Complex.copy(zValue);
        Complex num = this.zNumer.evaluate(zValue);
        Complex den = this.zDenom.evaluate(zValue);
        return num.over(den).abs();
    }

    public double evalPhaseTransFunctZ() {
        Complex num = this.zNumer.evaluate(this.zValue);
        Complex den = this.zDenom.evaluate(this.zValue);
        return num.over(den).arg();
    }

    public double evalPhaseTransFunctZ(Complex zValue) {
        this.zValue = Complex.copy(zValue);
        Complex num = this.zNumer.evaluate(zValue);
        Complex den = this.zDenom.evaluate(zValue);
        return num.over(den).arg();
    }

    public int getIntegMethod() {
        return this.integMethod;
    }

    public int getZtransformMethod() {
        return this.ztransMethod;
    }

    public int getSampleLength() {
        return this.sampLen;
    }

    public double getForgetFactor() {
        return this.forgetFactor;
    }

    public double getCurrentTime() {
        return this.time[this.sampLen - 1];
    }

    public double[] getTime() {
        return this.time;
    }

    public double getCurrentInputT() {
        return this.inputT[this.sampLen - 1];
    }

    public double[] getInputT() {
        return this.inputT;
    }

    public Complex getInputS() {
        return this.inputS;
    }

    public double getDeltaT() {
        return this.deltaT;
    }

    public double getSampFreq() {
        return this.sampFreq;
    }

    public Complex getS() {
        return this.sValue;
    }

    public Complex getZ() {
        return this.zValue;
    }

    public int getSnumerDeg() {
        return this.sNumerDeg;
    }

    public int getSnumerPadeDeg() {
        return this.sNumerDegPade;
    }

    public int getSdenomDeg() {
        return this.sDenomDeg;
    }

    public int getSdenomPadeDeg() {
        return this.sDenomDegPade;
    }

    public ComplexPoly getSnumer() {
        return this.sNumer.times(this.sNumerWorkingFactor);
    }

    public ComplexPoly getSnumerPade() {
        return this.sNumerPade.times(this.sNumerWorkingFactor);
    }

    public ComplexPoly getSdenom() {
        return this.sDenom.times(this.sDenomWorkingFactor);
    }

    public ComplexPoly getSdenomPade() {
        return this.sDenomPade.times(this.sDenomWorkingFactor);
    }

    public int getZnumerDeg() {
        return this.zNumerDeg;
    }

    public int getZdenomDeg() {
        return this.zDenomDeg;
    }

    public ComplexPoly getZnumer() {
        return this.zNumer;
    }

    public ComplexPoly getZdenom() {
        return this.zDenom;
    }

    public Complex[] getZerosS() {
        if (this.sZeros == null) {
            this.calcPolesZerosS();
        }
        if (this.sZeros == null) {
            System.out.println("Method BlackBox.getZerosS:");
            System.out.println("There are either no s-domain zeros for this transfer function");
            System.out.println("or the s-domain numerator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.sZeros;
    }

    public Complex[] getZerosPadeS() {
        if (this.sZeros == null) {
            this.calcPolesZerosS();
        }
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        if (this.sZerosPade == null) {
            System.out.println("Method BlackBox.getZerosPadeS:");
            System.out.println("There are either no s-domain zeros for this transfer function");
            System.out.println("or the s-domain numerator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.sZerosPade;
    }

    public Complex[] getPolesS() {
        if (this.sPoles == null) {
            this.calcPolesZerosS();
        }
        if (this.sPoles == null) {
            System.out.println("Method BlackBox.getPolesS:");
            System.out.println("There are either no s-domain poles for this transfer function");
            System.out.println("or the s-domain denominator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.sPoles;
    }

    public Complex[] getPolesPadeS() {
        if (this.sPoles == null) {
            this.calcPolesZerosS();
        }
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        if (this.sPolesPade == null) {
            System.out.println("Method BlackBox.getPolesPadeS:");
            System.out.println("There are either no s-domain poles for this transfer function");
            System.out.println("or the s-domain denominator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.sPolesPade;
    }

    public Complex[] getZerosZ() {
        if (this.zZeros == null) {
            System.out.println("Method BlackBox.getZerosZ:");
            System.out.println("There are either no z-domain zeros for this transfer function");
            System.out.println("or the z-domain numerator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.zZeros;
    }

    public Complex[] getPolesZ() {
        if (this.zPoles == null) {
            System.out.println("Method BlackBox.getPolesZ:");
            System.out.println("There are either no z-domain poles for this transfer function");
            System.out.println("or the z-domain denominator polynomial has not been set");
            System.out.println("null returned");
            return null;
        }
        return this.zPoles;
    }

    public boolean getMaptozero() {
        return this.maptozero;
    }

    public String getName() {
        return this.name;
    }

    public void plotPoleZeroS() {
        if (this.sNumer == null) {
            throw new IllegalArgumentException("s domain numerator has not been set");
        }
        if (this.sDenom == null) {
            throw new IllegalArgumentException("s domain denominator has not been set");
        }
        PlotPoleZero ppz = new PlotPoleZero(this.sNumer, this.sDenom);
        ppz.setS();
        ppz.pzPlot(this.name);
    }

    public void plotPoleZeroPadeS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        if (this.sNumerPade == null) {
            throw new IllegalArgumentException("s domain numerator has not been set");
        }
        if (this.sDenomPade == null) {
            throw new IllegalArgumentException("s domain denominator has not been set");
        }
        PlotPoleZero ppz = new PlotPoleZero(this.sNumerPade, this.sDenomPade);
        ppz.setS();
        ppz.pzPlot(this.name);
    }

    public void plotPoleZeroZ() {
        PlotPoleZero ppz = new PlotPoleZero(this.zNumer, this.zDenom);
        if (this.zNumer == null) {
            throw new IllegalArgumentException("z domain numerator has not been set");
        }
        if (this.zDenom == null) {
            throw new IllegalArgumentException("z domain denominator has not been set");
        }
        ppz.setZ();
        ppz.pzPlot(this.name);
    }

    public void plotBode(double lowFreq, double highFreq) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        int nPoints = 100;
        double[][] cdata = new double[2][nPoints];
        double[] logFreqArray = new double[nPoints + 1];
        double logLow = Fmath.log10(Math.PI * 2 * lowFreq);
        double logHigh = Fmath.log10(Math.PI * 2 * highFreq);
        double incr = (logHigh - logLow) / ((double)nPoints - 1.0);
        double freqArray = lowFreq;
        logFreqArray[0] = logLow;
        for (int i = 0; i < nPoints; ++i) {
            freqArray = Math.pow(10.0, logFreqArray[i]);
            cdata[0][i] = logFreqArray[i];
            cdata[1][i] = 20.0 * Fmath.log10(this.evalMagTransFunctS(freqArray / (Math.PI * 2)));
            logFreqArray[i + 1] = logFreqArray[i] + incr;
        }
        PlotGraph pgmag = new PlotGraph(cdata);
        pgmag.setGraphTitle("Bode Plot = magnitude versus log10[radial frequency]");
        pgmag.setGraphTitle2(this.name);
        pgmag.setXaxisLegend("Log10[radial frequency]");
        pgmag.setYaxisLegend("Magnitude[Transfer Function]");
        pgmag.setYaxisUnitsName("dB");
        pgmag.setPoint(0);
        pgmag.setLine(3);
        pgmag.plot();
        for (int i = 0; i < nPoints; ++i) {
            freqArray = Math.pow(10.0, logFreqArray[i]);
            cdata[0][i] = logFreqArray[i];
            cdata[1][i] = this.evalPhaseTransFunctS(freqArray) * 180.0 / Math.PI;
        }
        PlotGraph pgphase = new PlotGraph(cdata);
        pgphase.setGraphTitle("Bode Plot = phase versus log10[radial frequency]");
        pgphase.setGraphTitle2(this.name);
        pgphase.setXaxisLegend("Log10[radial frequency]");
        pgphase.setYaxisLegend("Phase[Transfer Function]");
        pgphase.setYaxisUnitsName("degrees");
        pgphase.setPoint(0);
        pgmag.setLine(3);
        pgphase.plot();
    }

    public double getCurrentOutputT(double ttime, double inp) {
        this.setInputT(ttime, inp);
        return this.getCurrentOutputT();
    }

    public double getCurrentOutputT() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        ComplexPoly numerI = this.sNumerPade.times(new Complex(this.inputT[this.sampLen - 1], 0.0));
        Complex[] polyC = new Complex[]{Complex.zero(), Complex.plusOne()};
        ComplexPoly polyH = new ComplexPoly(polyC);
        ComplexPoly denomI = this.sDenomPade.times(polyH);
        Complex[][] coeffT = BlackBox.inverseTransform(numerI, denomI, this.sNumerWorkingFactor, this.sDenomScaleFactor);
        Complex tempc = Complex.zero();
        for (int j = 0; j < coeffT[0].length; ++j) {
            tempc.plusEquals(BlackBox.timeTerm(this.time[this.sampLen - 1], coeffT[0][j], coeffT[1][j], coeffT[2][j]));
        }
        double outReal = tempc.getReal();
        double outImag = tempc.getImag();
        boolean outTest = true;
        if (outImag == 0.0) {
            outTest = false;
        }
        if (outTest) {
            double temp = Math.max(Math.abs(outReal), Math.abs(outImag));
            if (Math.abs((outReal - outImag) / temp) > 1.0E-5) {
                outTest = false;
            } else {
                System.out.println("output in Blackbox.getCurrentOutputT() has a significant imaginary part");
                System.out.println("time = " + this.time[this.sampLen - 1] + "    real = " + outReal + "   imag = " + outImag);
                System.out.println("Output equated to the real part");
            }
        }
        this.outputT[this.sampLen - 1] = outReal;
        return this.outputT[this.sampLen - 1];
    }

    public double[] getOutputT() {
        return this.outputT;
    }

    public Complex getOutputS() {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        this.outputS = num.over(den).times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public Complex getOutputS(Complex svalue, Complex inputs) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        this.inputS = inputs;
        this.sValue = svalue;
        Complex num = this.sNumer.evaluate(this.sValue);
        Complex den = this.sDenom.evaluate(this.sValue);
        this.outputS = num.over(den).times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    public void setNplotPoints(int nPoints) {
        this.nPlotPoints = nPoints;
    }

    public int getNplotPoints() {
        return this.nPlotPoints;
    }

    public void impulseInput(double impulseMag, double finalTime) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        ComplexPoly impulseN = new ComplexPoly(0);
        impulseN.resetCoeff(0, Complex.plusOne().times(impulseMag));
        ComplexPoly numerT = this.sNumerPade.times(impulseN);
        ComplexPoly denomT = this.sDenomPade.copy();
        String graphtitle1 = "Impulse Input Transient:   Impulse magnitude = " + impulseMag;
        String graphtitle2 = this.getName();
        BlackBox.transientResponse(this.nPlotPoints, finalTime, this.deadTime, numerT, denomT, graphtitle1, graphtitle2, this.sNumerWorkingFactor, this.sDenomScaleFactor);
    }

    public void impulseInput(double finalTime) {
        this.impulseInput(1.0, finalTime);
    }

    public void stepInput(double stepMag, double finalTime) {
        Complex sNumer0 = this.sNumerPade.coeffCopy(0);
        Complex sDenom0 = this.sDenomPade.coeffCopy(0);
        boolean test0 = false;
        if (Complex.isReal(sNumer0) && Complex.isReal(sDenom0)) {
            test0 = true;
        }
        if (this.sNumerDeg == 0 && this.sDenomDeg == 0 && test0) {
            int i;
            int n = 51;
            double incrT = finalTime / (double)(n - 2);
            double[][] cdata = new double[2][n];
            cdata[0][0] = 0.0;
            cdata[0][1] = 0.0;
            for (int i2 = 2; i2 < n; ++i2) {
                cdata[0][i2] = cdata[0][i2 - 1] + incrT;
            }
            double kpterm = sNumer0.getReal() * stepMag / sDenom0.getReal();
            cdata[1][0] = 0.0;
            for (i = 1; i < n; ++i) {
                cdata[1][i] = kpterm;
            }
            if (this.deadTime != 0.0) {
                i = 0;
                while (i < n) {
                    double[] dArray = cdata[0];
                    int n2 = i++;
                    dArray[n2] = dArray[n2] + this.deadTime;
                }
            }
            PlotGraph pg = new PlotGraph(cdata);
            pg.setGraphTitle("Step Input Transient:   Step magnitude = " + stepMag);
            pg.setGraphTitle2(this.getName());
            pg.setXaxisLegend("Time");
            pg.setXaxisUnitsName("s");
            pg.setYaxisLegend("Output");
            pg.setPoint(0);
            pg.setLine(3);
            pg.plot();
        } else {
            if (!this.padeAdded) {
                this.transferPolesZeros();
            }
            ComplexPoly numerT = this.sNumer.times(stepMag);
            Complex[] polyC = new Complex[]{Complex.zero(), Complex.plusOne()};
            ComplexPoly polyH = new ComplexPoly(polyC);
            ComplexPoly denomT = this.sDenom.times(polyH);
            String graphtitle1 = "Step Input Transient:   Step magnitude = " + stepMag;
            String graphtitle2 = this.getName();
            BlackBox.transientResponse(this.nPlotPoints, finalTime, this.deadTime, numerT, denomT, graphtitle1, graphtitle2, this.sNumerWorkingFactor, this.sDenomScaleFactor);
        }
    }

    public void stepInput(double finalTime) {
        this.stepInput(1.0, finalTime);
    }

    public void rampInput(double rampGradient, int rampOrder, double finalTime) {
        if (!this.padeAdded) {
            this.transferPolesZeros();
        }
        ComplexPoly numerT = this.sNumer.times(rampGradient * (double)Fmath.factorial(rampOrder));
        Complex[] polyC = Complex.oneDarray(rampOrder + 1);
        for (int i = 0; i < rampOrder; ++i) {
            polyC[i] = Complex.zero();
        }
        polyC[rampOrder] = Complex.plusOne();
        ComplexPoly polyH = new ComplexPoly(polyC);
        ComplexPoly denomT = this.sDenom.times(polyH);
        String graphtitle1 = "";
        graphtitle1 = rampGradient != 1.0 ? (rampOrder != 1 ? graphtitle1 + "nth order ramp (at^n) input transient:   a = " + rampGradient + "    n = " + rampOrder : graphtitle1 + "First order ramp (at) input transient:   a = " + rampGradient) : (rampOrder != 1 ? graphtitle1 + "Unit ramp (t) input transient" : graphtitle1 + "nth order ramp (t^n) input transient:   n = " + rampOrder);
        String graphtitle2 = this.getName();
        BlackBox.transientResponse(this.nPlotPoints, finalTime, this.deadTime, numerT, denomT, graphtitle1, graphtitle2, this.sNumerWorkingFactor, this.sDenomScaleFactor);
    }

    public void rampInput(int rampOrder, double finalTime) {
        double rampGradient = 1.0;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    public void rampInput(double rampGradient, double finalTime) {
        int rampOrder = 1;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    public void rampInput(double finalTime) {
        double rampGradient = 1.0;
        int rampOrder = 1;
        this.rampInput(rampGradient, rampOrder, finalTime);
    }

    public static void transientResponse(int nPoints, double finalTime, double deadTime, ComplexPoly numerT, ComplexPoly denomT, String graphtitle1, String graphtitle2) {
        Complex[] roots = denomT.rootsNoMessages();
        Complex magDenom = BlackBox.scaleFactor(denomT, roots);
        Complex magNumer = Complex.plusOne();
        BlackBox.transientResponse(nPoints, finalTime, deadTime, numerT, denomT, graphtitle1, graphtitle2, magNumer, magDenom);
    }

    public static void transientResponse(int nPoints, double finalTime, double deadTime, ComplexPoly numerT, ComplexPoly denomT, String graphtitle1, String graphtitle2, Complex magN, Complex magD) {
        int i;
        Complex[][] coeffT = BlackBox.inverseTransform(numerT, denomT, magN, magD);
        int m = denomT.getDeg();
        double incrT = finalTime / (double)(nPoints - 1);
        double[][] cdata = new double[2][nPoints];
        double temp = 0.0;
        Complex tempc = new Complex();
        double outReal = 0.0;
        double outImag = 0.0;
        boolean outTest = true;
        cdata[0][0] = 0.0;
        for (i = 1; i < nPoints; ++i) {
            cdata[0][i] = cdata[0][i - 1] + incrT;
        }
        i = 0;
        while (i < nPoints) {
            outTest = true;
            tempc = Complex.zero();
            for (int j = 0; j < m; ++j) {
                tempc.plusEquals(BlackBox.timeTerm(cdata[0][i], coeffT[0][j], coeffT[1][j], coeffT[2][j]));
            }
            outReal = tempc.getReal();
            outImag = tempc.getImag();
            if (outImag == 0.0) {
                outTest = false;
            }
            if (outTest) {
                temp = Math.max(Math.abs(outReal), Math.abs(outImag));
                if (Math.abs((outReal - outImag) / temp) > 1.0E-5) {
                    outTest = false;
                } else {
                    System.out.println("output in Blackbox.stepInput has a significant imaginary part");
                    System.out.println("time = " + cdata[0][i] + "    real = " + outReal + "   imag = " + outImag);
                    System.out.println("Output equated to the real part");
                }
            }
            cdata[1][i] = outReal;
            double[] dArray = cdata[0];
            int n = i++;
            dArray[n] = dArray[n] + deadTime;
        }
        PlotGraph pg = new PlotGraph(cdata);
        pg.setGraphTitle(graphtitle1);
        pg.setGraphTitle2(graphtitle2);
        pg.setXaxisLegend("Time");
        pg.setXaxisUnitsName("s");
        pg.setYaxisLegend("Output");
        pg.setPoint(0);
        pg.setLine(3);
        pg.setNoYoffset(true);
        if (deadTime < cdata[0][nPoints - 1] - cdata[0][0]) {
            pg.setNoXoffset(true);
        }
        pg.setXlowFac(0.0);
        pg.setYlowFac(0.0);
        pg.plot();
    }

    public static Complex timeTerm(double ttime, Complex coeff, Complex constant, Complex power) {
        Complex ret = new Complex();
        int n = (int)power.getReal() - 1;
        ret = coeff.times(Math.pow(ttime, n));
        ret = ret.over(Fmath.factorial(n));
        ret = ret.times(Complex.exp(constant.times(ttime)));
        return ret;
    }

    public static double timeTerm(double ttime, double coeff, double constant, int power) {
        int n = power - 1;
        double ret = coeff * Math.pow(ttime, n);
        ret /= (double)Fmath.factorial(n);
        return ret *= Math.exp(constant * ttime);
    }

    public static double timeTerm(double ttime, double coeff, double constant, double power) {
        double n = power - 1.0;
        double ret = coeff * Math.pow(ttime, n);
        ret /= Fmath.factorial(n);
        return ret *= Math.exp(constant * ttime);
    }

    public static double[][] inverseTransformToReal(ComplexPoly numer, ComplexPoly denom) {
        Complex[][] com = BlackBox.inverseTransform(numer, denom);
        int n = com[0].length;
        double[][] ret = new double[3][n];
        for (int i = 0; i < n; ++i) {
            ret[0][i] = com[0][i].getReal();
            if (Math.abs((ret[0][i] - com[0][i].getImag()) / ret[0][i]) > 1.0E-5) {
                System.out.println("BlackBox inverseTransformToReal coefficient A[" + i + "] has a significant imaginary part: " + com[0][i]);
                System.out.println("A equated to the real part");
                System.out.println("inverseTransform method may be more appropriate");
            }
            ret[1][i] = com[1][i].getReal();
            if (Math.abs((ret[1][i] - com[1][i].getImag()) / ret[1][i]) > 1.0E-5) {
                System.out.println("BlackBox inverseTransformToReal coefficient a[" + i + "] has a significant imaginary part: " + com[1][i]);
                System.out.println("a equated to the real part");
                System.out.println("inverseTransform method may be more appropriate");
            }
            ret[2][i] = com[2][i].getReal();
        }
        return ret;
    }

    public static Complex[][] inverseTransform(ComplexPoly numer, ComplexPoly denom) {
        Complex[] roots = denom.rootsNoMessages();
        Complex magDenom = BlackBox.scaleFactor(denom, roots);
        Complex magNumer = Complex.plusOne();
        return BlackBox.inverseTransform(numer, denom, magNumer, magDenom);
    }

    public static Complex[][] inverseTransform(ComplexPoly numer, ComplexPoly denom, Complex magNumer, Complex magDenom) {
        int i;
        int i2;
        int polesN = denom.getDeg();
        int zerosN = numer.getDeg();
        if (zerosN >= polesN) {
            throw new IllegalArgumentException("The degree of the numerator is equal to or greater than the degree of the denominator");
        }
        Complex[][] ret = Complex.twoDarray(3, polesN);
        if (polesN == 1 && zerosN == 0) {
            Complex num = numer.coeffCopy(0);
            Complex den0 = denom.coeffCopy(0);
            Complex den1 = denom.coeffCopy(1);
            ret[0][0] = num.over(den1);
            ret[1][0] = Complex.minusOne().times(den0.over(den1));
            ret[2][0] = new Complex(1.0, 0.0);
            return ret;
        }
        int nDifferentRoots = polesN;
        int nSetsIdenticalRoots = 0;
        Complex[] poles = denom.rootsNoMessages();
        int[] polePower = new int[polesN];
        boolean[] poleSet = new boolean[polesN];
        int[] poleIdent = new int[polesN];
        int[] poleHighestPower = new int[polesN];
        boolean[] termSet = new boolean[polesN];
        double identicalRootLimit = 0.01;
        int[] numberInSet = new int[polesN];
        int power = 0;
        Complex identPoleAverage = new Complex();
        int lastPowerIndex = 0;
        for (i2 = 0; i2 < polesN; ++i2) {
            poleSet[i2] = false;
        }
        for (i2 = 0; i2 < polesN; ++i2) {
            termSet[i2] = true;
        }
        for (i2 = 0; i2 < polesN; ++i2) {
            int j;
            if (!poleSet[i2]) {
                power = 1;
                polePower[i2] = 1;
                poleHighestPower[i2] = 1;
                poleIdent[i2] = i2;
                numberInSet[i2] = 1;
                identPoleAverage = poles[i2];
                for (j = i2 + 1; j < polesN; ++j) {
                    if (poleSet[j]) continue;
                    if (poles[i2].isEqualWithinLimits(poles[j], identicalRootLimit)) {
                        poleIdent[j] = i2;
                        polePower[j] = ++power;
                        poleSet[j] = true;
                        poleSet[i2] = true;
                        termSet[j] = false;
                        termSet[i2] = false;
                        lastPowerIndex = j;
                        --nDifferentRoots;
                        identPoleAverage = identPoleAverage.plus(poles[j]);
                        continue;
                    }
                    poleIdent[j] = j;
                    polePower[j] = 1;
                }
            }
            if (!poleSet[i2]) continue;
            --nDifferentRoots;
            ++nSetsIdenticalRoots;
            termSet[lastPowerIndex] = true;
            identPoleAverage = identPoleAverage.over(power);
            for (j = 0; j < polesN; ++j) {
                if (!poleSet[j] || poleIdent[j] != i2) continue;
                poles[j] = identPoleAverage;
                poleHighestPower[i2] = power;
                numberInSet[j] = power;
            }
        }
        Complex poleAverage = Complex.zero();
        Complex absPoleAverage = Complex.zero();
        for (int i3 = 0; i3 < polesN; ++i3) {
            poleAverage = poleAverage.plus(poles[i3]);
            absPoleAverage = absPoleAverage.plus(poles[i3].abs());
        }
        poleAverage = poleAverage.over(polesN);
        absPoleAverage = absPoleAverage.over(polesN);
        Complex poleSubstitute = poleAverage;
        if (poleSubstitute.isZero()) {
            poleSubstitute = absPoleAverage;
        }
        if (poleSubstitute.isZero()) {
            poleSubstitute = Complex.plusOne();
        }
        Complex[] subValues = Complex.oneDarray(polesN);
        boolean[] subSet = new boolean[polesN];
        for (int i4 = 0; i4 < polesN; ++i4) {
            subSet[i4] = false;
        }
        Complex[] shifts = null;
        Complex delta = new Complex(1.7, 0.0);
        for (int i5 = 0; i5 < polesN; ++i5) {
            subValues[i5] = poles[i5].copy();
        }
        int currentNumberInSet = 0;
        if (nSetsIdenticalRoots > 0) {
            for (int i6 = 0; i6 < polesN; ++i6) {
                int j;
                if (numberInSet[i6] <= 1 || subSet[i6]) continue;
                currentNumberInSet = numberInSet[i6];
                shifts = Complex.oneDarray(numberInSet[i6]);
                int centre = numberInSet[i6] / 2;
                if (Fmath.isEven(numberInSet[i6])) {
                    for (j = 0; j < centre; ++j) {
                        shifts[centre + j] = delta.times(j + 1);
                        shifts[centre - 1 - j] = shifts[centre + j].times(-1.0);
                    }
                } else {
                    shifts[centre] = Complex.zero();
                    for (j = 0; j < centre; ++j) {
                        shifts[centre + 1 + j] = delta.times(j + 1);
                        shifts[centre - 1 - j] = shifts[centre + j].times(-1.0);
                    }
                }
                int kk = 0;
                for (int j2 = 0; j2 < polesN; ++j2) {
                    if (subSet[j2] || numberInSet[j2] != currentNumberInSet) continue;
                    Complex incr = poles[j2];
                    if (incr.isZero()) {
                        incr = poleSubstitute;
                    }
                    subValues[j2] = shifts[kk].times(incr);
                    subSet[j2] = true;
                    ++kk;
                }
            }
        }
        boolean testii = true;
        int ii = 0;
        int nAttempts = 0;
        while (testii) {
            int jj = ii + 1;
            boolean testjj = true;
            while (testjj) {
                if (subValues[ii].isEqualWithinLimits(subValues[jj], identicalRootLimit)) {
                    subValues[ii] = subValues[ii].plus(poleSubstitute.times(nAttempts));
                    ii = 0;
                    testjj = false;
                    if (++nAttempts > 1000000) {
                        throw new IllegalArgumentException("a non repeating set of substitution values could not be foumd");
                    }
                } else {
                    ++jj;
                }
                if (jj < polesN) continue;
                testjj = false;
            }
            if (++ii < polesN - 1) continue;
            testii = false;
        }
        Complex[][] mat = Complex.twoDarray(polesN, polesN);
        Complex[] vec = Complex.oneDarray(polesN);
        for (i = 0; i < polesN; ++i) {
            vec[i] = zerosN > 0 ? numer.evaluate(subValues[i]) : numer.coeffCopy(0);
        }
        for (i = 0; i < polesN; ++i) {
            for (int j = 0; j < polesN; ++j) {
                Complex denomTerm = Complex.plusOne();
                int powerD = 0;
                for (int k = 0; k < polesN; ++k) {
                    if (!termSet[k]) continue;
                    if (j != k) {
                        if (polePower[k] == 1) {
                            denomTerm = denomTerm.times(subValues[i].minus(poles[k]));
                            continue;
                        }
                        denomTerm = denomTerm.times(Complex.pow(subValues[i].minus(poles[k]), polePower[k]));
                        continue;
                    }
                    if (polePower[j] >= poleHighestPower[j]) continue;
                    powerD = poleHighestPower[j] - polePower[j];
                    if (powerD == 1) {
                        denomTerm = denomTerm.times(subValues[i].minus(poles[k]));
                        continue;
                    }
                    if (powerD == 0) continue;
                    denomTerm = denomTerm.times(Complex.pow(subValues[i].minus(poles[k]), powerD));
                }
                mat[i][j] = denomTerm;
            }
        }
        ComplexMatrix cmat = new ComplexMatrix(mat);
        Complex[] terms = cmat.solveLinearSet(vec);
        for (int i7 = 0; i7 < polesN; ++i7) {
            ret[0][i7] = terms[i7].times(magNumer).over(magDenom);
            ret[1][i7] = poles[i7];
            ret[2][i7].reset(polePower[i7], 0.0);
        }
        return ret;
    }

    public BlackBox copy() {
        if (this == null) {
            return null;
        }
        BlackBox bb = new BlackBox();
        this.copyBBvariables(bb);
        return bb;
    }

    public void copyBBvariables(BlackBox bb) {
        bb.sampLen = this.sampLen;
        bb.inputT = Conv.copy(this.inputT);
        bb.outputT = Conv.copy(this.outputT);
        bb.time = Conv.copy(this.time);
        bb.forgetFactor = this.forgetFactor;
        bb.deltaT = this.deltaT;
        bb.sampFreq = this.sampFreq;
        bb.inputS = this.inputS.copy();
        bb.outputS = this.outputS.copy();
        bb.sValue = this.sValue.copy();
        bb.zValue = this.zValue.copy();
        bb.sNumer = this.sNumer.copy();
        bb.sDenom = this.sDenom.copy();
        bb.zNumer = this.zNumer.copy();
        bb.zDenom = this.zDenom.copy();
        bb.sNumerSet = this.sNumerSet;
        bb.sDenomSet = this.sDenomSet;
        bb.sNumerScaleFactor = this.sNumerScaleFactor;
        bb.sDenomScaleFactor = this.sDenomScaleFactor;
        bb.sPoles = Complex.copy(this.sPoles);
        bb.sZeros = Complex.copy(this.sZeros);
        bb.zPoles = Complex.copy(this.zPoles);
        bb.zZeros = Complex.copy(this.zZeros);
        bb.sNumerDeg = this.sNumerDeg;
        bb.sDenomDeg = this.sDenomDeg;
        bb.zNumerDeg = this.zNumerDeg;
        bb.zDenomDeg = this.zDenomDeg;
        bb.deadTime = this.deadTime;
        bb.orderPade = this.orderPade;
        bb.sNumerPade = this.sNumerPade.copy();
        bb.sDenomPade = this.sDenomPade.copy();
        bb.sPolesPade = Complex.copy(this.sPolesPade);
        bb.sZerosPade = Complex.copy(this.sZerosPade);
        bb.sNumerDegPade = this.sNumerDegPade;
        bb.sDenomDegPade = this.sDenomDegPade;
        bb.maptozero = this.maptozero;
        bb.padeAdded = this.padeAdded;
        bb.integrationSum = this.integrationSum;
        bb.integMethod = this.integMethod;
        bb.ztransMethod = this.ztransMethod;
        bb.name = this.name;
        bb.fixedName = this.fixedName;
        bb.nPlotPoints = this.nPlotPoints;
    }

    public Object clone() {
        return this.copy();
    }
}

