/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.spliceSites;

import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;
import java.util.List;

public class AcgtTree {
    public static final char[] BASES = new char[]{'A', 'C', 'G', 'T'};
    public static final double LOG2 = Math.log(2.0);
    public static final int FAKE_COUNTS = 1;
    public static final double MAX_ENTROPY = 2.0;
    String name;
    AcgtTree[] nodes;
    int[] counts;
    int totalCount;
    AcgtTree parent;

    public static int base2index(char base) {
        switch (Character.toUpperCase(base)) {
            case 'A': {
                return 0;
            }
            case 'C': {
                return 1;
            }
            case 'G': {
                return 2;
            }
            case 'T': {
                return 3;
            }
        }
        throw new RuntimeException("Unknown base '" + base + "'");
    }

    public AcgtTree() {
        this.name = "";
        this.nodes = new AcgtTree[4];
        this.counts = new int[4];
        this.parent = null;
    }

    protected AcgtTree(String name, AcgtTree parent) {
        this.name = name;
        this.parent = parent;
        this.nodes = new AcgtTree[4];
        this.counts = new int[4];
    }

    public void add(String sequence) {
        if (sequence == null || sequence.isEmpty()) {
            ++this.totalCount;
            return;
        }
        char base = sequence.charAt(0);
        this.inc(base);
        AcgtTree node = this.getOrCreate(base);
        node.add(sequence.substring(1));
    }

    public double entropy() {
        double entropy = 0.0;
        for (double inf : this.informationContent()) {
            entropy += inf;
        }
        return entropy;
    }

    public List<Double> entropyAll(int thresholdCount) {
        ArrayList<Double> entropies = new ArrayList<Double>();
        this.entropyAll(thresholdCount, entropies);
        return entropies;
    }

    void entropyAll(int thresholdCount, ArrayList<Double> entropies) {
        if (this.totalCount >= thresholdCount) {
            entropies.add(this.entropy());
        }
        for (AcgtTree node : this.nodes) {
            if (node == null) continue;
            node.entropyAll(thresholdCount, entropies);
        }
    }

    public List<String> findNodeNames(double thresholdEntropy, double thresholdP, int thresholdCount) {
        ArrayList<String> names = new ArrayList<String>();
        if (this.getTotalCount() == 0) {
            return names;
        }
        double[] p = this.p();
        for (int idx = 0; idx < 4; ++idx) {
            AcgtTree n = this.nodes[idx];
            if (n == null) continue;
            if ((this.parent == null || this.parent.entropy() <= thresholdEntropy) && p[idx] >= thresholdP && this.counts[idx] >= thresholdCount) {
                names.add(n.name);
            }
            names.addAll(n.findNodeNames(thresholdEntropy, thresholdP, thresholdCount));
        }
        return names;
    }

    public AcgtTree get(char base) {
        return this.nodes[AcgtTree.base2index(base)];
    }

    public AcgtTree get(String bases) {
        if (bases.isEmpty()) {
            return this;
        }
        char base = bases.charAt(0);
        AcgtTree node = this.get(base);
        if (node == null) {
            return null;
        }
        return node.get(bases.substring(1));
    }

    public AcgtTree getOrCreate(char base) {
        AcgtTree node = this.get(base);
        if (node != null) {
            return node;
        }
        node = new AcgtTree(this.name + base, this);
        this.set(base, node);
        return node;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void inc(char base) {
        int n = AcgtTree.base2index(base);
        this.counts[n] = this.counts[n] + 1;
        ++this.totalCount;
    }

    double[] informationContent() {
        double[] inf = new double[4];
        double[] p = this.p();
        for (int i = 0; i < 4; ++i) {
            int n = i;
            inf[n] = inf[n] + -p[i] * Math.log(p[i]) / LOG2;
        }
        return inf;
    }

    double[] p() {
        int tot = 0;
        for (int c : this.counts) {
            tot += ++c;
        }
        double[] p = new double[4];
        int i = 0;
        for (int c : this.counts) {
            p[i] = (double)(++c) / (double)tot;
            ++i;
        }
        return p;
    }

    public List<Double> pAll(int thresholdCount) {
        ArrayList<Double> ps = new ArrayList<Double>();
        this.pAll(thresholdCount, ps);
        return ps;
    }

    protected void pAll(int thresholdCount, List<Double> ps) {
        for (int i = 0; i < this.nodes.length; ++i) {
            AcgtTree node = this.nodes[i];
            double[] p = this.p();
            if (node == null) continue;
            if (this.counts[i] >= thresholdCount) {
                ps.add(p[i]);
            }
            node.pAll(thresholdCount, ps);
        }
    }

    public double seqConservation() {
        return (2.0 - this.entropy()) / 2.0;
    }

    public void set(char base, AcgtTree n) {
        this.nodes[AcgtTree.base2index((char)base)] = n;
    }

    public String toString() {
        return this.toString("", 2.0, 1.0, 0);
    }

    public String toString(String tabs, double thresholdEntropy, double thresholdP, int thresholdCount) {
        if (this.getTotalCount() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        double[] p = this.p();
        for (int idx = 0; idx < 4; ++idx) {
            char base = BASES[idx];
            AcgtTree n = this.nodes[idx];
            if (n == null) continue;
            sb.append(String.format("%s%s%s: %d\te:%4.3f\tp:%4.2f\n", tabs, this.name, Character.valueOf(base), this.counts[idx], n.entropy(), p[idx]));
            if (!(n.entropy() <= thresholdEntropy) && !(p[idx] >= thresholdP) || this.counts[idx] < thresholdCount) continue;
            Gpr.debug("Name:" + n.name + "\tIdx:" + idx + "\tEntropy: " + n.entropy() + "\tP:" + p[idx] + "\tCount:" + this.counts[idx]);
            sb.append(n.toString(tabs + "\t", thresholdEntropy, thresholdP, thresholdCount));
        }
        return sb.toString();
    }
}

