/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.fileIterator.SeqChangeFileTxt;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChange;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryGtf22;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;

public class TestCasesSeqChange
extends TestCase {
    boolean verbose = false;
    boolean createOutputFile = false;
    Random rand;
    Config config;
    Genome genome;

    public TestCasesSeqChange() {
        this.initRand();
        this.config = new Config("testCase", "snpEff.config");
    }

    boolean anyResultMatches(String transcriptId, SeqChange seqChange, List<ChangeEffect> resultsList, boolean useShort) {
        boolean ok = false;
        for (ChangeEffect chEff : resultsList) {
            String resStr = chEff.toStringSimple(useShort);
            Transcript tr = chEff.getTranscript();
            if (!(tr != null ? (transcriptId == null || transcriptId.equals(tr.getId())) && resStr.indexOf(seqChange.getId()) >= 0 : resStr.indexOf(seqChange.getId()) >= 0)) continue;
            return true;
        }
        return ok;
    }

    void initRand() {
        this.rand = new Random(20100629L);
    }

    void initSnpEffPredictor() {
        this.initSnpEffPredictor("testCase");
    }

    void initSnpEffPredictor(String genomeName) {
        this.config = new Config(genomeName, "snpEff.config");
        this.config.loadSnpEffectPredictor();
        this.genome = this.config.getGenome();
        this.config.getSnpEffectPredictor().buildForest();
    }

    public List<SeqChange> parseSnpEffectFile(String seqChangeFile) {
        ArrayList<SeqChange> seqChanges = new ArrayList<SeqChange>();
        int inOffset = 1;
        SeqChangeFileTxt seqChangeFileIterator = new SeqChangeFileTxt(seqChangeFile, this.config.getGenome(), inOffset);
        for (SeqChange sc : seqChangeFileIterator) {
            seqChanges.add(sc);
        }
        Collections.sort(seqChanges);
        return seqChanges;
    }

    public void snpEffect(List<SeqChange> seqChangeList, String transcriptId, boolean useShort) {
        int num = 1;
        for (SeqChange seqChange : seqChangeList) {
            boolean ok;
            List<ChangeEffect> resultsList = this.config.getSnpEffectPredictor().seqChangeEffect(seqChange);
            String msg = "";
            msg = msg + "Number : " + num + "\n";
            msg = msg + "\tExpecting   : '" + seqChange.getId() + "'\n";
            msg = msg + "\tSeqChange   : " + seqChange + "\n";
            msg = msg + "\tResultsList :\n";
            for (ChangeEffect res : resultsList) {
                msg = msg + "\t" + res + "\n";
            }
            if (this.verbose) {
                System.out.println(msg);
            }
            if (!(ok = this.anyResultMatches(transcriptId, seqChange, resultsList, useShort))) {
                if (this.createOutputFile) {
                    for (ChangeEffect res : resultsList) {
                        SeqChange sc = res.getSeqChange();
                        System.out.println(sc.getChromosomeName() + "\t" + (sc.getStart() + 1) + "\t" + sc.getReference() + "\t" + sc.getChange() + "\t+\t0\t0" + "\t" + res.effect(true, true, true));
                    }
                } else {
                    Gpr.debug(msg);
                    throw new RuntimeException(msg);
                }
            }
            ++num;
        }
    }

    public void snpEffect(String snpEffFile, String transcriptId, boolean useShort) {
        List<SeqChange> snplist = this.parseSnpEffectFile(snpEffFile);
        this.snpEffect(snplist, transcriptId, useShort);
    }

    public void test_08() {
        String[] lines;
        this.initSnpEffPredictor();
        HashMap<String, String> cdsByTrId = new HashMap<String, String>();
        String cdsY = Gpr.readFile("./tests/cds_hg37_chrY.txt");
        for (String line : lines = cdsY.split("\n")) {
            String[] recs = line.split("\t");
            cdsByTrId.put(recs[0], recs[1]);
        }
        int totalOk = 0;
        for (Gene gint : this.config.getGenome().getGenes()) {
            for (Transcript tint : gint) {
                String seqOri = (String)cdsByTrId.get(tint.getId());
                if (seqOri == null) continue;
                String seq = tint.cds();
                if (!seqOri.equalsIgnoreCase(seq)) {
                    throw new RuntimeException("CDS do not match:\nTranscipt:" + tint.getId() + " " + tint.getStrand() + "\n\t" + seq + "\n\t" + seqOri + "\n");
                }
                if (this.verbose) {
                    System.out.println("CDS compare:\n\t" + seqOri + "\n\t" + seq);
                }
                ++totalOk;
            }
        }
        if (totalOk == 0) {
            throw new RuntimeException("No sequences compared!");
        }
    }

    public void test_09() {
        this.initSnpEffPredictor();
        String trId = "ENST00000250823";
        this.snpEffect("tests/" + trId + ".out", trId, true);
    }

    public void test_11() {
        this.initSnpEffPredictor();
        CodonChange.showCodonChange = false;
        String trId = "ENST00000250823";
        this.snpEffect("tests/" + trId + "_all.out", trId, false);
    }

    public void test_12() {
        this.initSnpEffPredictor();
        this.snpEffect("tests/splice_site.out", null, false);
    }

    public void test_12_2() {
        this.initSnpEffPredictor();
        this.snpEffect("tests/splice_site_2.out", null, false);
    }

    public void test_19() {
        this.initSnpEffPredictor();
        String trId = "ENST00000439108";
        this.snpEffect("tests/" + trId + ".snps", trId, false);
    }

    public void test_20() {
        this.initSnpEffPredictor();
        String trId = "ENST00000382673";
        this.snpEffect("tests/" + trId + ".snps", trId, false);
    }

    public void test_21() {
        this.initSnpEffPredictor();
        String trId = "ENST00000250823";
        this.snpEffect("tests/" + trId + "_InDels.out", trId, false);
    }

    public void test_21_2() {
        this.initSnpEffPredictor();
        String trId = "ENST00000250823";
        this.snpEffect("tests/" + trId + "_InDels_2.out", trId, false);
    }

    public void test_21_3() {
        this.initSnpEffPredictor();
        String trId = "ENST00000250823";
        this.snpEffect("tests/" + trId + "_InDels_3.out", trId, true);
    }

    public void test_22() {
        boolean trown;
        block4: {
            this.initSnpEffPredictor();
            SeqChangeFileTxt snpFileIterator = new SeqChangeFileTxt("tests/chr_not_found.out", this.config.getGenome(), 0);
            snpFileIterator.setIgnoreChromosomeErrors(false);
            trown = false;
            try {
                for (SeqChange seqChange : snpFileIterator) {
                    Gpr.debug(seqChange);
                }
            }
            catch (RuntimeException e) {
                trown = true;
                String expectedMessage = "ERROR: Chromosome 'chrZ' not found! File 'tests/chr_not_found.out', line 1";
                if (e.getMessage().equals(expectedMessage)) break block4;
                throw new RuntimeException("This is not the exception I was expecting!\n\tExpected message: '" + expectedMessage + "'\n\tMessage: '" + e.getMessage() + "'", e);
            }
        }
        if (!trown) {
            throw new RuntimeException("This should have thown an exception 'Chromosome not found!' but it didn't");
        }
    }

    public void test_23_MNP_on_exon_edge() {
        this.initSnpEffPredictor();
        String trId = "ENST00000250823";
        this.snpEffect("tests/" + trId + "_mnp_out_of_exon.txt", trId, true);
    }

    public void test_24_delete_exon_utr() {
        this.initSnpEffPredictor();
        this.snpEffect("tests/delete_exon_utr.txt", null, true);
    }

    public void test_25_exon_bases() {
        System.out.println("Loading config file");
        this.config = new Config("testCase", "snpEff.config");
        this.config.loadSnpEffectPredictor();
        System.out.println("Loading fasta file");
        String fastaFile = "tests/testCase.fa";
        String seq = GprSeq.fastaSimpleRead(fastaFile);
        int countOk = 0;
        int countErr = 0;
        for (Gene gint : this.config.getGenome().getGenes()) {
            for (Transcript tr : gint) {
                System.out.println("Transcript: " + tr.getId());
                List exons = tr.sortedStrand();
                for (Exon exon : exons) {
                    for (int i = exon.getStart(); i <= exon.getEnd(); ++i) {
                        String exonBase;
                        String base = seq.substring(i, i + 1);
                        if (base.equalsIgnoreCase(exonBase = exon.basesAt(i - exon.getStart(), 1))) {
                            ++countOk;
                            continue;
                        }
                        ++countErr;
                        String msg = "ERROR:\tPosition: " + i + "\tExpected: " + base + "\tGot: " + exonBase;
                        Gpr.debug(msg);
                        throw new RuntimeException(msg);
                    }
                }
            }
        }
        System.out.println("Count OK: " + countOk + "\tCount Err: " + countErr);
    }

    public void test_26_chr15_78909452() {
        this.initSnpEffPredictor("testHg3761Chr15");
        this.snpEffect("tests/chr15_78909452.txt", null, true);
    }

    public void test_28_Splice_mm37_ENSMUSG00000005763() {
        String gtfFile = "tests/ENSMUSG00000005763.gtf";
        String genome = "testMm37.61";
        int inOffset = 1;
        this.config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryGtf22 fgtf22 = new SnpEffPredictorFactoryGtf22(this.config, inOffset);
        fgtf22.setFileName(gtfFile);
        fgtf22.setReadSequences(false);
        SnpEffectPredictor snpEffectPredictor = fgtf22.create();
        this.config.setSnpEffectPredictor(snpEffectPredictor);
        for (Chromosome chr : this.config.getGenome()) {
            chr.setEnd(1000000000);
        }
        snpEffectPredictor.buildForest();
        this.snpEffect("tests/ENSMUSG00000005763.out", null, true);
    }

    public void test_29_Intergenic_in_Gene() {
        this.initSnpEffPredictor("testHg3763Chr20");
        this.snpEffect("tests/warren.eff.missing.chr20.txt", null, true);
    }

    public void test_30_RareAa() {
        this.initSnpEffPredictor("testHg3765Chr22");
        this.snpEffect("tests/rareAa.txt", null, true);
    }

    public void test_31_CodonTable() {
        this.initSnpEffPredictor("testHg3767Chr21Mt");
        this.snpEffect("tests/mt.txt", null, true);
    }
}

