/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.sideeffect;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import com.tinkerpop.pipes.util.iterators.ExpandableMultiIterator;
import com.tinkerpop.pipes.util.iterators.SingleIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GroupByReducePipe<S, K, V, V2>
extends AbstractPipe<S, S>
implements SideEffectPipe<S, Map<K, V2>> {
    private Map<K, Iterator<V>> byMap = new HashMap<K, Iterator<V>>();
    private final PipeFunction<S, K> keyFunction;
    private final PipeFunction<S, V> valueFunction;
    private final PipeFunction<Iterator<V>, V2> reduceFunction;
    private Map<K, V2> reduceMap;

    public GroupByReducePipe(PipeFunction<S, K> keyFunction, PipeFunction<S, V> valueFunction, PipeFunction<Iterator<V>, V2> reduceFunction) {
        this(new HashMap(), keyFunction, valueFunction, reduceFunction);
    }

    public GroupByReducePipe(Map<K, V2> reduceMap, PipeFunction<S, K> keyFunction, PipeFunction<S, V> valueFunction, PipeFunction<Iterator<V>, V2> reduceFunction) {
        this.reduceMap = reduceMap;
        this.keyFunction = keyFunction;
        this.valueFunction = valueFunction;
        this.reduceFunction = reduceFunction;
    }

    @Override
    protected S processNextStart() {
        Object s = this.starts.next();
        K key = this.getKey(s);
        V value = this.getValue(s);
        ExpandableMultiIterator values = (ExpandableMultiIterator)this.byMap.get(key);
        if (null == values) {
            values = new ExpandableMultiIterator();
            this.addValue(value, values);
            this.byMap.put(key, values);
        } else {
            this.addValue(value, values);
        }
        if (!this.starts.hasNext()) {
            for (Map.Entry<K, Iterator<V>> entry : this.byMap.entrySet()) {
                this.reduceMap.put(entry.getKey(), this.reduceFunction.compute(entry.getValue()));
            }
            this.byMap.clear();
        }
        return (S)s;
    }

    public void addValue(V value, ExpandableMultiIterator values) {
        if (value instanceof Pipe) {
            values.addIterator((Pipe)value);
        } else {
            values.addIterator(new SingleIterator<V>(value));
        }
    }

    @Override
    public Map<K, V2> getSideEffect() {
        return this.reduceMap;
    }

    private K getKey(S start) {
        if (null == this.keyFunction) {
            return (K)start;
        }
        return this.keyFunction.compute(start);
    }

    private V getValue(S start) {
        if (null == this.valueFunction) {
            return (V)start;
        }
        return this.valueFunction.compute(start);
    }

    @Override
    public void reset() {
        this.byMap = new HashMap<K, Iterator<V>>();
        this.reduceMap = new HashMap<K, V2>();
        super.reset();
    }
}

