/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.filter;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.filter.FilterPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import java.util.Collection;

public abstract class CollectionFilterPipe<S>
extends AbstractPipe<S, S>
implements FilterPipe<S> {
    private final Collection<S> storedCollection;
    private final FilterPipe.Filter filter;

    public CollectionFilterPipe(Collection<S> storedCollection, FilterPipe.Filter filter) {
        this.storedCollection = storedCollection;
        if (filter != FilterPipe.Filter.NOT_EQUAL && filter != FilterPipe.Filter.EQUAL) {
            throw new IllegalArgumentException("The only legal filters are equals and not equals");
        }
        this.filter = filter;
    }

    private boolean checkCollection(S rightObject) {
        if (this.filter == FilterPipe.Filter.NOT_EQUAL) {
            return !this.storedCollection.contains(rightObject);
        }
        return this.storedCollection.contains(rightObject);
    }

    @Override
    protected S processNextStart() {
        Object s;
        while (!this.checkCollection(s = this.starts.next())) {
        }
        return (S)s;
    }

    @Override
    public String toString() {
        return PipeHelper.makePipeString(this, new Object[]{this.filter});
    }
}

