### Print out all values in the args array
echo "All values in the args array:"
echo $*

### Show error and return exit code 1 if these inputs are not specified
### NOTE: They are not used, but are included here for compile script argument checking
if [ "$1" != "--inputFile" ] ; then
  echo "Error: first arg should be '--inputFile'"
  exit 1;
fi

if [ "$2" != "inputFile" ] ; then
  echo "Error: first arg should be 'inputFile'"
  exit 1;
fi

if [ "$3" != "--column" ] ; then
  echo "Error: first arg should be '--column'"
  exit 1;
fi

if [ "$4" != "4" ] ; then
  echo "Error: first arg should be '4'"
  exit 1;
fi



### Get the output file path (last arg)
#fileOutputPath=${array[@]: -1}
fileOutputPath=$MAKE_JSON_OUTPUT_FILE_PATH
echo "File output path: $fileOutputPath"

echo "Writing to JSON file..."
echo "### All args, one per line" > $fileOutputPath
idx=1
for arg in $*; do
  echo "### Arg[$idx]: $arg"  >> $fileOutputPath
  idx=$((idx + 1))
done
echo "1	2	3	{'key':'val','aaa':2,'_landmark':1,'_minBP':100,'_maxBP':100}" >> $fileOutputPath
echo "2	3	4	{'key2':'val2','bbb':3,'_landmark':2,'_minBP':200,'_maxBP':200}" >> $fileOutputPath

makeJsonOutputFilePath=`printenv MAKE_JSON_OUTPUT_FILE_PATH`
echo "makeJsonOutputFilePath=$makeJsonOutputFilePath"

echo "Done"
