package edu.mayo.bior.cli.cmd;

import static org.junit.Assert.assertEquals;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

import edu.mayo.bior.cli.cmd.ReplaceLinesCommand;
import edu.mayo.bior.cli.func.BaseFunctionalTest;
import edu.mayo.bior.cli.func.CommandOutput;
import edu.mayo.cli.CommandPlugin;
import htsjdk.samtools.util.StringUtil;

public class ReplaceLinesTest extends BaseFunctionalTest {

	private List<String> inputLines;
	private File tempDir;
	
	@Before
	public void beforeEach() throws IOException {
		inputLines = Arrays.asList(
				"##fileformat=VCFv4.1",
				"##INFO=<ID=AF,Number=.,Type=Float,Description=\"Allele Frequency, for each ALT allele, in the same order as listed\">",
				"##INFO=<ID=dbSNPBuildID,Number=.,Type=String,Description=\"First dbSNP Build for RS\">",
				concat("#CHROM", "POS",   "ID",  "REF", "ALT", "QUAL", "FILTER", "INFO"),
				concat("1",      "10144", "rs1", "TA",  "T",   ".",    "PASS",   "ASP;RSPOS=10145;SAO=0;SSR=0;dbSNPBuildID=134"),
				concat("1",      "10228", "rs2", "TA",  "T",   ".",    "PASS",   "ASP;RSPOS=10229;SAO=0;SSR=0;dbSNPBuildID=134")
				);
		
		TemporaryFolder temp = new TemporaryFolder();
		temp.create();
		tempDir = temp.newFolder();
	}
	
	@Test
	@Ignore
	/** Test single line to replace */
	public void testSingleLine() {
	}
	
	@Test
	/** Test multiple lines to replace, one of which is a tabbed line */
	public void testMultipleLine() throws IOException, InterruptedException {
		String findText = "##INFO=<ID=AF,Number=.,Type=Float,Description=\"Allele Frequency, for each ALT allele, in the same order as listed\">" + "\n" +
						  "##INFO=<ID=dbSNPBuildID,Number=.,Type=String,Description=\"First dbSNP Build for RS\">" + "\n";

		String replaceWith = "##INFO=<ID=AF,Number=.,Type=String,Description=\"Allele Freq\">" + "\n" +
							 "##INFO=<ID=dbSNPBuildID,Number=.,Type=Integer,Description=\"First dbSNP Build\">" + "\n";

		File findFile = new File(tempDir, "find.txt");
		FileUtils.write(findFile, findText);

		File replaceWithFile = new File(tempDir, "replaceWith.txt");
		FileUtils.write(replaceWithFile, replaceWith);
		
		List<String> expected = Arrays.asList(
				"##fileformat=VCFv4.1",
				"##INFO=<ID=AF,Number=.,Type=String,Description=\"Allele Freq\">",
				"##INFO=<ID=dbSNPBuildID,Number=.,Type=Integer,Description=\"First dbSNP Build\">",
				concat("#CHROM", "POS",   "ID",  "REF", "ALT", "QUAL", "FILTER", "INFO"),
				concat("1",      "10144", "rs1", "TA",  "T",   ".",    "PASS",   "ASP;RSPOS=10145;SAO=0;SSR=0;dbSNPBuildID=134"),
				concat("1",      "10228", "rs2", "TA",  "T",   ".",    "PASS",   "ASP;RSPOS=10229;SAO=0;SSR=0;dbSNPBuildID=134"),
				""
				);
		
		String stdin = StringUtil.join("\n", inputLines);
		setStdin(stdin);
		CommandOutput out = runCmdApp(new ReplaceLinesCommand(), "bior_replace_lines", "--fromLines", findFile.getCanonicalPath(), "--toLines", replaceWithFile.getCanonicalPath());
		assertEquals("", out.stderr);
		assertEquals(0,  out.exit);
		assertEquals(StringUtil.join("\n", expected), out.stdout);
	}
	
	@Test
	@Ignore
	/** Test error case - not same # of lines */
	public void testMismatchInLineCount() {
		
	}

	
	@Test
	@Ignore
	/** Test replacing a line with a blank line (should remove the newline at the end as well) */
	public void testRemoveLine() {
		
	}
	
	@Test
	@Ignore
	/** Warn when one of the lines was not detected */
	public void warnWhenLineNotFound() {
		
	}

}
