package edu.mayo.bior.cli.cmd;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.io.File;
import java.io.IOException;

import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

import edu.mayo.bior.cli.func.BaseFunctionalTest;
import edu.mayo.bior.cli.func.CommandOutput;
import edu.mayo.pipes.util.BiorProperties;

/** Test the LookupCommand class used by bior_lookup */
public class LookupCommandTest  extends  BaseFunctionalTest{

//	@Rule
//	public TemporaryFolder tempFolder = new TemporaryFolder();
//	
//	private File tempDir;
//	private File targetDir;
//	private File sharedClusterDir;
//	private File logFile;
//	
//	private File biorLiteHome;
	private static String biorPropertiesPathBefore;
	
	@Before
	public void beforeEach() throws IOException {
//		tempFolder.create();
//		tempDir = tempFolder.newFolder("Temp");
//		targetDir = tempFolder.newFolder("Target");
//		sharedClusterDir = tempFolder.newFolder("Shared");
		BaseFunctionalTest.setBiorToolkitCmdsRequired(false);
		
//		logFile = new File(tempDir, "bior.log");
		//biorLiteHome = getBiorLiteHome();
		
		// Override the paths to mforge system /research dirs, and use local ones for testing
		biorPropertiesPathBefore = BiorProperties.getFile();
		BiorProperties.setFile("src/test/resources/bior.properties.test");
	}
	
	@After
	public void afterEach() {
		BiorProperties.setFile(biorPropertiesPathBefore);
	}
	
	@Test
	public void testLookupDefaultIndex() throws IOException {
		String dir = "src/test/resources/testData/verification/catalog_with_indexes";
		File ctg = new File(dir, "catalog.tsv.bgz");
		String key = "i";
		String stdin = "1";
		CommandOutput out = runLookupCmdDefaultIndex(ctg, key, stdin);
		assertEquals(0, out.exit);
		assertEquals("", out.stderr);
		String expected = "1	{'_landmark':'1','_minBP':100,'_maxBP':100,'i':1,'f':1.0,'b':true,'s':'str1','a2':['a']}".replace("'", "\"");
		String actual   = removeHeaders(out.stdout);
		assertEquals(expected, actual);
	}

	
	@Test
	public void testLookupManualIndexNotInDefaultPath() throws IOException {
		String dir = "src/test/resources/testData/verification/catalog_with_indexes";
		File ctg = new File(dir, "catalog.tsv.bgz");
		File idx = new File(dir + "/index", "catalog.i.idx.h2.db");
		String key = "i";
		String stdin = "1";
		CommandOutput out = runLookupCmdManualIndex(ctg, idx, key, stdin);
		assertEquals(out.stderr, 0, out.exit);
		assertEquals("", out.stderr);
		String expected = "1	{'_landmark':'1','_minBP':100,'_maxBP':100,'i':1,'f':1.0,'b':true,'s':'str1','a2':['a']}".replace("'", "\"");
		String actual   = removeHeaders(out.stdout);
		assertEquals(expected, actual);
	}

	
	private CommandOutput runLookupCmdDefaultIndex(File ctg, String key, String stdin) throws IOException {
		CommandOutput out = runCmdApp(stdin, new LookupCommand(), "bior_lookup",
				"-d", ctg.getCanonicalPath(),
				"-p", key
				);
		return out;
	}


	private CommandOutput runLookupCmdManualIndex(File ctg, File indexFile, String key, String stdin) throws IOException {
		CommandOutput out = runCmdApp(stdin, new LookupCommand(), "bior_lookup",
				"-d", ctg.getCanonicalPath(),
				"-p", key,
				"-i", indexFile.getCanonicalPath()
				);
		return out;
	}

}
