package edu.mayo.bior.catalog.markdown.transformer.comparison;

import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import org.junit.Test;

import java.io.IOException;

import static org.junit.Assert.assertEquals;

public class CatalogVolumeImplTest {

    private static final char NEWLINE = '\n';

    @Test
    public void transform() throws IOException, TransformException {

        CatalogDiffStatistics.SummaryStats summaryStats = new CatalogDiffStatistics().new SummaryStats();
        summaryStats.setCatalogOldEntries(1);
        summaryStats.setCatalogNewEntries(10);
        summaryStats.setCatalogEntriesAdded(15);
        summaryStats.setCatalogEntriesRemoved(6);

        CatalogDiffStatistics stats = new CatalogDiffStatistics();
        stats.setSummaryStats(summaryStats);

        CatalogVolumeImpl transformer = new CatalogVolumeImpl(stats);

        final String ORIGINAL_MARKDOWN =
                "BEGIN" + NEWLINE +
                CatalogVolumeImpl.TEMPLATE_KEYWORD + NEWLINE +
                "END";

        final String EXPECTED_MARKDOWN =
                "BEGIN" + NEWLINE +
                "Metric | Description | Count" + NEWLINE +
                "--- | --- | ---" + NEWLINE +
                "Previous Rows | # of rows in the previous catalog | 1" + NEWLINE +
                "Removed Rows | # of rows removed from the previous catalog | -6" + NEWLINE +
                "Added Rows | # of rows added to the previous catalog | +15" + NEWLINE +
                "Current Rows | # of rows in the current catalog | 10" + NEWLINE +
                "Net Difference | Difference between Previous Rows and Current Rows | +9" + NEWLINE +
                "END";

        String actualMarkdown = transformer.transform(ORIGINAL_MARKDOWN);
        assertEquals(EXPECTED_MARKDOWN, actualMarkdown);
    }

    @Test
    public void transformMissingCatalogDiffStats() throws IOException, TransformException {

        CatalogVolumeImpl transformer = new CatalogVolumeImpl(null);

        final String ORIGINAL_MARKDOWN =
                "BEGIN" + NEWLINE +
                CatalogVolumeImpl.TEMPLATE_KEYWORD + NEWLINE +
                "END";

        final String EXPECTED_MARKDOWN =
                "BEGIN" + NEWLINE +
                ComparisonStatsImpl.NOT_AVAILABLE_MESG + NEWLINE +
                "END";

        String actualMarkdown = transformer.transform(ORIGINAL_MARKDOWN);
        assertEquals(EXPECTED_MARKDOWN, actualMarkdown);
    }
}
