package edu.mayo.bior.catalog.markdown;

import org.junit.Test;

import static edu.mayo.bior.catalog.markdown.MarkdownUtils.chompTrailingNewlines;
import static edu.mayo.bior.catalog.markdown.MarkdownUtils.escapeChrs;
import static org.junit.Assert.assertEquals;

public class MarkdownUtilsTest {
    @Test
    public void escapeChrsTest() {
        String in = "Hello there `Dave`\\Mike, See the *, how they shine for you!  This refdata_new_dir {variable}[0] (first var) is #hashtag 20 +/- 3 <VARIABLE>.";
        String escaped = escapeChrs(in);
        String EXPECTED = "Hello there \\`Dave\\`\\\\Mike, See the \\*, how they shine for you\\!  This refdata\\_new\\_dir \\{variable\\}\\[0\\] \\(first var\\) is \\#hashtag 20 \\+/\\- 3 <VARIABLE\\>\\.";
        assertEquals(EXPECTED, escaped);
    }

    @Test
    public void chompTrailingNewlinesTest() {
        assertEquals("ABC", chompTrailingNewlines("ABC\n"));
        assertEquals("ABC", chompTrailingNewlines("ABC\n\n\n"));
        assertEquals("A\nB\nC", chompTrailingNewlines("A\nB\nC"));
        assertEquals("", chompTrailingNewlines(""));
        assertEquals("   ", chompTrailingNewlines("   "));
        assertEquals("", chompTrailingNewlines("\n\n\n"));
    }

    @Test
    public void positiveNumPrint() {
        assertEquals("+3", MarkdownUtils.positiveNumPrint(3));
        assertEquals("0", MarkdownUtils.positiveNumPrint(0));
        assertEquals("-3", MarkdownUtils.positiveNumPrint(-3));
    }
}
