package edu.mayo.bior.catalog.list;

import static org.junit.Assert.assertEquals;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.junit.Test;

import edu.mayo.pipes.util.test.PipeTestUtils;

/** Test the CatalogListGenerator class
 * @author Michael Meiners (m054457) - July, 2016
 */
public class CatalogListGeneratorTest {

	
	@Test
	/** Test the full generation of contents for CATALOG_LIST.txt */
	public void testCatalogListGenerator() throws IOException {
		CatalogListGenerator lister = new CatalogListGenerator();
		String catalogDir = new File("src/test/resources/_bior_catalog_list/Catalogs").getCanonicalPath();
		String actual = lister.createCatalogList(catalogDir);
		
		
		String dbSnp137_path    = catalogDir + "/dbSNP/137/00-All_GRCh37.tsv.bgz";
		String dbSnp137_clinvarPath=catalogDir+"/dbSNP/137/clinvar_20130226_GRCh37.tsv.bgz";
		String dbSnp142_v1_path = catalogDir + "/dbSNP/142_GRCh37.p13/variants_nodups.v1/00-All.vcf.tsv.bgz";
		String dbSnp142_v2_path = catalogDir + "/dbSNP/142_GRCh37.p13/variants_nodups.v2/00-All.vcf.tsv.bgz";
		String exAc_37_path     = catalogDir + "/ExAC/r0.3_GRCh37/variants_nodups.v1/ExAC.r0.3.sites.vep.vcf.tsv.bgz";
		String exAc_38_path     = catalogDir + "/ExAC/r0.3_GRCh38/variants_nodups.v1/ExAC.r0.3.sites.vep.vcf.liftover.tsv.bgz";
		String ncbiGenePath     = catalogDir + "/NCBIGene/GRCh37_p13/genes.tsv.bgz";
		
		String expected = concat("#Status",    "Path",              "LastUpdated",          		"ShortName",             "Indexes",           "DataSource", "Version", "Build",      "BuildBase", "Dataset") + "\n"
				+		  concat("Active",     dbSnp137_path,       getLastMod(dbSnp137_path),  	"dbSNP137",              "ID",                "dbSNP",      "137",     "GRCh37.p5",  "GRCh37",    "Variants") + "\n"
				+         concat("Active",     dbSnp137_clinvarPath,getLastMod(dbSnp137_clinvarPath),"dbSNP137_clinvar",     ".",                 "ClinVar",    "137",     "GRCh37.p5",  "GRCh37",    "Clinical Variants") + "\n"
				+ 		  concat("Deprecated", dbSnp142_v1_path,    getLastMod(dbSnp142_v1_path),   "dbSNP_142_GRCh37p13",	 "ID",                "dbSNP",      "142",     "GRCh37.p13", "GRCh37",    "Variants") + "\n"
				+ 		  concat("Active",     dbSnp142_v2_path,    getLastMod(dbSnp142_v2_path),  	"dbSNP_142_GRCh37p13",   "ID",                "dbSNP",      "142",     "GRCh37.p13", "GRCh37",    "Variants") + "\n"
				+         concat("Active",     exAc_37_path,        getLastMod(exAc_37_path),  		"ExAC_r03_GRCh37_nodups",".",                 "ExAC",       "r0.3",    "GRCh37",     "GRCh37",    "Variants") + "\n"
				+ 		  concat("Active",     exAc_38_path,        getLastMod(exAc_38_path),  		"ExAC_r03_GRCh38_nodups",".",                 "ExAC",       "r0.3",    "GRCh38",     "GRCh38",    "Variants") + "\n"
				+		  concat("Active",     ncbiGenePath,        getLastMod(ncbiGenePath), 		"gene37p10",             "gene,GeneID,HGNC",  "NCBI",       "37p10",   "GRCh37.p10", "GRCh37",    "Entrez Gene") + "\n";

		assertEquals(expected, actual);
	}
	
	private String getLastMod(String filePath) {
		File file = new File(filePath);
		Date lastMod = new Date(file.lastModified());
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String dateStr = format.format(lastMod);
		return dateStr;
	}

	private String concat(String... strs) {
		return PipeTestUtils.combine(strs, "\t");
	}
}
