package edu.mayo.bior.util.validation;

import java.io.File;
import java.io.IOException;

import edu.mayo.bior.catalog.CatalogMetadataConstant;

public class CatalogFileValidator {

	public static boolean catalogExists(String catalogFilePath) {
		if (catalogFilePath == null) {
			return false;
		}
		File catalogFile = new File(catalogFilePath);
		return catalogExists(catalogFile);
	}

	public static boolean catalogExists(File catalogFile) {
		if (catalogFile == null) {
			return false;
		} else if (!catalogFile.exists()) {
			return false;
		} else if (catalogFile.length() <= 0) {
			return false;
		} 
		return true;
	}
	
	public static boolean hasExpectedSuffix(String catalogFilePath) {
		if (catalogFilePath == null ||
			catalogFilePath.length() == 0 ||
			!catalogFilePath.endsWith(CatalogMetadataConstant.CATALOG_FILE_SUFFIX)) {
			return false;
		}
		return true;
	}
	
	public static boolean hasExpectedSuffix(File catalogFile) {
		try {
			if (catalogFile == null) {
				return false;
			} 
			return hasExpectedSuffix(catalogFile.getCanonicalPath());
		} catch (IOException io) {
			return false;
		}
	}
}
