/**
 * bior_pipeline
 *
 * <p>@author Gregory Dougherty</p>
 * Copyright Mayo Clinic, 2014
 *
 */
package edu.mayo.bior.util;

import edu.mayo.pipes.JSON.tabix.OverlapPipe;
import edu.mayo.pipes.JSON.tabix.SameVariantPipe;

/**
 * Class representing a BioR catalog
 *
 * <p>@author Gregory Dougherty</p>
 */
public class Catalog
{
	private String	name;
	private String	path;
	private boolean	overlap;
	
	
	/**
	 * Constructor
	 * 
	 * @param name		Unique name for the Catalog
	 * @param path		Path to the catalog on the file system
	 * @param overlap	True if it uses an {@linkplain OverlapPipe}, false if it uses 
	 * {@linkplain SameVariantPipe} 
	 */
	public Catalog (String name, String path, boolean overlap)
	{
		this.name = name;
		this.path = path;
		this.overlap = overlap;
	}
	
	
	/**
	 * @return the name
	 */
	public final String getName ()
	{
		return name;
	}
	
	
	/**
	 * @return the path
	 */
	public final String getPath ()
	{
		return path;
	}
	
	
	/**
	 * @return the overlap
	 */
	public final boolean isOverlap ()
	{
		return overlap;
	}
	
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode ()
	{
		final int prime = 31;
		int result = 1;
		
		result = prime * result + ((name == null) ? 0 : name.hashCode ());
		result = prime * result + (overlap ? 1231 : 1237);
		result = prime * result + ((path == null) ? 0 : path.hashCode ());
		return result;
	}
	
	
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals (Object obj)
	{
		if (this == obj)
			return true;
		
		if (obj == null)
			return false;
		
		if (!(obj instanceof Catalog))
			return false;
		
		Catalog other = (Catalog) obj;
		if (name == null)
		{
			if (other.name != null)
				return false;
		}
		else if (!name.equals (other.name))
			return false;
		
		if (overlap != other.overlap)
			return false;
		
		if (path == null)
		{
			if (other.path != null)
				return false;
		}
		else if (!path.equals (other.path))
			return false;
		
		return true;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString ()
	{
		StringBuilder builder = new StringBuilder ();
		builder.append ("Catalog [");
		if (name != null)
		{
			builder.append ("name = ");
			builder.append (name);
			builder.append (", ");
		}
		if (path != null)
		{
			builder.append ("path = ");
			builder.append (path);
			builder.append (", ");
		}
		builder.append ("overlap = ");
		builder.append (overlap);
		builder.append ("]");
		return builder.toString ();
	}
	
}
