/**
 * bior_pipeline
 *
 * <p>@author Gregory Dougherty</p>
 * Copyright Mayo Clinic, 2014
 *
 */
package edu.mayo.bior.pipes.history;

import java.util.NoSuchElementException;
import com.tinkerpop.pipes.AbstractPipe;

/**
 * This pipe takes input lines, and puts a single '#' in front of the first line that does not have 
 * one or more '#' at the beginning of the line
 *
 * <p>@author Gregory Dougherty</p>
 */
public class MakeFirstLineHeaderPipe extends AbstractPipe<String, String>
{
	private boolean done;
	
	/**
	 * Constructor
	 */
	public MakeFirstLineHeaderPipe ()
	{
		done = false;
	}
	
	
	/* (non-Javadoc)
	 * @see com.tinkerpop.pipes.AbstractPipe#processNextStart()
	 */
	@Override
	protected String processNextStart () throws NoSuchElementException
	{
		String	line = this.starts.next ();
		
		if (!done)
		{
			if (!line.isEmpty () && !line.startsWith ("#"))
			{
				done = true;
				line = '#' + line;
			}
		}
		
		return line;
	}
	
}
