package edu.mayo.bior.pipeline.createcatalog;

import java.io.IOException;
import java.util.NoSuchElementException;

import net.sf.samtools.util.BlockCompressedOutputStream;

import com.tinkerpop.pipes.AbstractPipe;


/** Create bgzip file and its associated tabix index (if requested) */
public class BgzipWriterString extends AbstractPipe<String, String> {
		
	private String mBgzipOutFilePath;
	private BlockCompressedOutputStream mBgzipOutStream;
	
	/**
	 * Write all lines to a bgzip file
	 * @param bgzipOutFilePath Path to bgzip file
	 */
	public BgzipWriterString(String bgzipOutFilePath) {
		mBgzipOutFilePath = bgzipOutFilePath; 
	}

	@Override
	protected String processNextStart() throws NoSuchElementException {
		try {
			// Get next data line and write it out to the bgzip file, then return it
			// If there is no more data it will throw a NoSuchElementException and catch it below
			String nextLine = this.starts.next();

			if( mBgzipOutStream == null )
				mBgzipOutStream = new BlockCompressedOutputStream(mBgzipOutFilePath, 9);

			mBgzipOutStream.write( (nextLine + "\n").getBytes());
			return nextLine;
		}catch(NoSuchElementException noSuchExc) {
			try {
				// Since we have no more data, close the bgzip stream
				mBgzipOutStream.close();
			} catch(Exception e) {
				e.printStackTrace();
				throw new NoSuchElementException("Error closing the bgzip stream: " + e.getMessage());
			}

			throw new NoSuchElementException("No more data");
		}catch(IOException e) {
			e.printStackTrace();
			throw new NoSuchElementException("Error writing to bgzip file");
		}catch(Exception e) {
			e.printStackTrace();
			throw new NoSuchElementException("Error creating tabix file");
		}
	}

}
