package edu.mayo.bior.cli.cmd;

import java.util.Properties;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

import edu.mayo.bior.pipeline.TjsonToVcfPipe;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;

/** The bior_tjson_to_vcf command plugin.
 * This builds the first 8 columns of a VCF file from JSON (if not already in VCF format)
 * and collapses all BioR columns into the INFO column (unless the user chooses to keep the columns)
 * 
 * @author Michael Meiners (m054457)
 */
public class TjsonToVcfCommand implements CommandPlugin {

	private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
	
	private static final char OPTION_JSON_COL_FROM_WHICH_TO_BUILD_VCF = 'c';
	private static final char OPTION_IS_KEEP_ALL_COLUMNS = 'k';
	private static final char OPTION_IS_NOT_ADD_DATA_TO_INFO_COL = 'n';
	// by default, JSON columns will NOT be added to the INFO column, even if other cols are
	private static final char OPTION_IS_ADD_JSON_TO_INFO = 'j';
	private static final char OPTION_COLUMN_RANGES_TO_COLLAPSE = 'r';

	
	public void init(Properties props) throws Exception {
	}

	public void execute(CommandLine cmdLine, Options opts) throws Exception {
		// Get the column if it is specified
		int jsonColToBuildVcfColsFrom = Integer.parseInt(cmdLine.getOptionValue(OPTION_JSON_COL_FROM_WHICH_TO_BUILD_VCF, "-1"));
		boolean isKeepAllColumns = cmdLine.hasOption(OPTION_IS_KEEP_ALL_COLUMNS);
		boolean isAddDataToInfo  = ! cmdLine.hasOption(OPTION_IS_NOT_ADD_DATA_TO_INFO_COL);
		boolean isAddJsonToInfo  = cmdLine.hasOption(OPTION_IS_ADD_JSON_TO_INFO);
		String columnRangeToCollapseIntoInfoCol = cmdLine.getOptionValue(OPTION_COLUMN_RANGES_TO_COLLAPSE, "");
		
		TjsonToVcfPipe tjsonToVcfPipe = new TjsonToVcfPipe(jsonColToBuildVcfColsFrom, isKeepAllColumns, isAddDataToInfo, isAddJsonToInfo, columnRangeToCollapseIntoInfoCol);
		
		mPipeline.execute(new HistoryInPipe(), tjsonToVcfPipe, new HistoryOutPipe());		
	}
}
