/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package edu.mayo.bior.cli.cmd;

import java.io.File;
import java.util.Properties;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

import com.tinkerpop.pipes.Pipe;

import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.bior.util.CatalogUtils;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.JSON.tabix.OverlapPipe;
import edu.mayo.pipes.bioinformatics.sequence.Bed2SequencePipe;
import edu.mayo.pipes.bioinformatics.sequence.RefAllelePipe;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import edu.mayo.pipes.util.metadata.Metadata.CmdType;


/**
 * Created: 2014-03-03
 * @author Michael Meiners (m054457)
 */
public class RefAlleleCommand implements CommandPlugin {
    
	private static final char OPTION_CATALOG_FILE = 'd'; //-d usually means 'database' in the BioR case, it is a catalog
	private static final char OPTION_COLUMN = 'c';
		
	private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
	private String operation;
	
	public void init(Properties props) throws Exception {
		operation = props.getProperty("command.name");
	}

	public void execute(CommandLine line, Options opts) throws Exception {
	
		String catalogFile = "";
		if (line.hasOption(OPTION_CATALOG_FILE)) {
			catalogFile = line.getOptionValue(OPTION_CATALOG_FILE);
			CatalogUtils.warnIfDeprecated(catalogFile);
		}
        
		// default column is last column (e.g. -1)
		int jsonColumn = -1;
		if (line.hasOption(OPTION_COLUMN)) {
			jsonColumn = Integer.parseInt(line.getOptionValue(OPTION_COLUMN));
		}
		
		Metadata metadata = new Metadata(new File(catalogFile).getCanonicalPath(), operation);
		
		Pipe<String,  History>  preLogic  = new HistoryInPipe(metadata);
		Pipe<History, History>  logic     = new RefAllelePipe(catalogFile, jsonColumn);
		Pipe<History, String>   postLogic = new HistoryOutPipe();
		
		mPipeline.execute(preLogic, logic, postLogic);		
	}
}
