package edu.mayo.bior.catalog.markdown;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.configuration.PropertiesConfiguration;

import edu.mayo.bior.catalog.CatalogDataSource;
import edu.mayo.pipes.history.ColumnMetaData;

public class MarkdownInfo {
	public String title;
	public String purpose;
	public List<String> citationList = new ArrayList<String>();
	public String whatIsNew;
	public String whatIsImportant;
	
	// Technical specs:
	//   datasource.properties
	public CatalogDataSource datasourceProperties;
	//   columns.tsv
	public List<ColumnMetaData> columns;
	
	// List of question/answer sets - these should come from a markdown file, where it has lists of:
	// Q: <question>
	// A: <answer>
	// Where the <answer may contain more markdown
	public List<FAQ> frequentlyAskedQuestions = new ArrayList<FAQ>();
	
	// Refdata - one source
	// Can possibly get this fro the "build" subdirectory if it's there in the build_info.txt file
	public File refdataSourceDir;
	
	// Catalog path
	// What to do about multiple BioR-versions of the same catalog (ex: variants.v1, variants.v2, variants.v3)
	// Will each BioR-version have it's own markdown file?
	public File  catalogTsvBgzFile;
	
	// Deprecation notes
	// Again, if we have multiple BioR-versions of the same catalog  (ex: variants.v1, variants.v2, variants.v3),
	// we will need to have multiple deprecation notes
	public String  deprecationNotes;
	
	// License
	public String license;
	
	/** The markdown output string */
	public String markdownOutputStr;
	
	public File markdownOutputFile;
}
