package edu.mayo.bior.catalog;

public enum HumanBuildAssembly
{
   GRCh37,
   GRCh38,
   NA;

   public static HumanBuildAssembly assemblyFromString(String possibleBuildAssembly)
   {
      if( possibleBuildAssembly == null ) {
        return HumanBuildAssembly.NA;
      } else if (possibleBuildAssembly.trim().toLowerCase().startsWith(HumanBuildAssembly.GRCh37.name().toLowerCase())) {
         return HumanBuildAssembly.GRCh37;
      } else if (possibleBuildAssembly.trim().toLowerCase().startsWith(HumanBuildAssembly.GRCh38.name().toLowerCase())) {
         return HumanBuildAssembly.GRCh38;
      }
      // Else, no match, so return NA
      // (could be a gene-based or other non-assembly-related catalog 
      // or non-human assembly,
      // or maybe it's an older or newer human assembly we don't recognize here)
      return HumanBuildAssembly.NA;
   }
}


