package edu.mayo.bior.catalog;


public enum DataSourceKey {
	/** Short name that should be unique (or mostly unique except for fixes to existing catalog) across all catalogs. Ex: dbSNP_142_GRCh37p13 */
	ShortUniqueName,
	
	/** Description of catalog.  Ex: NCBI's dbSNP Variant Database */
	Description,
	
	/** Source of data, without point release, etc.  Ex: dbSNP */
	Source,
	
	/** Type of data.  Ex: Variants.  This fields is required as of catalog format 1.1.0 */
	Dataset,
	
	/** Version of the data source.  Ex: 142 */
	Version,
	
	/** The Genome build/assembly.  Ex: GRCh37.p13 */
	Build,
	
	/** The BioR catalog compatibility format.  Ex: 1.1.0 */
	Format,
	
	/** The date the source data was released to the public (not the date the catalog was built).  In format: YYYY-MM-DD.  This field is required as of catalog format 1.1.1 */
	DataSourceReleaseDate
	
};
